/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog;

import com.huawei.ism.tool.obase.config.validate.AbstractValidator;
import com.huawei.ism.tool.obase.entity.Socks5Proxy;
import com.huawei.ism.tool.obase.ui.dialogs.PublicDialog;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class ProxyDialog
extends PublicDialog {
    private static final long serialVersionUID = -6551092639585479194L;
    private static final int WEIGHT_SIZE = 450;
    private static final int HEIGHT_SIZE = 260;
    private static final int INT_5 = 5;
    private Socks5Proxy proxy = null;
    private boolean okClick = false;
    private JLabel nameLabel = UiMethod.createLabel((String)ResourceUtil.getString((String)"text.socks5.name"));
    private JTextField nameField = UiMethod.getUsernameFiled();
    private JLabel ipLabel = UiMethod.createLabel((String)ResourceUtil.getString((String)"text.socks5.ip"));
    private JTextField ipField = UiMethod.createIpv4v6TextField();
    private JLabel portLabel = UiMethod.createLabel((String)ResourceUtil.getString((String)"text.socks5.port"));
    private JTextField portField = IsmTextField.getRegexTextField((String)"\\d{1,5}", (int)5);
    private JCheckBox authCheckBox = new JCheckBox(ResourceUtil.getString((String)"text.socks5.authentic"));
    private JLabel userLabel = UiMethod.createLabel((String)ResourceUtil.getString((String)"text.socks5.user"));
    private JTextField userField = UiMethod.getUsernameFiled();
    private JLabel passLabel = UiMethod.createLabel((String)ResourceUtil.getString((String)"text.socks5.pass"));
    private JPasswordField passField = UiMethod.getPasswordFiled();
    private List<Socks5Proxy> existingProxies = new ArrayList<Socks5Proxy>();

    public ProxyDialog(JDialog parent, List<Socks5Proxy> proxyList, Socks5Proxy proxy) {
        super(parent);
        this.proxy = proxy;
        this.setSize(450, 260);
        this.setResizable(false);
        this.initUI();
        if (null == proxy) {
            this.setTitle(ResourceUtil.getString((String)"text.socks5.add"));
            this.changeAuthStatus(false);
        } else {
            this.setTitle(ResourceUtil.getString((String)"text.socks5.modify"));
            this.initData(proxy);
        }
        if (null != proxyList) {
            this.existingProxies.addAll(proxyList);
        }
        this.initValidation();
        this.initListener();
        this.setCompName();
    }

    public ProxyDialog(JDialog parent, List<Socks5Proxy> proxyList) {
        this(parent, proxyList, null);
    }

    public boolean isOkClick() {
        return this.okClick;
    }

    public Socks5Proxy getProxy() {
        return this.proxy;
    }

    private void doOk() {
        if (super.validateInput()) {
            if (null == this.proxy) {
                this.proxy = new Socks5Proxy();
            }
            String pwd = new String(this.passField.getPassword());
            this.proxy.setName(this.nameField.getText());
            this.proxy.setServerIp(this.ipField.getText());
            this.proxy.setPort(this.portField.getText());
            this.proxy.setUser(this.userField.getText());
            this.proxy.setPass(pwd);
            this.proxy.setAuthentic(this.authCheckBox.isSelected());
            com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)pwd);
            if (!this.proxy.isAuthentic()) {
                this.proxy.setUser("");
                this.proxy.setPass("");
            }
            this.okClick = true;
            this.setVisible(false);
        }
    }

    private void initUI() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gCtrnts = new GridBagConstraints();
        gCtrnts.fill = 1;
        gCtrnts.anchor = 17;
        gCtrnts.insets = new Insets(0, 0, 12, 12);
        gCtrnts.gridy = 0;
        gCtrnts.gridx = 0;
        gCtrnts.weightx = 0.0;
        mainPanel.add((Component)this.nameLabel, gCtrnts);
        gCtrnts.gridx = 1;
        gCtrnts.weightx = 1.0;
        mainPanel.add((Component)this.nameField, gCtrnts);
        gCtrnts.gridy = 1;
        gCtrnts.insets = new Insets(0, 0, 24, 12);
        gCtrnts.gridx = 0;
        gCtrnts.weightx = 0.0;
        mainPanel.add((Component)this.ipLabel, gCtrnts);
        gCtrnts.gridx = 1;
        gCtrnts.weightx = 1.0;
        mainPanel.add((Component)this.ipField, gCtrnts);
        gCtrnts.gridx = 2;
        gCtrnts.weightx = 0.0;
        mainPanel.add((Component)this.portLabel, gCtrnts);
        gCtrnts.gridx = 3;
        gCtrnts.weightx = 1.0;
        mainPanel.add((Component)this.portField, gCtrnts);
        gCtrnts.gridy = 2;
        gCtrnts.insets = new Insets(0, 0, 12, 12);
        gCtrnts.gridx = 0;
        gCtrnts.weightx = 0.0;
        mainPanel.add((Component)this.authCheckBox, gCtrnts);
        gCtrnts.gridy = 3;
        gCtrnts.gridx = 0;
        gCtrnts.weightx = 0.0;
        mainPanel.add((Component)this.userLabel, gCtrnts);
        gCtrnts.gridx = 1;
        gCtrnts.weightx = 1.0;
        mainPanel.add((Component)this.userField, gCtrnts);
        gCtrnts.gridx = 2;
        gCtrnts.weightx = 0.0;
        mainPanel.add((Component)this.passLabel, gCtrnts);
        gCtrnts.gridx = 3;
        gCtrnts.weightx = 1.0;
        mainPanel.add((Component)this.passField, gCtrnts);
        JComponent virtComp = UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createVerticalStrut(0), mainPanel});
        JComponent horiComp = UCD.buildHorizotalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(0), virtComp});
        this.getContentPanel().setLayout(new BorderLayout());
        this.getContentPanel().add((Component)horiComp, "North");
    }

    private void initData(Socks5Proxy socks5Proxy) {
        this.nameField.setText(socks5Proxy.getName());
        this.ipField.setText(socks5Proxy.getServerIp());
        this.portField.setText(socks5Proxy.getPort());
        this.userField.setText(socks5Proxy.getUser());
        this.passField.setText(socks5Proxy.getPass());
        this.changeAuthStatus(socks5Proxy.isAuthentic());
    }

    private void initValidation() {
        super.addValidation((JComponent)this.nameField, this.nameLabel, "CommonValidators.NotNull", new Object[0]);
        super.addValidator((AbstractValidator)new DupNameValidator());
        super.addValidations((JComponent)this.ipField, this.ipLabel, new String[]{"CommonValidators.NotNull", "CommonValidators.Ipv4v6"});
        super.addValidation((JComponent)this.portField, this.portLabel, "CommonValidators.NotNull", new Object[0]);
        super.addValidation((JComponent)this.portField, this.portLabel, "CommonValidators.Max", new Object[]{"65535"});
        super.addValidator((AbstractValidator)new UserPassValidator());
    }

    private void initListener() {
        JButton okBtn = this.getOkBtn();
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxyDialog.this.doOk();
            }
        });
        this.authCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxyDialog.this.authCheckBoxUserInfoStatus(ProxyDialog.this.authCheckBox.isSelected());
            }
        });
    }

    private void changeAuthStatus(boolean authentic) {
        this.authCheckBox.setSelected(authentic);
        this.changeUserInfoStatus(authentic);
    }

    private void authCheckBoxUserInfoStatus(boolean authentic) {
        String waringMsg;
        WarningDialog wrDlg;
        if (this.authCheckBox.isSelected() && 0 != (wrDlg = DialogUtils.showYesNoDialog((Window)((Object)this), (String)(waringMsg = ResourceUtil.getString((String)"toolbox.sock5.risk")))).getValue()) {
            this.authCheckBox.setSelected(false);
            return;
        }
        this.changeUserInfoStatus(authentic);
    }

    private void changeUserInfoStatus(boolean authentic) {
        this.userField.setEnabled(authentic);
        this.passField.setEnabled(authentic);
    }

    public void setCompName() {
        this.nameField.setName("_TextField_nameField");
        this.ipField.setName("_TextField_ipField");
        this.portField.setName("_TextField_portField");
        this.authCheckBox.setName("_CheckBox_authCheckBox");
        this.userField.setName("_TextField_userField");
        this.passField.setName("_TextField_passField");
    }

    private class UserPassValidator
    extends AbstractValidator {
        private UserPassValidator() {
        }

        public boolean validate(Object object, String objectDesc, Object ... params) {
            if (!ProxyDialog.this.authCheckBox.isSelected()) {
                return true;
            }
            if (StringUtils.isNULLStr((String)ProxyDialog.this.userField.getText())) {
                super.setErrMsg(ResourceUtil.getStringWithParams((String)"error.socks5.notnull", (Object[])new Object[]{ResourceUtil.getString((String)"text.socks5.user")}));
                return false;
            }
            if (ProxyDialog.this.passField.getPassword().length == 0) {
                super.setErrMsg(ResourceUtil.getStringWithParams((String)"error.socks5.notnull", (Object[])new Object[]{ResourceUtil.getString((String)"text.socks5.pass")}));
                return false;
            }
            return true;
        }
    }

    private class DupNameValidator
    extends AbstractValidator {
        private DupNameValidator() {
        }

        public boolean validate(Object object, String objectDesc, Object ... params) {
            String name = ProxyDialog.this.nameField.getText();
            String uuid = null == ProxyDialog.this.proxy ? null : ProxyDialog.this.proxy.getUuid();
            for (Socks5Proxy p : ProxyDialog.this.existingProxies) {
                if (!p.getName().equals(name) || p.getUuid().equals(uuid)) continue;
                ProxyDialog.this.nameField.requestFocusInWindow();
                super.setErrMsg(ResourceUtil.getStringWithParams((String)"error.socks5.name.duplicate", (Object[])new Object[]{name}));
                return false;
            }
            return true;
        }
    }
}

