/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog;

import com.huawei.ism.tool.devicemanager.ui.former.SceneProductParser;
import com.huawei.ism.tool.devicemanager.utils.DeviceAddUtil;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import utils.Products;

public class ShowSupportDevLayout
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Map<String, String> showInfos = new HashMap<String, String>();
    private String[] columnNames = new String[]{ResourceUtil.getString((String)"scene.adddialog.proxysetting.devmodel"), ResourceUtil.getString((String)"scene.adddialog.proxysetting.devversion")};
    private JLabel infoLabel = new JLabel(ResourceUtil.getString((String)"scene.adddialog.proxysetting.remind"));
    private DefaultTableModel model;
    private IsmTable table;
    private TableScrollPane tableScrollPane;
    private JButton closeBtn;

    public ShowSupportDevLayout() {
        this.initComponent();
        this.layoutComponents();
        this.initData();
        this.initTable();
    }

    private void initComponent() {
        this.model = new DefaultTableModel(this.columnNames, null);
        this.table = new IsmTable((TableModel)this.model);
        this.setCloseBtn(UiMethod.createButton((String)ResourceUtil.getString((String)"scene.adddialog.proxysetting.ok"), (char)'O'));
    }

    private void layoutComponents() {
        this.tableScrollPane = new TableScrollPane(false, true, false, this.table);
        JComponent view = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((Component[])new Component[]{this.infoLabel}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.tableScrollPane}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{Box.createHorizontalGlue(), this.closeBtn})});
        this.setLayout(new BoxLayout(this, 0));
        this.add(view);
        this.add((Component)UiMethod.buildFrameSpace((JComponent)view, (int)12), "Center");
    }

    private void initData() {
        SceneProductParser parser = new SceneProductParser();
        this.showInfos = parser.parse();
    }

    private void initTable() {
        for (String key : this.showInfos.keySet()) {
            String info = this.showInfos.get(key);
            this.model.addRow(new TableRow[]{this.createTableRow(key, info)});
        }
    }

    private TableRow<String, String> createTableRow(String devModel, String info) {
        DefaultTableRow row = new DefaultTableRow(this.columnNames.length, (Object)devModel);
        row.setValueAt(0, (Object)devModel);
        row.setValueAt(1, (Object)info);
        return row;
    }

    public boolean isSupport(DevNode dev) {
        if (DeviceAddUtil.isReplaceCertScene() && ItDeviceType.Host.equals((Object)dev.getItDeviceType())) {
            return true;
        }
        Iterator<String> iterator = this.showInfos.keySet().iterator();
        boolean flag = false;
        while (iterator.hasNext()) {
            String[] versions;
            String key = iterator.next().trim();
            String value = this.showInfos.get(key).trim();
            for (String version : versions = value.split(",")) {
                if (!key.equals(String.valueOf(dev.getDeviceType())) || !Products.contains((String)dev.getProductVersion(), (String)version)) continue;
                flag = true;
            }
        }
        return flag;
    }

    public void setModel(DefaultTableModel model) {
        this.model = model;
    }

    public DefaultTableModel getModel() {
        return this.model;
    }

    public void setTable(IsmTable table) {
        this.table = table;
    }

    public IsmTable getTable() {
        return this.table;
    }

    public void setCloseBtn(JButton closeBtn) {
        this.closeBtn = closeBtn;
    }

    public JButton getCloseBtn() {
        return this.closeBtn;
    }

    public String[] getColumnNames() {
        return (String[])this.columnNames.clone();
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = (String[])columnNames.clone();
    }

    public Map<String, String> getShowInfos() {
        return this.showInfos;
    }
}

