/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog.listener;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.dialog.SceneDeviceAddDialog;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.service.FusionComputeAddService;
import com.huawei.ism.tool.devicemanager.ui.dialog.layout.fusioncompute.AddFusionComputeLayout;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.FsDevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.ui.swing.dialog.CustMsgProgressDialog;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionComputeConfirmAction
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(FusionComputeConfirmAction.class);
    private final SceneDeviceAddDialog parentDialog;
    private final AddFusionComputeLayout addFusionComputeLayout;

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.addFusionComputeLayout.validInput()) {
            return;
        }
        FsDevNode computeNode = this.addFusionComputeLayout.creatDevNode();
        CustMsgProgressDialog custMsgProgressDialog = new CustMsgProgressDialog((Window)this.parentDialog);
        FusionComputeAddService cubeDeviceAddService = new FusionComputeAddService(computeNode, custMsgProgressDialog);
        Future submit = AsyncExcutor.submit((Callable)cubeDeviceAddService);
        if (custMsgProgressDialog.isDisplayable()) {
            custMsgProgressDialog.setVisible(true);
        }
        this.parseResult(submit, computeNode);
    }

    private void parseResult(Future<TaskResult> submit, FsDevNode computeNode) {
        try {
            TaskResult result = submit.get();
            if (result.getResult() != TaskResult.Result.SUCCESS) {
                DialogUtils.showInfoDialog((JDialog)this.parentDialog, (String)result.getErrorLocaleDescription());
                return;
            }
            this.parentDialog.dispose();
            DefaultNodeProviderImpl.getInstance().addNode((DevNode)computeNode);
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("get login result for device :{} error", (Object)computeNode.getIp(), (Object)e);
        }
        catch (ToolException e) {
            log.error("add cube node error", (Throwable)e);
        }
    }

    public FusionComputeConfirmAction(SceneDeviceAddDialog parentDialog, AddFusionComputeLayout addFusionComputeLayout) {
        this.parentDialog = parentDialog;
        this.addFusionComputeLayout = addFusionComputeLayout;
    }
}

