/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.former;

import com.huawei.ism.tool.devicemanager.ui.context.DeviceSceneContext;
import com.huawei.ism.tool.devicemanager.ui.former.service.IntelligentComputeSceneImpl;
import com.huawei.ism.tool.devicemanager.ui.former.service.NodeSceneOptionService;
import com.huawei.ism.tool.devicemanager.ui.former.service.ReplaceSceneDeviceImpl;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.json.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceSaveServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(DeviceSaveServiceFactory.class);
    private static final List<Function<JSONObject, Optional<NodeSceneOptionService<?>>>> JUDGE_SCENE_FUNC = new ArrayList();

    public static Optional<? extends NodeSceneOptionService<?>> buildServiceByScene() {
        JSONObject sceneJson = DeviceSceneContext.getInstance().getSceneJson();
        log.info("build scene node option service, scene :{} ", (Object)sceneJson);
        if (Objects.isNull(sceneJson)) {
            return Optional.empty();
        }
        return JUDGE_SCENE_FUNC.stream().map(func -> (Optional)func.apply(sceneJson)).filter(Optional::isPresent).map(Optional::get).findAny();
    }

    public static Optional<? extends NodeSceneOptionService<?>> buildServiceByEnvScene() {
        String jsonScene = System.getenv("jsonScene");
        log.info("build scene node option service, scene :{} ", (Object)jsonScene);
        if (StringUtils.isNULLStr((String)jsonScene)) {
            return Optional.empty();
        }
        JSONObject sceneJson = new JSONObject(jsonScene);
        return JUDGE_SCENE_FUNC.stream().map(func -> (Optional)func.apply(sceneJson)).filter(Optional::isPresent).map(Optional::get).findAny();
    }

    private static Optional<NodeSceneOptionService<?>> judgeReplaceScene(JSONObject jsonObject) {
        if (jsonObject.getStringOrDefault("subScene", "").contains("ReplacingCertificates")) {
            return Optional.of(new ReplaceSceneDeviceImpl());
        }
        return Optional.empty();
    }

    private static Optional<NodeSceneOptionService<?>> judgeIntelligentComputeScene(JSONObject jsonObject) {
        String field = jsonObject.getStringOrDefault("field", "");
        String subFiled = jsonObject.getStringOrDefault("sub_field", "");
        if (StringUtils.isNULLStr((String)field) || StringUtils.isNULLStr((String)subFiled)) {
            return Optional.empty();
        }
        if (!"Solution".equals(field) || !"INTELLIGENTCOMPUTE".equals(subFiled)) {
            return Optional.empty();
        }
        return Optional.of(new IntelligentComputeSceneImpl());
    }

    static {
        JUDGE_SCENE_FUNC.add(DeviceSaveServiceFactory::judgeReplaceScene);
        JUDGE_SCENE_FUNC.add(DeviceSaveServiceFactory::judgeIntelligentComputeScene);
    }
}

