/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.listener.verify;

import com.huawei.ism.tool.devicemanager.ui.inputconfirm.DangerConfirmDialog;
import com.huawei.ism.tool.devicemanager.ui.listener.verify.Verifier;
import com.huawei.ism.tool.devicemanager.ui.listener.verify.VerifyResult;
import com.huawei.ism.tool.devicemanager.utils.DeviceAddUtil;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JDialog;

public class CubeSelectVerifier
implements Verifier {
    @Override
    public VerifyResult verify(JDialog parent, String scene, List<DevNode> selectedNodes) {
        VerifyResult result = new VerifyResult();
        if (!DeviceAddUtil.isReplaceCertScene()) {
            return result;
        }
        List nodes = selectedNodes.stream().filter(node -> ItDeviceType.FUSIONCUBE.equals((Object)node.getItDeviceType())).collect(Collectors.toList());
        if (nodes.isEmpty()) {
            return result;
        }
        for (DevNode node2 : nodes) {
            String warning = ResourceUtil.getString((String)"add.device.warning");
            warning = MessageFormat.format(warning, node2.getProductVersion());
            String msg = "<html><body style='display: flex; justify-content: center; align-items: center; height: 100%;'><div>" + warning + "</div></body></html>";
            DangerConfirmDialog dangerConfirmDialog = new DangerConfirmDialog((Window)parent, msg, ResourceUtil.getString((String)"compare.msg"));
            dangerConfirmDialog.setVisible(true);
            if (dangerConfirmDialog.isConfirm()) continue;
            result.setVerifySuccess(false);
            return result;
        }
        return result;
    }
}

