/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.utils;

import com.huawei.ism.tool.devicemanager.ui.context.DeviceSceneContext;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.entity.SceneValue;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import com.huawei.json.JSONObject;
import org.slf4j.Logger;

public class SceneParser {
    public static final String SUBSCENE = "subScene";
    private static final SceneParser INSTANCE = new SceneParser();
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SceneParser.class);
    private static final String MAINSCENE = "mainScene";
    private static final boolean IS_UNION_DEVICE = false;

    private SceneParser() {
    }

    public static SceneParser getInstance() {
        return INSTANCE;
    }

    public String getMainScene() {
        JSONObject sceneJson = DeviceSceneContext.getInstance().getSceneJson();
        if (null == sceneJson) {
            LOGGER.error("Sence para(JSONObject) is null.");
            return "";
        }
        return sceneJson.get(MAINSCENE).toString();
    }

    public String getSubScene() {
        JSONObject sceneJson = DeviceSceneContext.getInstance().getSceneJson();
        if (null == sceneJson) {
            LOGGER.error("Sence para(JSONObject) is null.");
            return "";
        }
        return sceneJson.get(SUBSCENE).toString();
    }

    public static String getJsonSceneAttr() {
        try {
            SceneValue bean = (SceneValue)SceneEnvironmentImpl.getInstance().getEnvirValueByKey("jsonScene");
            if (bean == null) {
                return null;
            }
            return bean.getSubScene();
        }
        catch (Exception e) {
            LOGGER.error("get SceneAttr is null.");
            return null;
        }
    }

    public static boolean isIsuniondevice() {
        JSONObject sceneJson = DeviceSceneContext.getInstance().getSceneJson();
        if (null == sceneJson) {
            LOGGER.error("Sence para(JSONObject) is null.");
            return false;
        }
        return (Boolean)sceneJson.get("unionDeviceList");
    }
}

