/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.component.checkboxtree;

import com.huawei.ism.tool.base.ui.component.checkboxtree.CheckLabelPanel;
import com.huawei.ism.tool.base.ui.component.checkboxtree.CheckTreeCellEditor;
import com.huawei.ism.tool.base.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.base.ui.component.checkboxtree.CheckTreeNodeRenderer;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CheckBoxTree
extends JTree {
    private static final long serialVersionUID = 7804675481950571764L;
    private CheckTreeNodeRenderer checkTreeNodeRenderer;

    public CheckBoxTree(CheckTreeNode rootNode, boolean hasCheckBox) {
        super(rootNode, true);
        this.installRenderer(hasCheckBox);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public String getToolTipText(MouseEvent ev) {
        if (ev == null) {
            return null;
        }
        TreePath path = this.getPathForLocation(ev.getX(), ev.getY());
        if (path != null) {
            CheckTreeNode node = (CheckTreeNode)path.getLastPathComponent();
            return node.getToolTips();
        }
        return null;
    }

    private void installRenderer(boolean hasCheckBox) {
        this.checkTreeNodeRenderer = new CheckTreeNodeRenderer(hasCheckBox);
        this.setCellRenderer(this.checkTreeNodeRenderer);
        this.setCheckTreeNodeRenderer(this.checkTreeNodeRenderer);
        CheckTreeCellEditor cellEditor = new CheckTreeCellEditor(new CheckLabelPanel(hasCheckBox));
        this.setCellEditor(cellEditor);
        this.setEditable(true);
        this.setRootVisible(false);
        this.setEnabled(true);
        this.expandAll(true);
    }

    @Override
    public JToolTip createToolTip() {
        JToolTip tip = new JToolTip();
        return tip;
    }

    public CheckTreeNodeRenderer getCheckTreeNodeRenderer() {
        return this.checkTreeNodeRenderer;
    }

    public void setCheckTreeNodeRenderer(CheckTreeNodeRenderer checkTreeNodeRenderer) {
        this.checkTreeNodeRenderer = checkTreeNodeRenderer;
    }

    public void expandAll(boolean isExpanded) {
        CheckTreeNode root = (CheckTreeNode)this.getModel().getRoot();
        if (null == root) {
            return;
        }
        this.expandPath(new TreePath(root), isExpanded);
    }

    private void expandPath(TreePath parent, boolean expand) {
        CheckTreeNode node = (CheckTreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                CheckTreeNode n = (CheckTreeNode)e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandPath(path, expand);
            }
        }
        if (expand) {
            this.expandPath(parent);
        } else {
            this.collapsePath(parent);
        }
    }

    public Set<CheckTreeNode> getAllSelectedNodes(CheckTreeNode rootNode) {
        HashSet<CheckTreeNode> allNodes = new HashSet<CheckTreeNode>();
        if (rootNode.getChildCount() >= 0) {
            Enumeration<TreeNode> e = rootNode.children();
            while (e.hasMoreElements()) {
                CheckTreeNode n = (CheckTreeNode)e.nextElement();
                if (n.isSelected()) {
                    allNodes.add(n);
                }
                allNodes.addAll(this.getAllSelectedNodes(n));
            }
        }
        return allNodes;
    }

    public Set<CheckTreeNode> getAllNodes(CheckTreeNode rootNode) {
        HashSet<CheckTreeNode> allNodes = new HashSet<CheckTreeNode>();
        if (rootNode.getChildCount() >= 0) {
            Enumeration<TreeNode> e = rootNode.children();
            while (e.hasMoreElements()) {
                CheckTreeNode n = (CheckTreeNode)e.nextElement();
                allNodes.add(n);
                allNodes.addAll(this.getAllNodes(n));
            }
        }
        return allNodes;
    }

    public CheckTreeNode getTreeNodeByUserObj(Object userObj) {
        Set<CheckTreeNode> allNode = this.getAllNodes((CheckTreeNode)this.getModel().getRoot());
        for (CheckTreeNode node : allNode) {
            if (userObj != node.getUserObject()) continue;
            return node;
        }
        return null;
    }
}

