/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.component.jlist;

import com.huawei.ism.tool.base.ui.component.jlist.ListItemType;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import java.awt.Component;
import java.awt.image.ImageObserver;
import java.util.UUID;
import javax.swing.ImageIcon;

public class StepListItem
extends Component {
    public static final int FIRST_LEVEL = 0;
    public static final int SECOND_LEVEL = 1;
    private static final long serialVersionUID = -4539519637435348233L;
    private static final ImageIcon SUCCESS_FIRST_IMAGE = ResourceUtil.getImage("success_1.png");
    private static final ImageIcon FAILED_FIRST_IMAGE = ResourceUtil.getImage("failed_1.png");
    private static final ImageIcon SUCCESS_SECOND_IMAGE = ResourceUtil.getImage("success_2.png");
    private static final ImageIcon FAILED_SECOND_IMAGE = ResourceUtil.getImage("failed_2.png");
    private static final ImageIcon LOADING_IMAGE = ResourceUtil.getImage("loading.gif");
    private int level = 0;
    private String uuid = null;
    private String content = null;
    private ListItemType stepType = ListItemType.RUNNING;
    private StepListItem parentItem = null;

    public StepListItem(String content, ListItemType stepType) {
        this.uuid = UUID.randomUUID().toString();
        this.content = content;
        this.stepType = stepType;
    }

    public StepListItem(String content, int level) {
        this.uuid = UUID.randomUUID().toString();
        this.content = content;
        this.level = level;
    }

    public StepListItem(String content, ListItemType stepType, int level) {
        this.uuid = UUID.randomUUID().toString();
        this.content = content;
        this.stepType = stepType;
        this.level = level;
    }

    public StepListItem(String content) {
        this(content, ListItemType.RUNNING);
    }

    public StepListItem getParentItem() {
        return this.parentItem;
    }

    public void setParentItem(StepListItem parent) {
        this.parentItem = parent;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public ListItemType getStepType() {
        return this.stepType;
    }

    public void setStepType(ListItemType stepType) {
        this.stepType = stepType;
    }

    public ImageIcon getImageIcon() {
        if (0 == this.level) {
            if (ListItemType.SUCCESS.equals((Object)this.stepType)) {
                return SUCCESS_FIRST_IMAGE;
            }
            if (ListItemType.FAILED.equals((Object)this.stepType)) {
                return FAILED_FIRST_IMAGE;
            }
            return LOADING_IMAGE;
        }
        if (ListItemType.SUCCESS.equals((Object)this.stepType)) {
            return SUCCESS_SECOND_IMAGE;
        }
        if (ListItemType.FAILED.equals((Object)this.stepType)) {
            return FAILED_SECOND_IMAGE;
        }
        return LOADING_IMAGE;
    }

    public static void setLoadingImageObserver(ImageObserver observer) {
        LOADING_IMAGE.setImageObserver(observer);
    }
}

