/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.component.treetable;

import com.huawei.ism.tool.base.ui.component.treetable.TreeTable;
import com.huawei.ism.tool.base.ui.component.treetable.TreeTableModel;
import com.huawei.ism.tool.base.ui.component.treetable.TreeTableUtils;
import com.huawei.ism.ui.swing.TernaryCheckBox;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class TreeTableNameRenderer
extends JPanel
implements TableCellRenderer {
    private static final long serialVersionUID = -8298967778107609000L;
    private static final int HOTSPOT_SIZE = 10;
    private JLabel textLabel = new JLabel();

    public TreeTableNameRenderer() {
        this.setLayout(new BoxLayout(this, 0));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (!(value instanceof TreeTableModel.RowItem)) {
            return this;
        }
        TreeTableModel.RowItem item = (TreeTableModel.RowItem)value;
        TreeTable treeTable = (TreeTable)((Object)table);
        int indentWidth = treeTable.getCheckBoxLeftIndent(item);
        int left = 10;
        if (!item.hasExpandAndCollapseIcon()) {
            left = indentWidth + 10;
        }
        JLabel iconLabel = new JLabel();
        this.add(Box.createHorizontalStrut(10));
        this.add(iconLabel);
        this.add(Box.createHorizontalStrut(left));
        Object checkBox = null;
        if (treeTable.isMutliSelected()) {
            checkBox = new TernaryCheckBox();
            if (treeTable.isCheckBoxVisiable()) {
                this.add((Component)checkBox);
                this.add(Box.createHorizontalStrut(10));
                if (null != item.getParent() && !treeTable.isChildCheckBoxVisiable()) {
                    ((JComponent)checkBox).setVisible(false);
                }
            }
        } else if (null == item.getParent()) {
            checkBox = new JRadioButton();
            this.add((Component)checkBox);
            this.add(Box.createHorizontalStrut(10));
        }
        this.add(this.textLabel);
        this.add(Box.createHorizontalGlue());
        if (item.hasExpandAndCollapseIcon()) {
            boolean toggleState = item.isVisible();
            Icon expandedIcon = (Icon)UIManager.get("Tree.expandedIcon");
            Icon collapsedIcon = (Icon)UIManager.get("Tree.collapsedIcon");
            Icon drawIcon = toggleState ? expandedIcon : collapsedIcon;
            iconLabel.setIcon(drawIcon);
        }
        this.textLabel.setText(item.getTableRow().getValue(column).toString());
        this.setSelectStatus(isSelected, item, (JComponent)checkBox);
        TreeTableUtils.setCompColor(this, isSelected, treeTable, row);
        return this;
    }

    private void setSelectStatus(boolean isSelected, TreeTableModel.RowItem item, JComponent selectComp) {
        if (null == selectComp) {
            return;
        }
        if (selectComp instanceof TernaryCheckBox) {
            TernaryCheckBox checkBox = (TernaryCheckBox)selectComp;
            checkBox.setSelected(isSelected);
            if (TreeTableModel.SelectType.HALF == item.getSelectType()) {
                checkBox.setPartialSelected(true);
            } else if (TreeTableModel.SelectType.UNSELECT == item.getSelectType()) {
                checkBox.setSelected(false);
            } else {
                checkBox.setSelected(true);
            }
        }
        if (selectComp instanceof JRadioButton) {
            JRadioButton radio = (JRadioButton)selectComp;
            radio.setSelected(item.getSelectType().equals((Object)TreeTableModel.SelectType.SELECT));
        }
    }
}

