/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.dialogs;

import com.huawei.ism.tool.base.validate.AbstractValidator;
import com.huawei.ism.tool.base.validate.CommonValidators;
import com.huawei.ism.tool.base.validate.ValidatorChain;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.text.IPAddressField;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import org.slf4j.Logger;

public class UiValidator {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(UiValidator.class);
    private static final Map<String, Class<? extends AbstractValidator>> VCLASSMAP = new HashMap<String, Class<? extends AbstractValidator>>();
    private List<ComponentValidation> compValidations = new ArrayList<ComponentValidation>();
    private ValidatorChain customizedValidators = new ValidatorChain();

    public void addValidation(JComponent component, JLabel lable, String validatorName, Object ... params) {
        AbstractValidator v = this.newValidatorInstance(validatorName);
        if (null != v) {
            ComponentValidation cv = new ComponentValidation(component, lable.getText(), v, params);
            this.compValidations.add(cv);
        }
    }

    public void addValidations(JComponent component, JLabel lable, String ... validatorNames) {
        ArrayList<AbstractValidator> validators = new ArrayList<AbstractValidator>();
        for (String vName : validatorNames) {
            AbstractValidator v = this.newValidatorInstance(vName);
            if (null == v) continue;
            validators.add(v);
        }
        AbstractValidator[] vArr = new AbstractValidator[validators.size()];
        this.addValidations(component, lable, validators.toArray(vArr));
    }

    public void addValidation(JComponent component, JLabel lable, AbstractValidator validator, Object ... params) {
        ComponentValidation cv = new ComponentValidation(component, lable.getText(), validator, params);
        this.compValidations.add(cv);
    }

    public void addValidations(JComponent component, JLabel lable, AbstractValidator ... validators) {
        ValidatorChain vChain = new ValidatorChain(Arrays.asList(validators));
        this.addValidation(component, lable, vChain, new Object[0]);
    }

    public void append(AbstractValidator validator) {
        this.customizedValidators.append(validator, new Object[0]);
    }

    public boolean validateInput(Window parent, Locale locale) {
        return this.validateInput(new ValidateMsgDisplayer(parent), locale);
    }

    public boolean validateInput(IValidateMsgDisplayer msgDisplayer, Locale locale) {
        boolean valid = true;
        JComponent component = null;
        AbstractValidator validator = null;
        Object value = null;
        for (ComponentValidation cv : this.compValidations) {
            component = cv.getComponent();
            validator = cv.getValidator();
            if (validator.validate(value = this.handleComponentVal(component, value), cv.getName(), cv.getParams())) continue;
            valid = false;
            msgDisplayer.display(validator.getErrMsg(locale));
            component.requestFocusInWindow();
            break;
        }
        valid = this.doIfValid(msgDisplayer, locale, valid);
        return valid;
    }

    private Object handleComponentVal(JComponent component, Object value) {
        Object result = value;
        if (component instanceof JTextComponent) {
            result = ((JTextComponent)component).getText();
        } else if (component instanceof IPAddressField) {
            String ip = ((IPAddressField)component).getIPText();
            ip = ip.trim().replace(". . .", "");
            result = ip;
        }
        return result;
    }

    private boolean doIfValid(IValidateMsgDisplayer msgDisplayer, Locale locale, boolean valid) {
        boolean result = valid;
        if (result && !(result = this.customizedValidators.validate(null, null, new Object[0]))) {
            msgDisplayer.display(this.customizedValidators.getErrMsg(locale));
        }
        return result;
    }

    private AbstractValidator newValidatorInstance(String vName) {
        Class<? extends AbstractValidator> validatorCls = VCLASSMAP.get(vName);
        if (null == validatorCls) {
            return null;
        }
        try {
            return validatorCls.newInstance();
        }
        catch (InstantiationException e) {
            LOGGER.error("Instantiation exception.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Illegal access exception.", (Throwable)e);
        }
        return null;
    }

    static {
        VCLASSMAP.put("CommonValidators.NotNull", CommonValidators.NotNull.class);
        VCLASSMAP.put("CommonValidators.NoChinese", CommonValidators.NoChinese.class);
        VCLASSMAP.put("CommonValidators.Mask", CommonValidators.Mask.class);
        VCLASSMAP.put("CommonValidators.Mac", CommonValidators.Mac.class);
        VCLASSMAP.put("CommonValidators.Macs", CommonValidators.Macs.class);
        VCLASSMAP.put("CommonValidators.Ipv4", CommonValidators.Ipv4.class);
        VCLASSMAP.put("CommonValidators.Max", CommonValidators.Max.class);
        VCLASSMAP.put("CommonValidators.Ipv4v6", CommonValidators.Ipv4v6.class);
    }

    private static class ComponentValidation {
        private JComponent component;
        private String name;
        private Object[] params;
        private AbstractValidator validator;

        public ComponentValidation(JComponent component, String name, AbstractValidator validator, Object ... params) {
            this.component = component;
            this.validator = validator;
            this.params = params;
            this.name = name.endsWith(":") ? name.substring(0, name.length() - 1) : name;
        }

        public JComponent getComponent() {
            return this.component;
        }

        public String getName() {
            return this.name;
        }

        public Object[] getParams() {
            return this.params;
        }

        public AbstractValidator getValidator() {
            return this.validator;
        }
    }

    public static interface IValidatorNameUser {
        public static final String V_NOTNULL = "CommonValidators.NotNull";
        public static final String V_NON_CHINESE = "CommonValidators.NoChinese";
        public static final String V_MASK = "CommonValidators.Mask";
        public static final String V_MAC = "CommonValidators.Mac";
        public static final String V_MAC_LIST = "CommonValidators.Macs";
        public static final String V_IPV4 = "CommonValidators.Ipv4";
        public static final String V_MAX = "CommonValidators.Max";
        public static final String V_IPV4V6 = "CommonValidators.Ipv4v6";
    }

    public static interface IValidateMsgDisplayer {
        public void display(String var1);
    }

    static class ValidateMsgDisplayer
    implements IValidateMsgDisplayer {
        Window parent;

        public ValidateMsgDisplayer(Window parent) {
            this.parent = parent;
        }

        @Override
        public void display(String msg) {
            DialogUtils.showInfoDialog((Window)this.parent, (String)msg);
        }
    }
}

