/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.wizard;

import com.huawei.ism.tool.base.flow.FlowException;
import com.huawei.ism.tool.base.flow.FlowFactory;
import com.huawei.ism.tool.base.flow.FlowState;
import com.huawei.ism.tool.base.flow.IFlow;
import com.huawei.ism.tool.base.flow.IFlowListener;
import com.huawei.ism.tool.base.flow.ui.IFlowUI;
import com.huawei.ism.tool.base.flow.ui.IFlowUIState;
import com.huawei.ism.tool.base.flow.ui.IStepUI;
import com.huawei.ism.tool.base.flow.ui.Title;
import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.component.wizard.IHelpActionCallBack;
import com.huawei.ism.tool.base.ui.component.wizard.WizardConstants;
import com.huawei.ism.tool.base.ui.component.wizard.WizardHeadPanel;
import com.huawei.ism.tool.base.ui.component.wizard.WizardRootPaneUI;
import com.huawei.ism.tool.base.ui.component.wizard.WizardStepGroup;
import com.huawei.ism.tool.base.ui.component.wizard.WizardStepItem;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCardLayout;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardState;
import com.huawei.ism.tool.base.ui.wizard.HelpManager;
import com.huawei.ism.tool.base.ui.wizard.WizardResource;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class FlowWizardFrame
extends JFrame
implements IFlowUI {
    private static final long serialVersionUID = 5329056444374574123L;
    private static final WizardResource RESOURCE = WizardResource.getInstance();
    private static final String TITLE_DECO_ZH = "\u5411\u5bfc \u6b65\u9aa4";
    private static final String TITLE_DECO_EN = " Wizard ";
    private static final int WIZARD_DIALOG_WIDTH = 885;
    private static final int WIZARD_DIALOG_HEIGHT = 600;
    protected List<Title> stageTitles = null;
    protected String wizardTitle = "";
    protected Locale loc = null;
    protected WizardHeadPanel stepsPanel = null;
    protected JPanel contentPane = null;
    protected Box southBox = Box.createVerticalBox();
    private Title flowTitle = null;
    private WizardRootPaneUI rootPaneUI = new WizardRootPaneUI();
    private WizardStepGroup stepsGroup = new WizardStepGroup();
    private Box navigationBar = null;
    private Map<Navigation, JButton> naviBtns = new HashMap<Navigation, JButton>();
    private IFlow iFlow = null;
    private String helpDir = null;
    private boolean isStandrad = true;

    public FlowWizardFrame(Window parent, Locale loc, FlowFactory flowFactory, String helpDir, boolean isStandrad, boolean showAbout, boolean showminimize) {
        this.loc = loc;
        this.helpDir = helpDir;
        this.isStandrad = isStandrad;
        this.rootPaneUI.setShowMinimize(showminimize);
        this.rootPaneUI.setShowAbout(showAbout);
        this.initWizard(flowFactory);
    }

    public void setAboutAction(Action aboutAction) {
        this.rootPaneUI.setAboutAction(aboutAction);
    }

    @Override
    public void initUIState(IFlowUIState state, List<JButton> operators) {
        this.updateNavigation((FlowWizardState)state, operators);
        this.repaint();
    }

    @Override
    public void changeUIState(IFlowUIState state) {
        this.changeEnableState((FlowWizardState)state);
    }

    @Override
    public void showStep(int index, IStepUI stepUI) {
        if (index < 0 || index > this.stepsGroup.getStepSize() || null == stepUI) {
            return;
        }
        this.updateContent(stepUI);
        this.updateTitle(index);
    }

    @Override
    public void init(Title ti, String flowHelp, List<Title> stageTitleList) {
        if (null == stageTitleList || stageTitleList.isEmpty()) {
            return;
        }
        String titleDeco = this.getTitleDeco();
        this.wizardTitle = ti.getName(this.loc) + titleDeco;
        this.stageTitles = stageTitleList;
        this.flowTitle = ti;
        if (null == flowHelp || flowHelp.isEmpty()) {
            this.rootPaneUI.setShowHelp(false);
        }
        this.getRootPane().setUI(this.rootPaneUI);
        this.initHelp(flowHelp);
        this.initUI();
    }

    protected String getTitleDeco() {
        return "zh".equalsIgnoreCase(this.loc.getLanguage()) ? TITLE_DECO_ZH : TITLE_DECO_EN;
    }

    public void addFlowListener(IFlowListener flowListener) {
        this.iFlow.addListener(flowListener);
    }

    public void initHelp(final String flowHelpStr) {
        if (null == flowHelpStr) {
            return;
        }
        HelpManager.createHelp(this.helpDir, flowHelpStr, this.loc);
        this.rootPaneUI.setHelpActionCallBack(new IHelpActionCallBack(){

            @Override
            public void doHelpActionWork() {
                HelpManager.openHelpFile(FlowWizardFrame.this.helpDir, flowHelpStr, FlowWizardFrame.this.loc);
            }

            @Override
            public String getListenerName() {
                return "Flow Wizard Help";
            }
        });
    }

    public Title getFlowTitle() {
        return this.flowTitle;
    }

    private void initWizard(FlowFactory factory) {
        this.initComponent();
        this.bondListener();
        try {
            this.iFlow = factory.createFlow(this);
        }
        catch (FlowException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error(e.getMessage());
        }
        this.iFlow.init();
    }

    @Override
    public void setVisible(boolean visible) {
        boolean actualVisible = visible;
        if (actualVisible && FlowState.READY == this.iFlow.getCurState()) {
            actualVisible = this.iFlow.start();
        }
        super.setVisible(actualVisible);
    }

    protected void updateTitle(int index) {
        Title subtitle = this.stageTitles.get(index);
        StringBuffer title = new StringBuffer();
        title.append(this.wizardTitle).append(" ");
        title.append(this.stageTitles.size()).append("-").append(index + 1).append(this.getColon()).append(subtitle.getName(this.loc));
        this.setTitle(title.toString());
        this.stepsGroup.setSelect(index);
    }

    private String getColon() {
        return "zh".equalsIgnoreCase(this.loc.getLanguage()) ? "\uff1a" : ": ";
    }

    private void updateContent(IStepUI stepUI) {
        FlowWizardCardLayout cardLayout = (FlowWizardCardLayout)stepUI;
        this.contentPane.removeAll();
        if (this.isStandrad) {
            this.contentPane.add(UiMethod.buildFrameSpace(cardLayout, 20));
        } else {
            this.contentPane.add(cardLayout);
        }
        this.contentPane.revalidate();
        this.contentPane.repaint();
        this.repaint();
    }

    private void addOperatorButtons(List<JButton> btns) {
        if (null == btns || btns.isEmpty()) {
            return;
        }
        for (JButton btn : btns) {
            this.navigationBar.add(Box.createHorizontalStrut(10));
            this.navigationBar.add(btn);
        }
    }

    private void updateNavigation(FlowWizardState state, List<JButton> btns) {
        this.navigationBar.removeAll();
        this.initButtonState();
        this.addOperatorButtons(btns);
        this.navigationBar.add(Box.createHorizontalGlue());
        switch (state) {
            case FIRST_STEP: {
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.NEXT));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.CANCEL));
                break;
            }
            case FIRST_STEP_RUNNING: {
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.NEXT));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.CANCEL));
                this.naviBtns.get((Object)Navigation.NEXT).setEnabled(false);
                break;
            }
            case SINGLE_STEP_SUCCESS: {
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.COMPLETE));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.CANCEL));
                break;
            }
            case SINGLE_STEP_FAILED: {
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.COMPLETE));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.CANCEL));
                this.naviBtns.get((Object)Navigation.COMPLETE).setEnabled(false);
                break;
            }
        }
        this.setThirdStep(state);
        this.setFourthStep(state);
        this.setFifthStep(state);
        this.navigationBar.add(Box.createHorizontalStrut(20));
    }

    private void setThirdStep(FlowWizardState state) {
        switch (state) {
            case LAST_STEP: {
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.PREVIOUS));
                this.navigationBar.add(Box.createHorizontalStrut(10));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.COMPLETE));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.CANCEL));
                break;
            }
            case LAST_STEP_SUCCESS: {
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.PREVIOUS));
                this.navigationBar.add(Box.createHorizontalStrut(10));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.COMPLETE));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.CANCEL));
                this.naviBtns.get((Object)Navigation.PREVIOUS).setEnabled(false);
                this.naviBtns.get((Object)Navigation.CANCEL).setEnabled(false);
                break;
            }
            case LAST_STEP_FAILED: {
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.PREVIOUS));
                this.navigationBar.add(Box.createHorizontalStrut(10));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.COMPLETE));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.CANCEL));
                this.naviBtns.get((Object)Navigation.COMPLETE).setEnabled(false);
                break;
            }
            case LAST_STEP_RUNNING: {
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.PREVIOUS));
                this.navigationBar.add(Box.createHorizontalStrut(10));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.COMPLETE));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.CANCEL));
                this.naviBtns.get((Object)Navigation.PREVIOUS).setEnabled(false);
                this.naviBtns.get((Object)Navigation.COMPLETE).setEnabled(false);
                break;
            }
        }
    }

    private void setFourthStep(FlowWizardState state) {
        switch (state) {
            case MIDDLE_STEP: {
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.PREVIOUS));
                this.navigationBar.add(Box.createHorizontalStrut(10));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.NEXT));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.CANCEL));
                break;
            }
            case MIDDLE_STEP_RUNNING: {
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.PREVIOUS));
                this.navigationBar.add(Box.createHorizontalStrut(10));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.NEXT));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.CANCEL));
                this.naviBtns.get((Object)Navigation.PREVIOUS).setEnabled(false);
                this.naviBtns.get((Object)Navigation.NEXT).setEnabled(false);
                break;
            }
            case MIDDLE_STEP_SUCCESS: {
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.PREVIOUS));
                this.navigationBar.add(Box.createHorizontalStrut(10));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.NEXT));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.CANCEL));
                this.naviBtns.get((Object)Navigation.PREVIOUS).setEnabled(false);
                break;
            }
            case MIDDLE_STEP_FAILED: {
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.PREVIOUS));
                this.navigationBar.add(Box.createHorizontalStrut(10));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.NEXT));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.CANCEL));
                this.naviBtns.get((Object)Navigation.NEXT).setEnabled(false);
                break;
            }
        }
    }

    private void setFifthStep(FlowWizardState state) {
        switch (state) {
            case MIDDLE_STEP_DISABLE: {
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.PREVIOUS));
                this.navigationBar.add(Box.createHorizontalStrut(10));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.NEXT));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.CANCEL));
                this.naviBtns.get((Object)Navigation.PREVIOUS).setEnabled(false);
                this.naviBtns.get((Object)Navigation.NEXT).setEnabled(false);
                this.naviBtns.get((Object)Navigation.CANCEL).setEnabled(false);
                break;
            }
            case MIDDLE_STEP_NEXT: {
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.PREVIOUS));
                this.navigationBar.add(Box.createHorizontalStrut(10));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.NEXT));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.CANCEL));
                this.naviBtns.get((Object)Navigation.PREVIOUS).setEnabled(false);
                this.naviBtns.get((Object)Navigation.CANCEL).setEnabled(false);
                break;
            }
        }
    }

    private void changeEnableState(FlowWizardState state) {
        switch (state) {
            case FIRST_STEP: {
                this.naviBtns.get((Object)Navigation.NEXT).setEnabled(true);
                this.naviBtns.get((Object)Navigation.CANCEL).setEnabled(true);
                break;
            }
            case FIRST_STEP_RUNNING: {
                this.naviBtns.get((Object)Navigation.NEXT).setEnabled(false);
                this.naviBtns.get((Object)Navigation.CANCEL).setEnabled(true);
                break;
            }
            case LAST_STEP_SUCCESS: {
                this.naviBtns.get((Object)Navigation.COMPLETE).setEnabled(true);
                this.naviBtns.get((Object)Navigation.PREVIOUS).setEnabled(false);
                this.naviBtns.get((Object)Navigation.CANCEL).setEnabled(false);
                break;
            }
            case SINGLE_STEP_SUCCESS: {
                this.naviBtns.get((Object)Navigation.COMPLETE).setEnabled(true);
                this.naviBtns.get((Object)Navigation.CANCEL).setEnabled(true);
                break;
            }
            case SINGLE_STEP_FAILED: {
                this.naviBtns.get((Object)Navigation.COMPLETE).setEnabled(false);
                this.naviBtns.get((Object)Navigation.CANCEL).setEnabled(true);
                break;
            }
            case LAST_STEP_FAILED: {
                this.naviBtns.get((Object)Navigation.COMPLETE).setEnabled(false);
                this.naviBtns.get((Object)Navigation.PREVIOUS).setEnabled(true);
                this.naviBtns.get((Object)Navigation.CANCEL).setEnabled(true);
                break;
            }
        }
        this.setSecondStep(state);
    }

    private void setSecondStep(FlowWizardState state) {
        switch (state) {
            case LAST_STEP_RUNNING: {
                this.naviBtns.get((Object)Navigation.CANCEL).setEnabled(true);
                this.naviBtns.get((Object)Navigation.PREVIOUS).setEnabled(false);
                this.naviBtns.get((Object)Navigation.COMPLETE).setEnabled(false);
                break;
            }
            case MIDDLE_STEP_RUNNING: {
                this.naviBtns.get((Object)Navigation.PREVIOUS).setEnabled(false);
                this.naviBtns.get((Object)Navigation.NEXT).setEnabled(false);
                this.naviBtns.get((Object)Navigation.CANCEL).setEnabled(true);
                break;
            }
            case MIDDLE_STEP_SUCCESS: {
                this.naviBtns.get((Object)Navigation.PREVIOUS).setEnabled(false);
                this.naviBtns.get((Object)Navigation.NEXT).setEnabled(true);
                this.naviBtns.get((Object)Navigation.CANCEL).setEnabled(true);
                break;
            }
            case MIDDLE_STEP_FAILED: {
                this.naviBtns.get((Object)Navigation.NEXT).setEnabled(false);
                this.naviBtns.get((Object)Navigation.PREVIOUS).setEnabled(true);
                this.naviBtns.get((Object)Navigation.CANCEL).setEnabled(true);
                break;
            }
            case MIDDLE_STEP_DISABLE: {
                this.naviBtns.get((Object)Navigation.PREVIOUS).setEnabled(false);
                this.naviBtns.get((Object)Navigation.NEXT).setEnabled(false);
                this.naviBtns.get((Object)Navigation.CANCEL).setEnabled(false);
                break;
            }
            case MIDDLE_STEP_NEXT: {
                this.naviBtns.get((Object)Navigation.NEXT).setEnabled(true);
                this.naviBtns.get((Object)Navigation.PREVIOUS).setEnabled(false);
                this.naviBtns.get((Object)Navigation.CANCEL).setEnabled(false);
                break;
            }
        }
    }

    private void initComponent() {
        JButton previous = UiMethod.createButton(Navigation.PREVIOUS.toString(this.loc), 'P');
        JButton next = UiMethod.createButton(Navigation.NEXT.toString(this.loc), 'N');
        JButton complete = UiMethod.createButton(Navigation.COMPLETE.toString(this.loc), 'F');
        JButton cancel = UiMethod.createButton(Navigation.CANCEL.toString(this.loc), 'C');
        this.naviBtns.put(Navigation.PREVIOUS, previous);
        this.naviBtns.put(Navigation.NEXT, next);
        this.naviBtns.put(Navigation.COMPLETE, complete);
        this.naviBtns.put(Navigation.CANCEL, cancel);
    }

    private void initButtonState() {
        for (Map.Entry<Navigation, JButton> en : this.naviBtns.entrySet()) {
            en.getValue().setEnabled(true);
        }
    }

    private void bondListener() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                if (!FlowWizardFrame.this.iFlow.exit()) {
                    FlowWizardFrame.this.setDefaultCloseOperation(0);
                } else {
                    FlowWizardFrame.this.setDefaultCloseOperation(2);
                }
            }
        });
        this.naviBtns.get((Object)Navigation.PREVIOUS).addActionListener(new PreviousAction());
        this.naviBtns.get((Object)Navigation.NEXT).addActionListener(new NextAction());
        this.naviBtns.get((Object)Navigation.CANCEL).addActionListener(new CancelAction());
        this.naviBtns.get((Object)Navigation.COMPLETE).addActionListener(new CompleteAction());
    }

    private void initUI() {
        ArrayList<WizardStepItem> stepList = new ArrayList<WizardStepItem>();
        int i = 1;
        for (Title title : this.stageTitles) {
            WizardStepItem stepItem = new WizardStepItem(title.getName(this.loc), title.getDesc(this.loc), i, this.loc);
            if (1 == i) {
                stepItem.setSelected(true);
            }
            stepList.add(stepItem);
            ++i;
        }
        this.stepsGroup.setSetps(stepList.toArray(new WizardStepItem[stepList.size()]));
        this.navigationBar = Box.createHorizontalBox();
        this.contentPane = new JPanel(new BorderLayout());
        this.southBox.add(Box.createVerticalStrut(12));
        this.southBox.add(this.navigationBar);
        JPanel jPane = this.getWizardPanel();
        this.southBox.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth(), 39));
        jPane.setBackground(WizardConstants.WIZARD_BACKGROUND);
        jPane.setPreferredSize(new Dimension(885, 600));
        JPanel jBbuttomPanel = new JPanel();
        jBbuttomPanel.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth(), 6));
        jBbuttomPanel.setBackground(WizardConstants.WIZARD_BUTTOM_LINE_COLOR);
        Container container = this.getContentPane();
        this.setLayout(new BorderLayout());
        container.add((Component)jPane, "Center");
        container.add((Component)jBbuttomPanel, "South");
        int height = (int)this.stepsGroup.getPreferredSize().getHeight() + 6 + 39;
        this.setSize(height / 3 * 4, height);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.pack();
    }

    protected JPanel getWizardPanel() {
        JPanel jPane = new JPanel(new BorderLayout());
        jPane.add((Component)this.stepsGroup, "West");
        jPane.add((Component)this.contentPane, "Center");
        jPane.add((Component)this.southBox, "South");
        return jPane;
    }

    private final class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FlowWizardFrame.this.iFlow.exit()) {
                FlowWizardFrame.this.dispose();
            }
        }
    }

    private final class CompleteAction
    implements ActionListener {
        private CompleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FlowWizardFrame.this.iFlow.complete()) {
                FlowWizardFrame.this.dispose();
            }
        }
    }

    private final class NextAction
    implements ActionListener {
        private NextAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FlowWizardFrame.this.iFlow.goNext();
        }
    }

    private final class PreviousAction
    implements ActionListener {
        private PreviousAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FlowWizardFrame.this.iFlow.goPrevious();
        }
    }

    public static enum Navigation {
        PREVIOUS,
        NEXT,
        COMPLETE,
        CANCEL;

        private static String prefix;

        public String toString(Locale local) {
            return RESOURCE.getString(local, prefix + this.name().toLowerCase(local));
        }

        static {
            prefix = "toolbase.wizard.txt.";
        }
    }
}

