/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.entity;

import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DiskTypeEnum;
import com.huawei.ism.tool.obase.entity.FusionStorDiskInfo;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;

public class FusionStorStoragePool {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.000");
    private String id;
    private String name;
    private String status;
    private String totalCapacity;
    private String usedCapacity;
    private String storageMediaType;
    private DiskTypeEnum mainStorageDiskExtend;
    private String storageMediaMinSize;
    private String cacheMediaType;
    private String storagePoolId;
    private ServiceType serviceType = ServiceType.BLOCK;
    private FusionStorStoragePool parentPool;
    private List<FusionStorStoragePool> diskPools = new ArrayList<FusionStorStoragePool>();
    private DiskTypeEnum mainStorageDiskType;
    private DiskTypeEnum cacheDiskType;
    private List<ClusterNode> joinedClusterNode = new ArrayList<ClusterNode>();
    private List<ClusterNode> expansionClusterNode = new ArrayList<ClusterNode>();
    private List<DevNode> expansionNodeList = new ArrayList<DevNode>();
    private PoolType poolType = PoolType.EXIST;
    private Date creatDate = new Date();

    public String getId() {
        return this.id;
    }

    public PoolType getPoolType() {
        return this.poolType;
    }

    public Date getCreatDate() {
        return this.creatDate;
    }

    public String getName() {
        return this.name;
    }

    public String getStatus() {
        return this.status;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setPoolType(PoolType poolType) {
        this.poolType = poolType;
    }

    public List<ClusterNode> getJoinedClusterNode() {
        return this.joinedClusterNode;
    }

    public void setTotalCapacity(String totalCapacity) {
        this.totalCapacity = totalCapacity;
    }

    public void setUsedCapacity(String usedCapacity) {
        this.usedCapacity = usedCapacity;
    }

    public void setMainStorageDiskType(DiskTypeEnum mainStorageDiskType) {
        if (DiskTypeEnum.isExtendDiskType(mainStorageDiskType)) {
            this.setMainStorageDiskExtend(mainStorageDiskType);
            this.mainStorageDiskType = mainStorageDiskType.mainType;
        } else {
            this.mainStorageDiskType = mainStorageDiskType;
        }
    }

    public void setMainStorageDiskExtend(DiskTypeEnum mainStorageDiskExtend) {
        if (!DiskTypeEnum.isExtendDiskType(mainStorageDiskExtend)) {
            return;
        }
        this.mainStorageDiskExtend = mainStorageDiskExtend;
    }

    public DiskTypeEnum getCacheDiskType() {
        return this.cacheDiskType;
    }

    public void setCacheDiskType(DiskTypeEnum cacheDiskType) {
        this.cacheDiskType = cacheDiskType;
    }

    public DiskTypeEnum getMainStorageDiskType() {
        return this.mainStorageDiskType;
    }

    public List<ClusterNode> getExpansionClusterNode() {
        return this.expansionClusterNode;
    }

    public Long getDevFreeCapacity() {
        return this.getTotalCapacity() - this.getUsedCapacity();
    }

    public static String getCapacityByString(double[] freeCapacity) {
        FusionStorStoragePool.formartCapacity(freeCapacity);
        double gb = freeCapacity[0] + freeCapacity[1];
        if (gb == 0.0) {
            return "0 GB";
        }
        if (gb < 1024.0) {
            return DECIMAL_FORMAT.format(gb) + "GB";
        }
        FusionStorStoragePool.formartCapacity(freeCapacity);
        double tb = freeCapacity[0] + freeCapacity[1];
        if (tb < 1024.0) {
            return DECIMAL_FORMAT.format(tb) + "TB";
        }
        FusionStorStoragePool.formartCapacity(freeCapacity);
        double pb = freeCapacity[0] + freeCapacity[1];
        return DECIMAL_FORMAT.format(pb) + "PB";
    }

    private static void formartCapacity(double[] freeCapacity) {
        freeCapacity[0] = freeCapacity[0] / 1000.0;
        freeCapacity[1] = freeCapacity[1] / 1024.0;
    }

    public static void getCapacityByDisk(double[] freeCapacity, FusionStorDiskInfo disk, Integer number) {
        if (DiskTypeEnum.SSD_CARD_AND_NVME_SSD.equals((Object)disk.getType())) {
            freeCapacity[0] = freeCapacity[0] + (double)disk.getCapacityByLong().longValue() / 1000.0 / 1000.0 * (double)number.intValue();
        } else {
            freeCapacity[1] = freeCapacity[1] + (double)disk.getCapacityByLong().longValue() / 1024.0 / 1024.0 * (double)number.intValue();
        }
    }

    public Long getTotalCapacity() {
        if (StringUtils.isNULLStr(this.totalCapacity)) {
            return 0L;
        }
        return Long.valueOf(this.totalCapacity);
    }

    public Long getUsedCapacity() {
        if (StringUtils.isNULLStr(this.usedCapacity)) {
            return 0L;
        }
        return Long.valueOf(this.usedCapacity);
    }

    public List<DevNode> getExpansionNodeList() {
        return this.expansionNodeList;
    }

    public void cleanExpansionClusterNode() {
        this.expansionClusterNode = new ArrayList<ClusterNode>();
    }

    public void cleanExpansionNodeList() {
        this.expansionNodeList = new ArrayList<DevNode>();
    }

    public boolean isExisted() {
        return this.poolType == PoolType.EXIST;
    }

    public boolean isExpansionCreate() {
        return this.poolType == PoolType.EXPANSION_CREAT;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = ServiceType.mappingEnum(serviceType);
    }

    public void setServiceTypeByToString(String serviceType) {
        this.serviceType = ServiceType.mappingEnumByToString(serviceType);
    }

    public void setServiceType(ServiceType serviceType) {
        this.serviceType = serviceType;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public void addDiskPool(FusionStorStoragePool diskPool) {
        this.diskPools.add(diskPool);
    }

    public List<FusionStorStoragePool> getDiskPools() {
        return this.diskPools;
    }

    public FusionStorStoragePool getParentPool() {
        return this.parentPool;
    }

    public void setParentPool(FusionStorStoragePool parentPool) {
        this.parentPool = parentPool;
    }

    public boolean isDiskPool() {
        return this.parentPool != null;
    }

    public String getPoolTypeName() {
        return this.isDiskPool() ? ResourceUtil.getString("disk.pool") : ResourceUtil.getString("storage.pool");
    }

    public boolean isBlock() {
        return this.serviceType == ServiceType.BLOCK;
    }

    public boolean isNullPool() {
        return this.getJoinedClusterNode().isEmpty() && this.getExpansionClusterNode().isEmpty() && this.getExpansionNodeList().isEmpty();
    }

    public boolean diskIsFlash() throws ToolException {
        boolean isFlash = Stream.of(DiskTypeEnum.SSD_CARD_AND_NVME_SSD, DiskTypeEnum.SSD).anyMatch(diskTypeEnum -> diskTypeEnum.equals((Object)this.getMainStorageDiskType()));
        if (!isFlash && this.getCacheDiskType() == null) {
            throw new ToolException("fit.invalid.main.cache.type", new String[]{this.getName()});
        }
        return isFlash;
    }

    public void setStorageMediaType(String storageMediaType) {
        this.storageMediaType = storageMediaType;
    }

    public String getStorageMediaType() {
        return this.storageMediaType;
    }

    public DiskTypeEnum getMainStorageDiskExtend() {
        return this.mainStorageDiskExtend;
    }

    public void setStorageMediaMinSize(String storageMediaMinSize) {
        this.storageMediaMinSize = storageMediaMinSize;
    }

    public String getStorageMediaMinSize() {
        return this.storageMediaMinSize;
    }

    public void setCacheMediaType(String cacheMediaType) {
        this.cacheMediaType = cacheMediaType;
    }

    public String getCacheMediaType() {
        return this.cacheMediaType;
    }

    public void setStoragePoolId(String storagePoolId) {
        this.storagePoolId = storagePoolId;
    }

    public String getStoragePoolId() {
        return this.storagePoolId;
    }

    public static enum ServiceType {
        BLOCK("1"),
        FILE("2"),
        OBJECT("3"),
        HDFS("4"),
        FUSION("5");

        String devValue;

        private ServiceType(String devValue) {
            this.devValue = devValue;
        }

        public String getDevValue() {
            return this.devValue;
        }

        public String toString() {
            return ResourceUtil.getString("storage.pool.service.type." + this.devValue);
        }

        public static ServiceType mappingEnumByToString(String description) {
            return Arrays.stream(ServiceType.values()).filter(value -> value.toString().equals(description)).findFirst().orElse(BLOCK);
        }

        public static ServiceType mappingEnum(String modeName) {
            return Arrays.stream(ServiceType.values()).filter(value -> value.getDevValue().equals(modeName)).findFirst().orElse(BLOCK);
        }
    }

    public static enum PoolType {
        EXIST,
        EXPANSION_CREAT;

    }
}

