/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.flow;

import com.huawei.ism.tool.obase.entity.CommonContext;
import com.huawei.ism.tool.obase.flow.FlowState;
import com.huawei.ism.tool.obase.flow.ICondition;
import com.huawei.ism.tool.obase.flow.IFlow;
import com.huawei.ism.tool.obase.flow.IFlowListener;
import com.huawei.ism.tool.obase.flow.IStep;
import com.huawei.ism.tool.obase.flow.StepPos;
import com.huawei.ism.tool.obase.flow.ui.IFlowUI;
import com.huawei.ism.tool.obase.flow.ui.Title;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class Flow
implements IFlow {
    private IFlowUI flowUI;
    private Title title;
    private String help;
    private CommonContext context = new CommonContext();
    private List<IStep> stepList = new ArrayList<IStep>();
    private List<Title> stageTitleList = new ArrayList<Title>();
    private IStep curStep = null;
    private Stack<IStep> stepTrace = new Stack();
    private Set<IFlowListener> listenerList = new HashSet<IFlowListener>();
    private FlowState curState = FlowState.init;

    public Flow(Title title) {
        this.title = title;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public void addStage(int stageIndex, Title stageTitle) {
        this.stageTitleList.add(stageIndex, stageTitle);
    }

    public void setFlowUI(IFlowUI flowUI) {
        this.flowUI = flowUI;
    }

    public void addStep(IStep step) {
        this.stepList.add(step);
    }

    @Override
    public void addListener(IFlowListener listener) {
        this.listenerList.add(listener);
    }

    @Override
    public void goNext() {
        if (!this.curStep.ending()) {
            return;
        }
        int index = this.stepList.indexOf(this.curStep);
        int nextIndex = index + 1;
        if (nextIndex >= this.stepList.size()) {
            return;
        }
        IStep nextStep = this.stepList.get(nextIndex);
        ICondition condtion = nextStep.getCondition();
        if (null != condtion && !condtion.isMeet()) {
            this.curStep = nextStep;
            this.goNext();
            return;
        }
        IStep preStep = this.curStep;
        if (this.forwardToStep(nextStep, nextIndex)) {
            this.stepTrace.push(preStep);
        }
    }

    @Override
    public void goPrevious() {
        int index = this.stepList.indexOf(this.curStep);
        int preIndex = index - 1;
        if (preIndex < 0) {
            return;
        }
        if (!this.curStep.canceling()) {
            return;
        }
        while (!this.stepTrace.empty()) {
            IStep preStep = this.stepTrace.pop();
            if (preStep.isAuto()) continue;
            this.backToStep(preStep, preIndex);
            break;
        }
    }

    @Override
    public boolean init() {
        if (null != this.flowUI) {
            this.flowUI.init(this.title, this.help, this.stageTitleList);
        }
        this.curState = FlowState.ready;
        return true;
    }

    @Override
    public boolean start() {
        IStep step = this.stepList.get(0);
        if (!this.forwardToStep(step, 0)) {
            return false;
        }
        this.curState = FlowState.running;
        for (IFlowListener l : this.listenerList) {
            l.onStart();
        }
        return true;
    }

    @Override
    public boolean exit() {
        if (!this.curStep.flowExiting()) {
            return false;
        }
        this.curState = FlowState.stopped;
        for (IFlowListener l : this.listenerList) {
            l.onExit(this.curStep);
        }
        return true;
    }

    @Override
    public boolean complete() {
        this.curState = FlowState.stopped;
        for (IFlowListener l : this.listenerList) {
            if (l.onComplete()) continue;
            return false;
        }
        return true;
    }

    @Override
    public FlowState getCurState() {
        return this.curState;
    }

    private boolean forwardToStep(IStep step, int index) {
        StepPos pos = StepPos.middleStep;
        if (0 == index) {
            pos = StepPos.startStep;
        } else if (this.stepList.size() - 1 == index) {
            pos = StepPos.endStep;
        }
        if (step.start(this.flowUI, this.context, pos)) {
            this.curStep = step;
            return true;
        }
        return false;
    }

    private boolean backToStep(IStep step, int index) {
        StepPos pos;
        StepPos stepPos = pos = 0 == index ? StepPos.startStep : StepPos.middleStep;
        if (step.start(this.flowUI, this.context, pos)) {
            this.curStep = step;
            return true;
        }
        return false;
    }
}

