/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.mails;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.mails.MailConfigKeeper;
import com.huawei.ism.tool.obase.mails.MailInfo;

public class EmailEntity {
    private static final int DEFAULT_PORT = 25;
    private boolean auth = true;
    private boolean tls = false;
    private boolean securedTls = false;
    private boolean nonRadio = false;
    private int smtpPort = 25;
    private String stmpServer;
    private String fromEmail;
    private String toEmail;
    private String account;
    private String pwd;
    private String title;
    private String content;
    private String[] attachFile;
    private boolean enableCert = false;

    public EmailEntity() {
    }

    public EmailEntity(MailInfo mailInfo, String tomail) {
        this.fromEmail = mailInfo.getSendAddress();
        this.stmpServer = mailInfo.getSmtpIP();
        this.smtpPort = mailInfo.getSmtpPort();
        this.account = mailInfo.getUser().getUserName();
        this.pwd = mailInfo.getUser().getPassword();
        this.auth = mailInfo.isNeedValidate();
        this.tls = mailInfo.isTls();
        this.securedTls = mailInfo.isSecuredTls();
        this.toEmail = tomail;
    }

    public EmailEntity(String stmpServer, String fromEmail, String title, String content) {
        this.stmpServer = stmpServer;
        this.fromEmail = fromEmail;
        this.title = title;
        this.content = content;
        try {
            MailInfo mailInfo = MailConfigKeeper.getInstance().getMailInfo();
            this.setSmtpPort(mailInfo.getSmtpPort());
            this.setTls(mailInfo.isTls());
            this.setSecuredTls(mailInfo.isSecuredTls());
            this.setAuth(mailInfo.isNeedValidate());
            this.setEnableCert(mailInfo.isEnableCert());
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("set mail info faild", e);
        }
    }

    public void setAttachments(String ... attach) {
        this.attachFile = attach;
    }

    public String getStmpServer() {
        return this.stmpServer;
    }

    public String getFromEmail() {
        return this.fromEmail;
    }

    public String getToEmail() {
        return this.toEmail;
    }

    public String getAccount() {
        return this.account;
    }

    public String getPassword() {
        return AESEncrypt.decrypt((String)this.pwd);
    }

    public String getTitle() {
        return this.title;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String[] getAttachFile() {
        if (null == this.attachFile) {
            return new String[0];
        }
        return (String[])this.attachFile.clone();
    }

    public void setAttachFile(String[] attachFile) {
        String[] tempAttachFile = (String[])attachFile.clone();
        this.attachFile = tempAttachFile;
    }

    public boolean isAuth() {
        return this.auth;
    }

    public void setAuth(boolean auth) {
        this.auth = auth;
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isTls() {
        return this.tls;
    }

    public void setTls(boolean tls) {
        this.tls = tls;
    }

    public boolean isNonRadio() {
        return this.nonRadio;
    }

    public void setNonRadio(boolean nonRadio) {
        this.nonRadio = nonRadio;
    }

    public void setStmpServer(String stmpServer) {
        this.stmpServer = stmpServer;
    }

    public void setFromEmail(String fromEmail) {
        this.fromEmail = fromEmail;
    }

    public void setToEmail(String toEmail) {
        this.toEmail = toEmail;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public void setPassword(String password) {
        this.pwd = AESEncrypt.encrypt((String)password);
    }

    public String toString() {
        return new StringBuffer(this.getClass().getName()).append(" stmpServer=").append(this.stmpServer).append(" fromEmail=").append(this.fromEmail).append(" toEmail=").append(this.toEmail).append(" account=").append(this.account).append(" title=").append(this.title).append(" content=").append(this.content).append(" isTLS=").append(this.tls).append(" isEnableCert=").append(this.enableCert).toString();
    }

    public boolean isEnableCert() {
        return this.enableCert;
    }

    public void setEnableCert(boolean enableCert) {
        this.enableCert = enableCert;
    }

    public boolean isSecuredTls() {
        return this.securedTls;
    }

    public void setSecuredTls(boolean securedTls) {
        this.securedTls = securedTls;
    }
}

