/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.net.dhcp.utils;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.net.dhcp.utils.DHCPConstants;
import com.huawei.ism.tool.obase.net.dhcp.utils.DHCPOption;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;

public class DHCPPacket
implements Cloneable,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final Logger DHCPLOGGER = ToolLoggerFactory.getLogger(DHCPPacket.class);
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private boolean offerIpFlag = false;
    private String comment = "";
    private byte op = (byte)2;
    private byte htype = 1;
    private byte hlen = (byte)6;
    private byte hops;
    private int xid;
    private short secs;
    private short flags;
    private byte[] ciaddr = new byte[4];
    private byte[] yiaddr = new byte[4];
    private byte[] siaddr = new byte[4];
    private byte[] giaddr = new byte[4];
    private byte[] chaddr = new byte[16];
    private byte[] sname = new byte[64];
    private byte[] file = new byte[128];
    private Map<Byte, DHCPOption> options;
    private boolean isDhcpRequest = true;
    private boolean truncated;
    private byte[] padding = new byte[0];
    private InetAddress address;
    private int port;

    public DHCPPacket() {
        this.options = new LinkedHashMap<Byte, DHCPOption>();
    }

    public void setOffer(boolean isOfferIpPacket) {
        this.offerIpFlag = isOfferIpPacket;
    }

    public boolean isOfferIpPacket() {
        return this.offerIpFlag;
    }

    public static DHCPPacket getPacket(DatagramPacket datagram) throws ToolException {
        if (datagram == null) {
            return null;
        }
        DHCPPacket packet = new DHCPPacket();
        packet.marshall(datagram.getData(), datagram.getOffset(), datagram.getLength(), datagram.getAddress(), datagram.getPort(), true);
        return packet;
    }

    public static DHCPPacket getPacket(byte[] buf, int offset, int length, boolean strict) throws ToolException {
        DHCPPacket packet = new DHCPPacket();
        packet.marshall(buf, offset, length, null, 0, strict);
        return packet;
    }

    public DHCPPacket clone() throws CloneNotSupportedException {
        DHCPPacket dhcpPacket = (DHCPPacket)super.clone();
        dhcpPacket.ciaddr = (byte[])this.ciaddr.clone();
        dhcpPacket.yiaddr = (byte[])this.yiaddr.clone();
        dhcpPacket.siaddr = (byte[])this.siaddr.clone();
        dhcpPacket.giaddr = (byte[])this.giaddr.clone();
        dhcpPacket.chaddr = (byte[])this.chaddr.clone();
        dhcpPacket.sname = (byte[])this.sname.clone();
        dhcpPacket.file = (byte[])this.file.clone();
        dhcpPacket.options = new LinkedHashMap<Byte, DHCPOption>(this.options);
        dhcpPacket.padding = (byte[])this.padding.clone();
        dhcpPacket.truncated = false;
        return dhcpPacket;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DHCPPacket)) {
            return false;
        }
        DHCPPacket dhcpPacket = (DHCPPacket)obj;
        boolean flag = this.comment.equals(dhcpPacket.comment);
        flag &= this.op == dhcpPacket.op;
        flag &= this.htype == dhcpPacket.htype;
        flag &= this.hlen == dhcpPacket.hlen;
        flag &= this.hops == dhcpPacket.hops;
        flag &= this.xid == dhcpPacket.xid;
        flag &= this.secs == dhcpPacket.secs;
        flag &= this.flags == dhcpPacket.flags;
        flag &= Arrays.equals(this.ciaddr, dhcpPacket.ciaddr);
        flag &= Arrays.equals(this.yiaddr, dhcpPacket.yiaddr);
        flag &= Arrays.equals(this.siaddr, dhcpPacket.siaddr);
        flag &= Arrays.equals(this.giaddr, dhcpPacket.giaddr);
        flag &= Arrays.equals(this.chaddr, dhcpPacket.chaddr);
        flag &= Arrays.equals(this.sname, dhcpPacket.sname);
        flag &= Arrays.equals(this.file, dhcpPacket.file);
        flag &= this.options.equals(dhcpPacket.options);
        flag &= this.isDhcpRequest == dhcpPacket.isDhcpRequest;
        flag &= Arrays.equals(this.padding, dhcpPacket.padding);
        flag &= DHCPPacket.equalsStatic(this.address, dhcpPacket.address);
        return flag &= this.port == dhcpPacket.port;
    }

    public int hashCode() {
        int hashValue = -1;
        hashValue ^= this.comment.hashCode();
        hashValue += this.op;
        hashValue += this.htype;
        hashValue += this.hlen;
        hashValue += this.hops;
        hashValue += this.xid;
        hashValue += this.secs;
        hashValue ^= this.flags;
        hashValue ^= Arrays.hashCode(this.ciaddr);
        hashValue ^= Arrays.hashCode(this.yiaddr);
        hashValue ^= Arrays.hashCode(this.siaddr);
        hashValue ^= Arrays.hashCode(this.giaddr);
        hashValue ^= Arrays.hashCode(this.chaddr);
        hashValue ^= Arrays.hashCode(this.sname);
        hashValue ^= Arrays.hashCode(this.file);
        hashValue ^= this.options.hashCode();
        hashValue += this.isDhcpRequest ? 1 : 0;
        hashValue ^= Arrays.hashCode(this.padding);
        hashValue ^= this.address != null ? this.address.hashCode() : 0;
        return hashValue += this.port;
    }

    private static boolean equalsStatic(Object objA, Object objB) {
        return objA == null ? objB == null : objA.equals(objB);
    }

    protected DHCPPacket marshall(byte[] buffer, int offset, int length, InetAddress address0, int port0, boolean strict) throws ToolException {
        this.checkParameter(buffer, offset, length);
        this.address = address0;
        this.port = port0;
        ByteArrayInputStream inBStream = new ByteArrayInputStream(buffer, offset, length);
        DataInputStream inStream = new DataInputStream(inBStream);
        try {
            this.initInStreamAttributes(inStream);
            this.initInStreamReadFully(inStream);
            this.isDhcpRequest = true;
            inBStream.mark(4);
            if (inStream.readInt() != 1669485411) {
                this.isDhcpRequest = false;
                inBStream.reset();
            }
            if (this.isDhcpRequest) {
                this.parseDHCPRequest(strict, inBStream);
            }
            this.lastHandle(inBStream);
            DHCPPacket dHCPPacket = this;
            return dHCPPacket;
        }
        catch (IOException e) {
            throw new ToolException("IOException: " + e.toString(), e);
        }
        finally {
            StreamUtils.closeResource(null, (Closeable)inStream);
            StreamUtils.closeResource(null, (Closeable)inBStream);
        }
    }

    private void parseDHCPRequest(boolean strict, ByteArrayInputStream inBStream) throws IOException, ToolException {
        int r;
        byte type = 0;
        while ((r = inBStream.read()) >= 0) {
            type = (byte)r;
            if (type == 0) continue;
            r = inBStream.read();
            if (r < 0) break;
            int len = Math.min(r, inBStream.available());
            byte[] unitopt = new byte[len];
            int readBytes = inBStream.read(unitopt);
            if (readBytes == -1) {
                DHCPLOGGER.error("Read byte count is -1");
            }
            this.setOption(new DHCPOption(type, unitopt));
        }
        boolean bl = this.truncated = type != -1;
        if (strict && this.truncated) {
            throw new ToolException("Packet seams to be truncated");
        }
    }

    private void lastHandle(ByteArrayInputStream inBStream) throws IOException {
        this.padding = new byte[inBStream.available()];
        int ret = inBStream.read(this.padding);
        DHCPLOGGER.error("Return info:" + ret);
    }

    private void initInStreamReadFully(DataInputStream inStream) throws IOException {
        inStream.readFully(this.ciaddr, 0, 4);
        inStream.readFully(this.yiaddr, 0, 4);
        inStream.readFully(this.siaddr, 0, 4);
        inStream.readFully(this.giaddr, 0, 4);
        inStream.readFully(this.chaddr, 0, 16);
        inStream.readFully(this.sname, 0, 64);
        inStream.readFully(this.file, 0, 128);
    }

    private void initInStreamAttributes(DataInputStream inStream) throws IOException {
        this.op = inStream.readByte();
        this.htype = inStream.readByte();
        this.hlen = inStream.readByte();
        this.hops = inStream.readByte();
        this.xid = inStream.readInt();
        this.secs = inStream.readShort();
        this.flags = inStream.readShort();
    }

    private void checkParameter(byte[] buffer, int offset, int length) throws ToolException {
        if (buffer == null) {
            throw new IllegalArgumentException("null buffer not allowed");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("negative offset not allowed");
        }
        if (length < 0) {
            throw new IllegalArgumentException("negative length not allowed");
        }
        if (buffer.length < offset + length) {
            throw new IndexOutOfBoundsException("offset+length exceeds buffer length");
        }
        if (length < 236) {
            throw new ToolException("DHCP Packet too small (" + length + ") absolute minimum is " + 236);
        }
        if (length > 1500) {
            throw new ToolException("DHCP Packet too big (" + length + ") max MTU is " + 1500);
        }
    }

    public byte[] serialize() {
        int minLen = 236;
        if (this.isDhcpRequest) {
            minLen += 64;
        }
        return this.serialize(minLen, 576);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serialize(int minSize, int maxSize) {
        ByteArrayOutputStream outBStream = new ByteArrayOutputStream(750);
        DataOutputStream outStream = new DataOutputStream(outBStream);
        try {
            byte[] data;
            this.outStreamWrite(outStream);
            if (this.isDhcpRequest) {
                outStream.writeInt(1669485411);
                for (DHCPOption opt : this.getOptionsCollection()) {
                    int size = opt.getValueFast().length;
                    if (size > 255) {
                        throw new IllegalArgumentException("Options larger than 255 bytes are not yet supported");
                    }
                    outStream.writeByte(opt.getCode());
                    outStream.writeByte(size);
                    outStream.write(opt.getValueFast());
                }
                outStream.writeByte(-1);
            }
            outStream.write(this.padding);
            int minPadding = minSize - outBStream.size();
            if (minPadding > 0) {
                byte[] addpadding = new byte[minPadding];
                outStream.write(addpadding);
            }
            if ((data = outBStream.toByteArray()).length > 1500) {
                throw new IllegalArgumentException("serialize: packet too big (" + data.length + " greater than max MAX_MTU (" + 1500 + ')');
            }
            byte[] byArray = data;
            return byArray;
        }
        catch (IOException e) {
            DHCPLOGGER.error("Unexpected Exception", e);
        }
        finally {
            StreamUtils.closeResource(null, (Closeable)outStream);
            StreamUtils.closeResource(null, (Closeable)outBStream);
        }
        return outBStream.toByteArray();
    }

    private void outStreamWrite(DataOutputStream outStream) throws IOException {
        outStream.writeByte(this.op);
        outStream.writeByte(this.htype);
        outStream.writeByte(this.hlen);
        outStream.writeByte(this.hops);
        outStream.writeInt(this.xid);
        outStream.writeShort(this.secs);
        outStream.writeShort(this.flags);
        outStream.write(this.ciaddr, 0, 4);
        outStream.write(this.yiaddr, 0, 4);
        outStream.write(this.siaddr, 0, 4);
        outStream.write(this.giaddr, 0, 4);
        outStream.write(this.chaddr, 0, 16);
        outStream.write(this.sname, 0, 64);
        outStream.write(this.file, 0, 128);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        try {
            this.initBuffer(buffer);
            String bootName = DHCPConstants.BOOT_NAMES.get(this.op);
            if (bootName != null) {
                buffer.append((Object)bootName).append('(').append(this.op).append(')');
            } else {
                buffer.append(this.op);
            }
            buffer.append("\nhtype=");
            String htypeName = DHCPConstants.HTYPE_NAMES.get(this.htype);
            if (htypeName != null) {
                buffer.append((Object)htypeName).append('(').append(this.htype).append(')');
            } else {
                buffer.append(this.htype);
            }
            buffer.append("\nhlen=").append(this.hlen).append("\nhops=").append(this.hops).append("\nxid=0x");
            DHCPPacket.appendHex(buffer, this.xid);
            buffer.append("\nsecs=").append(this.secs).append("\nflags=0x").append(Integer.toHexString(this.flags)).append("\nciaddr=");
            DHCPPacket.appendHostAddress(buffer, InetAddress.getByAddress(this.ciaddr));
            buffer.append("\nyiaddr=");
            DHCPPacket.appendHostAddress(buffer, InetAddress.getByAddress(this.yiaddr));
            buffer.append("\nsiaddr=");
            DHCPPacket.appendHostAddress(buffer, InetAddress.getByAddress(this.siaddr));
            buffer.append("\ngiaddr=");
            DHCPPacket.appendHostAddress(buffer, InetAddress.getByAddress(this.giaddr));
            buffer.append("\nchaddr=0x");
            this.appendChaddrAsHex(buffer);
            buffer.append("\nsname=").append(this.getSname()).append("\nfile=").append(this.getFile());
            if (this.isDhcpRequest) {
                buffer.append("\nOptions follows:");
                for (DHCPOption opt : this.getOptionsCollection()) {
                    buffer.append('\n');
                    opt.append(buffer);
                }
            }
            buffer.append("\npadding[").append(this.padding.length).append("]=");
            DHCPPacket.appendHex(buffer, this.padding);
        }
        catch (IOException e) {
            DHCPLOGGER.error("Dhcp package tostring error.", e);
        }
        catch (Exception e1) {
            DHCPLOGGER.error("Dhcp package tostring error.", e1);
        }
        return buffer.toString();
    }

    private void initBuffer(StringBuilder buffer) {
        buffer.append(this.isDhcpRequest ? "DHCP Packet" : "BOOTP Packet").append("\ncomment=").append(this.comment).append("\naddress=").append(this.address != null ? this.address.getHostAddress() : "").append('(').append(this.port).append(')').append("\nop=");
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public byte[] getChaddr() {
        return (byte[])this.chaddr.clone();
    }

    private StringBuilder appendChaddrAsHex(StringBuilder buffer) {
        DHCPPacket.appendHex(buffer, this.chaddr, 0, this.hlen & 0xFF);
        return buffer;
    }

    public String getChaddrMac() {
        StringBuilder sb = new StringBuilder();
        return this.appendChaddrAsHex(sb).toString();
    }

    public String getChaddrAsHex() {
        return this.appendChaddrAsHex(new StringBuilder(this.hlen & 0xFF)).toString();
    }

    public void setChaddr(byte[] chaddr) {
        if (chaddr != null) {
            if (chaddr.length > this.chaddr.length) {
                throw new IllegalArgumentException("chaddr is too long: " + chaddr.length + ", max is: " + this.chaddr.length);
            }
            Arrays.fill(this.chaddr, (byte)0);
            System.arraycopy(chaddr, 0, this.chaddr, 0, chaddr.length);
        } else {
            Arrays.fill(this.chaddr, (byte)0);
        }
    }

    public void setChaddrHex(String hex) {
        this.setChaddr(DHCPPacket.hex2Bytes(hex));
    }

    public InetAddress getCiaddr() {
        try {
            return InetAddress.getByAddress(this.getCiaddrRaw());
        }
        catch (UnknownHostException e) {
            DHCPLOGGER.error("Unexpected UnknownHostException", e);
            return null;
        }
    }

    public byte[] getCiaddrRaw() {
        return (byte[])this.ciaddr.clone();
    }

    public void setCiaddr(InetAddress ciaddr) {
        if (!(ciaddr instanceof Inet4Address)) {
            throw new IllegalArgumentException("Inet4Address required");
        }
        this.setCiaddrRaw(ciaddr.getAddress());
    }

    public void setCiaddr(String ciaddr) throws UnknownHostException {
        this.setCiaddr(InetAddress.getByName(ciaddr));
    }

    public void setCiaddrRaw(byte[] addrs) {
        if (addrs.length != 4) {
            throw new IllegalArgumentException("4-byte array required");
        }
        System.arraycopy(addrs, 0, this.ciaddr, 0, 4);
    }

    public byte[] getFileRaw() {
        return (byte[])this.file.clone();
    }

    public String getFile() {
        return DHCPPacket.bytesToString(this.getFileRaw());
    }

    public void setFile(String file) {
        this.setFileRaw(DHCPPacket.stringToBytes(file));
    }

    public void setFileRaw(byte[] files) {
        if (files != null) {
            if (files.length > this.file.length) {
                throw new IllegalArgumentException("File is too long:" + files.length + " max is:" + this.file.length);
            }
            Arrays.fill(this.file, (byte)0);
            System.arraycopy(files, 0, this.file, 0, files.length);
        } else {
            Arrays.fill(this.file, (byte)0);
        }
    }

    public short getFlags() {
        return this.flags;
    }

    public void setFlags(short flags) {
        this.flags = flags;
    }

    public InetAddress getGiaddr() {
        try {
            return InetAddress.getByAddress(this.getGiaddrRaw());
        }
        catch (UnknownHostException e) {
            DHCPLOGGER.error("Unexpected UnknownHostException", e);
            return null;
        }
    }

    public byte[] getGiaddrRaw() {
        return (byte[])this.giaddr.clone();
    }

    public void setGiaddr(InetAddress giaddr) {
        if (!(giaddr instanceof Inet4Address)) {
            throw new IllegalArgumentException("Inet4Address required");
        }
        this.setGiaddrRaw(giaddr.getAddress());
    }

    public void setGiaddr(String giaddr) throws UnknownHostException {
        this.setGiaddr(InetAddress.getByName(giaddr));
    }

    public void setGiaddrRaw(byte[] addrs) {
        if (addrs.length != 4) {
            throw new IllegalArgumentException("4-byte array required");
        }
        System.arraycopy(addrs, 0, this.giaddr, 0, 4);
    }

    public byte getHlen() {
        return this.hlen;
    }

    public void setHlen(byte hlen) {
        this.hlen = hlen;
    }

    public byte getHops() {
        return this.hops;
    }

    public void setHops(byte hops) {
        this.hops = hops;
    }

    public byte getHtype() {
        return this.htype;
    }

    public void setHtype(byte htype) {
        this.htype = htype;
    }

    public boolean isDhcp() {
        return this.isDhcpRequest;
    }

    public void setDhcp(boolean isDhcp) {
        this.isDhcpRequest = isDhcp;
    }

    public byte getOp() {
        return this.op;
    }

    public void setOp(byte op) {
        this.op = op;
    }

    public byte[] getPadding() {
        return (byte[])this.padding.clone();
    }

    public void setPadding(byte[] padding) {
        this.padding = padding == null ? new byte[]{} : (byte[])padding.clone();
    }

    public void setPaddingWithZeroes(int length) {
        if (length < 0) {
            length = 0;
        }
        if (length > 1500) {
            throw new IllegalArgumentException("length is > 1500");
        }
        this.setPadding(new byte[length]);
    }

    public short getSecs() {
        return this.secs;
    }

    public void setSecs(short secs) {
        this.secs = secs;
    }

    public InetAddress getSiaddr() {
        try {
            return InetAddress.getByAddress(this.getSiaddrRaw());
        }
        catch (UnknownHostException e) {
            DHCPLOGGER.error("Unexpected UnknownHostException", e);
            return null;
        }
    }

    public byte[] getSiaddrRaw() {
        return (byte[])this.siaddr.clone();
    }

    public void setSiaddr(InetAddress siaddr) {
        if (!(siaddr instanceof Inet4Address)) {
            throw new IllegalArgumentException("Inet4Address required");
        }
        this.setSiaddrRaw(siaddr.getAddress());
    }

    public void setSiaddr(String siaddr) throws UnknownHostException {
        this.setSiaddr(InetAddress.getByName(siaddr));
    }

    public void setSiaddrRaw(byte[] addrs) {
        if (addrs.length != 4) {
            throw new IllegalArgumentException("4-byte array required");
        }
        System.arraycopy(addrs, 0, this.siaddr, 0, 4);
    }

    public byte[] getSnameRaw() {
        return (byte[])this.sname.clone();
    }

    public String getSname() {
        return DHCPPacket.bytesToString(this.getSnameRaw());
    }

    public void setSname(String sname) {
        this.setSnameRaw(DHCPPacket.stringToBytes(sname));
    }

    public void setSnameRaw(byte[] names) {
        if (names != null) {
            if (names.length > this.sname.length) {
                throw new IllegalArgumentException("Sname is too long:" + names.length + " max is:" + this.sname.length);
            }
            Arrays.fill(this.sname, (byte)0);
            System.arraycopy(names, 0, this.sname, 0, names.length);
        } else {
            Arrays.fill(this.sname, (byte)0);
        }
    }

    public int getXid() {
        return this.xid;
    }

    public void setXid(int xid) {
        this.xid = xid;
    }

    public InetAddress getYiaddr() {
        try {
            return InetAddress.getByAddress(this.getYiaddrRaw());
        }
        catch (UnknownHostException e) {
            DHCPLOGGER.error("Unexpected UnknownHostException", e);
            return null;
        }
    }

    public byte[] getYiaddrRaw() {
        return (byte[])this.yiaddr.clone();
    }

    public void setYiaddr(InetAddress yiaddr) {
        if (!(yiaddr instanceof Inet4Address)) {
            throw new IllegalArgumentException("Inet4Address required");
        }
        this.setYiaddrRaw(yiaddr.getAddress());
    }

    public void setYiaddr(String yiaddr) throws UnknownHostException {
        this.setYiaddr(InetAddress.getByName(yiaddr));
    }

    public void setYiaddrRaw(byte[] addrs) {
        if (addrs.length != 4) {
            throw new IllegalArgumentException("4-byte array required");
        }
        System.arraycopy(addrs, 0, this.yiaddr, 0, 4);
    }

    public Byte getDHCPMessageType() {
        return this.getOptionAsByte((byte)53);
    }

    public void setDHCPMessageType(byte optionType) {
        this.setOptionAsByte((byte)53, optionType);
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public Integer getOptionAsNum(byte code) {
        DHCPOption opt = this.getOption(code);
        return opt != null ? opt.getValueAsNum() : null;
    }

    public Byte getOptionAsByte(byte code) {
        DHCPOption opt = this.getOption(code);
        return opt == null ? null : Byte.valueOf(opt.getValueAsByte());
    }

    public Short getOptionAsShort(byte code) {
        DHCPOption opt = this.getOption(code);
        return opt == null ? null : Short.valueOf(opt.getValueAsShort());
    }

    public Integer getOptionAsInteger(byte code) {
        DHCPOption opt = this.getOption(code);
        return opt == null ? null : Integer.valueOf(opt.getValueAsInt());
    }

    public InetAddress getOptionAsInetAddr(byte code) {
        DHCPOption opt = this.getOption(code);
        return opt == null ? null : opt.getValueAsInetAddr();
    }

    public String getOptionAsString(byte code) {
        DHCPOption opt = this.getOption(code);
        return opt == null ? null : opt.getValueAsString();
    }

    public short[] getOptionAsShorts(byte code) {
        DHCPOption opt = this.getOption(code);
        return opt == null ? null : opt.getValueAsShorts();
    }

    public InetAddress[] getOptionAsInetAddrs(byte code) {
        DHCPOption opt = this.getOption(code);
        return opt == null ? null : opt.getValueAsInetAddrs();
    }

    public byte[] getOptionAsBytes(byte code) {
        DHCPOption opt = this.getOption(code);
        return opt == null ? null : opt.getValueAsBytes();
    }

    public void setOptionAsByte(byte code, byte val) {
        this.setOption(DHCPOption.newOptionAsByte(code, val));
    }

    public void setOptionAsShort(byte code, short val) {
        this.setOption(DHCPOption.newOptionAsShort(code, val));
    }

    public void setOptionAsInt(byte code, int val) {
        this.setOption(DHCPOption.newOptionAsInt(code, val));
    }

    public void setOptionAsInetAddress(byte code, InetAddress val) {
        this.setOption(DHCPOption.newOptionAsInetAddress(code, val));
    }

    public void setOptionAsInetAddress(byte code, String val) throws UnknownHostException {
        this.setOption(DHCPOption.newOptionAsInetAddress(code, InetAddress.getByName(val)));
    }

    public void setOptionAsInetAddresses(byte code, InetAddress[] val) {
        this.setOption(DHCPOption.newOptionAsInetAddresses(code, val));
    }

    public void setOptionAsString(byte code, String val) {
        this.setOption(DHCPOption.newOptionAsString(code, val));
    }

    public byte[] getOptionRaw(byte code) {
        DHCPOption opt = this.getOption(code);
        return opt == null ? null : opt.getValueFast();
    }

    public DHCPOption getOption(byte code) {
        DHCPOption opt = this.options.get(code);
        if (opt == null) {
            return null;
        }
        return opt;
    }

    public boolean containsOption(byte code) {
        return this.options.containsKey(code);
    }

    public Collection<DHCPOption> getOptionsCollection() {
        return Collections.unmodifiableCollection(this.options.values());
    }

    public DHCPOption[] getOptionsArray() {
        return this.options.values().toArray(new DHCPOption[this.options.size()]);
    }

    public void setOptionRaw(byte code, byte[] buf) {
        if (buf == null) {
            this.removeOption(code);
        } else {
            this.setOption(new DHCPOption(code, buf));
        }
    }

    public void setOption(DHCPOption opt) {
        if (opt != null) {
            if (opt.getValueFast() == null) {
                this.removeOption(opt.getCode());
            } else {
                this.options.put(opt.getCode(), opt);
            }
        }
    }

    public void setOptions(DHCPOption[] opts) {
        if (opts != null) {
            for (DHCPOption opt : opts) {
                this.setOption(opt);
            }
        }
    }

    public void setOptions(Collection<DHCPOption> opts) {
        if (opts != null) {
            for (DHCPOption opt : opts) {
                this.setOption(opt);
            }
        }
    }

    public void removeOption(byte opt) {
        this.options.remove(opt);
    }

    public void removeAllOptions() {
        this.options.clear();
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        if (address == null) {
            this.address = null;
        } else {
            if (!(address instanceof Inet4Address)) {
                throw new IllegalArgumentException("only IPv4 addresses accepted");
            }
            this.address = address;
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public InetSocketAddress getAddrPort() {
        return new InetSocketAddress(this.address, this.port);
    }

    public void setAddrPort(InetSocketAddress addrPort) {
        if (addrPort != null) {
            this.setPort(addrPort.getPort());
            this.setAddress(addrPort.getAddress());
        } else {
            this.setPort(0);
            this.setAddress(null);
        }
    }

    static String bytesToString(byte[] buf) {
        return buf == null ? "" : DHCPPacket.bytesToString(buf, 0, buf.length);
    }

    static String bytesToString(byte[] buf, int src, int len) {
        if (buf == null) {
            return "";
        }
        Map<String, Integer> ret = DHCPPacket.calculateSourceAndLength(buf, src, len);
        int startPosition = ret.get("src");
        int length = ret.get("len");
        if (length <= 0 || startPosition >= buf.length) {
            return "";
        }
        for (int cursor = startPosition; cursor < startPosition + length; ++cursor) {
            if (buf[cursor] != 0) continue;
            length = cursor - startPosition;
            break;
        }
        char[] chars = new char[length];
        for (int cursor = startPosition; cursor < startPosition + length; ++cursor) {
            chars[cursor - startPosition] = (char)buf[cursor];
        }
        return new String(chars);
    }

    private static Map<String, Integer> calculateSourceAndLength(byte[] buf, int para_src, int para_len) {
        int startPosition = para_src;
        int length = para_len;
        if (startPosition < 0) {
            length += startPosition;
            startPosition = 0;
        }
        if (startPosition + length > buf.length) {
            length = buf.length - startPosition;
        }
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        ret.put("src", startPosition);
        ret.put("len", length);
        return ret;
    }

    static void appendHex(StringBuilder sbuf, byte bValue) {
        int i = bValue & 0xFF;
        sbuf.append(HEX[(i & 0xF0) >> 4]).append(HEX[i & 0xF]);
    }

    static void appendHex(StringBuilder sbuf, byte[] buf, int src, int len) {
        if (buf == null) {
            return;
        }
        if (src < 0) {
            len += src;
            src = 0;
        }
        if (len <= 0 || src >= buf.length) {
            return;
        }
        if (src + len > buf.length) {
            len = buf.length - src;
        }
        for (int i = src; i < src + len; ++i) {
            DHCPPacket.appendHex(sbuf, buf[i]);
        }
    }

    static void appendHex(StringBuilder sbuf, byte[] buf) {
        DHCPPacket.appendHex(sbuf, buf, 0, buf.length);
    }

    static String bytes2Hex(byte[] buf) {
        if (buf == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(buf.length * 2);
        DHCPPacket.appendHex(sb, buf);
        return sb.toString();
    }

    static byte[] hex2Bytes(String sValue) {
        if ((sValue.length() & 1) != 0) {
            throw new IllegalArgumentException("String length must be even: " + sValue.length());
        }
        byte[] buf = new byte[sValue.length() / 2];
        for (int index = 0; index < buf.length; ++index) {
            int stringIndex = index << 1;
            buf[index] = (byte)Integer.parseInt(sValue.substring(stringIndex, stringIndex + 2), 16);
        }
        return buf;
    }

    private static void appendHex(StringBuilder sbuf, int iValue) {
        DHCPPacket.appendHex(sbuf, (byte)((iValue & 0xFF000000) >>> 24));
        DHCPPacket.appendHex(sbuf, (byte)((iValue & 0xFF0000) >>> 16));
        DHCPPacket.appendHex(sbuf, (byte)((iValue & 0xFF00) >>> 8));
        DHCPPacket.appendHex(sbuf, (byte)(iValue & 0xFF));
    }

    public static byte[] stringToBytes(String str) {
        if (str == null) {
            return new byte[0];
        }
        char[] chars = str.toCharArray();
        int len = chars.length;
        byte[] buf = new byte[len];
        for (int i = 0; i < len; ++i) {
            buf[i] = (byte)chars[i];
        }
        return buf;
    }

    public static void appendHostAddress(StringBuilder sbuf, InetAddress addr) {
        if (addr == null) {
            throw new IllegalArgumentException("addr must not be null");
        }
        if (!(addr instanceof Inet4Address)) {
            throw new IllegalArgumentException("addr must be an instance of Inet4Address");
        }
        byte[] src = addr.getAddress();
        sbuf.append(src[0] & 0xFF).append('.').append(src[1] & 0xFF).append('.').append(src[2] & 0xFF).append('.').append(src[3] & 0xFF);
    }

    public static String getHostAddress(InetAddress addr) {
        StringBuilder sbuf = new StringBuilder(15);
        DHCPPacket.appendHostAddress(sbuf, addr);
        return sbuf.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public void copyAttributes(DHCPPacket other) {
        this.setHtype(other.getHtype());
        this.setXid(other.getXid());
        this.setCiaddrRaw(other.getCiaddrRaw());
        this.setChaddr(other.getChaddr());
        this.setHlen(other.getHlen());
        this.setFlags(other.getFlags());
        this.setGiaddrRaw(other.getGiaddrRaw());
    }
}

