/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.component.treetable;

import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.ui.component.treetable.DefaultTreeTableCellEditorFactory;
import com.huawei.ism.tool.obase.ui.component.treetable.DefaultTreeTableRanderFactory;
import com.huawei.ism.tool.obase.ui.component.treetable.ITreeTableCellEditorFactory;
import com.huawei.ism.tool.obase.ui.component.treetable.ITreeTableRendererFactory;
import com.huawei.ism.tool.obase.ui.component.treetable.ITreeTableRow;
import com.huawei.ism.tool.obase.ui.component.treetable.MutliHyperLinkCell;
import com.huawei.ism.tool.obase.ui.component.treetable.TreeTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class TreeTable
extends IsmTable {
    private static final long serialVersionUID = 1218868642512478375L;
    private static final int HOTSPOT_SIZE = 18;
    private ITreeTableRendererFactory rendererFactory;
    private ITreeTableCellEditorFactory cellEditorFacoty;
    private boolean checkBoxVisiable = false;
    private boolean bChildCheckBoxVisiable = true;
    private boolean isMutiSelect = true;
    private boolean multilevelMode = false;

    public TreeTable(TreeTableModel model) {
        super((TableModel)model);
        this.setGridColor(UIManager.getColor("Panel.background"));
        this.getSelectionModel().setSelectionMode(0);
        this.setRendererFactory(new DefaultTreeTableRanderFactory());
        this.setEditorFactory(new DefaultTreeTableCellEditorFactory());
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setRowSorter(null);
        this.setSelectionMode(2);
        this.getTableHeader().setReorderingAllowed(false);
        this.addMouseListener(new ToggleMouseHandler());
    }

    public TreeTable(TreeTableModel tableModel, boolean isMutiSelection) {
        this(tableModel);
        if (isMutiSelection) {
            this.setSelectionMode(2);
        }
    }

    public TreeTable(TreeTableModel model, boolean isMutiSelection, boolean isCheckBoxVisiable) {
        this(model);
        if (isMutiSelection) {
            this.setSelectionMode(2);
        } else {
            this.setSelectionMode(0);
        }
        this.isMutiSelect = isMutiSelection;
        this.checkBoxVisiable = isCheckBoxVisiable;
    }

    public TreeTable(TreeTableModel model, boolean isMutiSelection, boolean isCheckBoxVisiable, boolean isChildCheckBoxVisiable) {
        this(model, isMutiSelection, isCheckBoxVisiable);
        this.bChildCheckBoxVisiable = isChildCheckBoxVisiable;
    }

    public TreeTable(TreeTableModel model, boolean isMutiSelection, boolean isCheckBoxVisiable, boolean isChildCheckBoxVisiable, boolean multilevelMode) {
        this(model, isMutiSelection, isCheckBoxVisiable, isChildCheckBoxVisiable);
        this.multilevelMode = multilevelMode;
    }

    public boolean isChildCheckBoxVisiable() {
        return this.bChildCheckBoxVisiable;
    }

    public boolean isCheckBoxVisiable() {
        return this.checkBoxVisiable;
    }

    public void setCheckVisiable(boolean visiable) {
        this.checkBoxVisiable = visiable;
    }

    public boolean isMutliSelected() {
        return this.isMutiSelect;
    }

    public void setRendererFactory(ITreeTableRendererFactory factory) {
        this.rendererFactory = factory;
    }

    public void setEditorFactory(ITreeTableCellEditorFactory factory) {
        this.cellEditorFacoty = factory;
    }

    public ITreeTableRendererFactory getRendererFactory() {
        return this.rendererFactory;
    }

    public ITreeTableCellEditorFactory getEditorFactory() {
        return this.cellEditorFacoty;
    }

    public boolean isCellEditable(int rowInt, int colInt) {
        Object value = this.getValueAt(rowInt, colInt);
        if (value instanceof MutliHyperLinkCell) {
            return true;
        }
        if (value instanceof IsmTableCell.ComboBoxCell) {
            return true;
        }
        return value instanceof IsmTableCell.MsgTextCell;
    }

    public TableCellEditor getCellEditor(int rowInt, int colInt) {
        TableCellEditor defaultEditor = this.getEditorFactory().getTableCellEditor((JTable)((Object)this), rowInt, colInt);
        if (null == defaultEditor) {
            return super.getCellEditor(rowInt, colInt);
        }
        return defaultEditor;
    }

    public TableCellRenderer getCellRenderer(int rowInt, int colInt) {
        TableCellRenderer defaultRenderer = this.getRendererFactory().getTableCellRenderer((JTable)((Object)this), rowInt, colInt);
        if (null == defaultRenderer) {
            return super.getCellRenderer(rowInt, colInt);
        }
        return defaultRenderer;
    }

    public TreeTableModel getTreeTableModel() {
        return (TreeTableModel)this.getModel();
    }

    public Component prepareRenderer(TableCellRenderer renderer, int rowInt, int colInt) {
        boolean isSelected;
        Object value = this.getValueAt(rowInt, colInt);
        Component component = renderer.getTableCellRendererComponent((JTable)((Object)this), value, isSelected = this.isCellSelected(rowInt, colInt), false, rowInt, colInt);
        if (null != component) {
            component.setEnabled(true);
        }
        return component;
    }

    public List<ITreeTableRow<?, ?>> getSelectRows() {
        int[] rows = this.getSelectedRows();
        ArrayList rowList = new ArrayList();
        for (int ro : rows) {
            if (this.getTreeTableModel().getRowElement(ro) == null) {
                throw new NullPointerException("getTreeTableModel().getRowElement(i)");
            }
            ITreeTableRow<?, ?> row = this.getTreeTableModel().getRowElement(ro).getTableRow();
            rowList.add(row);
        }
        return rowList;
    }

    public List<TableRow> getMarkedRows() {
        ArrayList<TableRow> rowList = new ArrayList<TableRow>();
        List<TreeTableModel.RowItem> list = this.getTreeTableModel().getAllItemList();
        for (TreeTableModel.RowItem rowItem : list) {
            if (TreeTableModel.SelectType.UNSELECT.equals((Object)rowItem.getSelectType())) continue;
            ITreeTableRow<?, ?> row = rowItem.getTableRow();
            rowList.add(row);
        }
        return rowList;
    }

    public void setModel(TableModel newTableModel) {
        if (!(newTableModel instanceof TreeTableModel)) {
            throw new IllegalArgumentException("DataModel must be of type " + TreeTableModel.class.getName());
        }
        super.setModel(newTableModel);
        newTableModel.addTableModelListener(new NewModelListner());
    }

    public boolean isScrollableTracksViewportHeight() {
        return this.getPreferredSize().height < this.getParent().getHeight();
    }

    private void updateTableRowStatus(MouseEvent event) {
        TreeTable table = (TreeTable)((Object)event.getComponent());
        int row = table.rowAtPoint(event.getPoint());
        TreeTableModel model = table.getTreeTableModel();
        TreeTableModel.RowItem item = model.getRowElement(row);
        if (null == item) {
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("item is null.");
            return;
        }
        int eventX = event.getX();
        if (this.checkXValue(table, item, eventX)) {
            return;
        }
        TreeTableModel.RowItem rItem = model.getRowElement(row);
        if (null == rItem) {
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("rowItem is null.");
            return;
        }
        if (this.isMutiSelect) {
            this.eventXAboutHandle(event, row, model, eventX, rItem);
        } else {
            List<TreeTableModel.RowItem> rowItemList = model.getAllItemList();
            for (TreeTableModel.RowItem rI : rowItemList) {
                rI.setSelectType(TreeTableModel.SelectType.UNSELECT);
            }
            TreeTableModel.RowItem parentItem = this.getRowItem(rItem);
            int from = model.getRowItemIndex(parentItem);
            parentItem.setSelectType(TreeTableModel.SelectType.SELECT);
            int childSize = parentItem.getTableRow().getSubRowList().size();
            int to = from + childSize;
            for (int index = from + 1; index <= to && from < to; ++index) {
                TreeTableModel.RowItem subItem = model.getRowElement(index);
                if (null == subItem || !parentItem.equals(subItem.getParent())) continue;
                subItem.setSelectType(TreeTableModel.SelectType.SELECT);
            }
            model.fireTableRowsUpdated(from, to);
            this.repaint();
        }
    }

    private TreeTableModel.RowItem getRowItem(TreeTableModel.RowItem rItem) {
        TreeTableModel.RowItem parentItem = rItem.getParent();
        if (null == parentItem) {
            parentItem = rItem;
        }
        return parentItem;
    }

    private void eventXAboutHandle(MouseEvent event, int row, TreeTableModel model, int eventX, TreeTableModel.RowItem rItem) {
        if (this.multilevelMode) {
            this.eventXAboutHandleByDepthMoreThanTwo(event, row, model, eventX, rItem);
            return;
        }
        if (TreeTable.isSelectParentMouseEvent(eventX) && null == rItem.getParent()) {
            this.updateSubNodes(rItem, row, model);
        } else if (TreeTable.isSelectChildMouseEvent(eventX)) {
            this.updateParentNode(rItem, row, model);
        } else if (eventX > 69) {
            this.updateCellEditorByMouseClick(event);
        }
    }

    private void eventXAboutHandleByDepthMoreThanTwo(MouseEvent event, int row, TreeTableModel model, int eventX, TreeTableModel.RowItem rItem) {
        if (this.selsectCheckBox(rItem, eventX) && rItem.isCheckBoxVisible()) {
            this.updateMiddleNode(rItem, row, model);
        } else if (eventX > this.getSelectBoxRightBoundary(rItem)) {
            this.updateCellEditorByMouseClick(event);
        }
    }

    private int getSelectBoxRightBoundary(TreeTableModel.RowItem rItem) {
        return this.getCheckBoxLeftIndent(rItem) + 10 + 18;
    }

    public boolean selsectCheckBox(TreeTableModel.RowItem rowItem, int eventX) {
        int boxLeftIndent = this.getCheckBoxLeftIndent(rowItem) + 10;
        if (rowItem.getDepth() == 0) {
            return TreeTable.isSelectParentMouseEvent(eventX);
        }
        if (rowItem.getDepth() == 1) {
            return TreeTable.isSelectChildMouseEvent(eventX);
        }
        return eventX > boxLeftIndent && eventX < boxLeftIndent + 18;
    }

    private void updateMiddleNode(TreeTableModel.RowItem rowItem, int rowIndex, TreeTableModel model) {
        if (null == rowItem) {
            return;
        }
        TreeTableModel.SelectType childRenSelectedType = TreeTableModel.SelectType.SELECT;
        TreeTableModel.SelectType parentSelectType = rowItem.getSelectType();
        if (TreeTableModel.SelectType.SELECT == parentSelectType) {
            rowItem.setSelectType(TreeTableModel.SelectType.UNSELECT);
            childRenSelectedType = TreeTableModel.SelectType.UNSELECT;
        } else if (TreeTableModel.SelectType.UNSELECT == parentSelectType || TreeTableModel.SelectType.HALF == parentSelectType) {
            rowItem.setSelectType(TreeTableModel.SelectType.SELECT);
        }
        int lowestSubRowIndex = this.getLowestSubIndexAndUpdateAllSubNodes(rowItem, rowIndex, model, childRenSelectedType);
        int topParent = this.getTopParentIndexAndUpdateParents(rowItem, rowIndex, model);
        this.addRowSelectionInterval(rowIndex, rowIndex);
        model.fireTableRowsUpdated(topParent, lowestSubRowIndex);
    }

    private int getTopParentIndexAndUpdateParents(TreeTableModel.RowItem row, int rowIndex, TreeTableModel model) {
        TreeTableModel.RowItem item;
        TreeTableModel.RowItem parentItem = row.getParent();
        if (parentItem == null) {
            return rowIndex;
        }
        int parentIndex = model.getRowItemIndex(parentItem);
        int selectedSubItemCount = 0;
        int halfCount = 0;
        for (int index = parentIndex + 1; index <= model.getRowCount() && (item = model.getRowElement(index)) != null; ++index) {
            if (item.getParent() != parentItem) continue;
            if (TreeTableModel.SelectType.SELECT == item.getSelectType()) {
                ++selectedSubItemCount;
            }
            if (TreeTableModel.SelectType.HALF != item.getSelectType()) continue;
            ++halfCount;
        }
        if (selectedSubItemCount == 0 && halfCount == 0) {
            parentItem.setSelectType(TreeTableModel.SelectType.UNSELECT);
        } else if (selectedSubItemCount == parentItem.getTableRow().getSubRowList().size()) {
            parentItem.setSelectType(TreeTableModel.SelectType.SELECT);
        } else {
            parentItem.setSelectType(TreeTableModel.SelectType.HALF);
        }
        return this.getTopParentIndexAndUpdateParents(parentItem, parentIndex, model);
    }

    private int getLowestSubIndexAndUpdateAllSubNodes(TreeTableModel.RowItem parent, int parentIndex, TreeTableModel model, TreeTableModel.SelectType childRenSelectedType) {
        int lowestSubRowIndex = parentIndex;
        List<TreeTableModel.RowItem> itemList = model.getAllItemList();
        for (int i = 0; i < itemList.size(); ++i) {
            TreeTableModel.RowItem item = itemList.get(i);
            if (null == item || !this.isSubRow(parent, item)) continue;
            item.setSelectType(childRenSelectedType);
            lowestSubRowIndex = i;
        }
        return lowestSubRowIndex;
    }

    public boolean isSubRow(TreeTableModel.RowItem targetParent, TreeTableModel.RowItem subRow) {
        if (subRow.getParent() == null) {
            return false;
        }
        if (subRow.getParent().equals(targetParent)) {
            return true;
        }
        return this.isSubRow(targetParent, subRow.getParent());
    }

    public static boolean isSelectParentMouseEvent(int eventX) {
        return eventX > 36 && eventX < 46;
    }

    public static boolean isSelectChildMouseEvent(int eventX) {
        return eventX > 56 && eventX < 69;
    }

    private boolean checkXValue(TreeTable table, TreeTableModel.RowItem item, int eventX) {
        if (this.isaContractionAndUnfold(table, item, eventX)) {
            item.toggle();
            return true;
        }
        return false;
    }

    public boolean isaContractionAndUnfold(TreeTable table, TreeTableModel.RowItem item, int eventX) {
        int xValue = eventX - table.getCheckBoxLeftIndent(item);
        return xValue > 10 && xValue < 18;
    }

    private void updateCellEditorByMouseClick(MouseEvent me) {
        Component component = SwingUtilities.getDeepestComponentAt((Component)((Object)this), me.getX(), me.getY());
        if (component instanceof ToolHyperLinkLabel) {
            MouseListener[] listeners;
            ToolHyperLinkLabel lable = (ToolHyperLinkLabel)component;
            for (MouseListener li : listeners = lable.getMouseListeners()) {
                li.mouseClicked(me);
            }
        }
    }

    private void updateSubNodes(TreeTableModel.RowItem parent, int row, TreeTableModel model) {
        if (null == parent) {
            return;
        }
        TreeTableModel.SelectType childRenSelectedType = TreeTableModel.SelectType.SELECT;
        TreeTableModel.SelectType parentSelectType = parent.getSelectType();
        if (TreeTableModel.SelectType.SELECT == parentSelectType) {
            parent.setSelectType(TreeTableModel.SelectType.UNSELECT);
            childRenSelectedType = TreeTableModel.SelectType.UNSELECT;
        } else if (TreeTableModel.SelectType.UNSELECT == parentSelectType || TreeTableModel.SelectType.HALF == parentSelectType) {
            parent.setSelectType(TreeTableModel.SelectType.SELECT);
        }
        int from = row;
        int to = row + parent.getTableRow().getSubRowList().size();
        List<TreeTableModel.RowItem> itemList = model.getAllItemList();
        for (TreeTableModel.RowItem item : itemList) {
            if (null == item || !parent.equals(item.getParent())) continue;
            item.setSelectType(childRenSelectedType);
        }
        model.fireTableRowsUpdated(from, to);
    }

    private void updateParentNode(TreeTableModel.RowItem rowItem, int row, TreeTableModel model) {
        rowItem.reverse();
        TreeTableModel.RowItem parentItem = this.getRowItem(rowItem);
        int from = model.getRowItemIndex(parentItem);
        int childSize = parentItem.getTableRow().getSubRowList().size();
        int to = from + childSize;
        if (!this.isMutiSelect) {
            parentItem.setSelectType(TreeTableModel.SelectType.SELECT);
        } else {
            int selectedSubItemCount = 0;
            for (int index = from + 1; index <= to && from < to; ++index) {
                TreeTableModel.RowItem item = model.getRowElement(index);
                if (item == null) {
                    throw new NullPointerException("subItem");
                }
                if (TreeTableModel.SelectType.SELECT != item.getSelectType()) continue;
                ++selectedSubItemCount;
            }
            if (0 == selectedSubItemCount) {
                parentItem.setSelectType(TreeTableModel.SelectType.UNSELECT);
            } else if (selectedSubItemCount > 0 && selectedSubItemCount < childSize) {
                parentItem.setSelectType(TreeTableModel.SelectType.HALF);
            } else {
                parentItem.setSelectType(TreeTableModel.SelectType.SELECT);
            }
        }
        this.addRowSelectionInterval(row, row);
        model.fireTableRowsUpdated(row, row);
        model.fireTableRowsUpdated(from, from);
    }

    public int getCheckBoxLeftIndent(TreeTableModel.RowItem rowItem) {
        if (null == rowItem) {
            return 18;
        }
        if (rowItem.getParent() == null && !rowItem.hasExpandAndCollapseIcon() && !this.checkBoxVisiable) {
            return 18;
        }
        if (rowItem.hasExpandAndCollapseIcon()) {
            return rowItem.getDepth() * 18;
        }
        return (rowItem.getDepth() + 1) * 18;
    }

    private class ToggleMouseHandler
    extends MouseAdapter {
        private ToggleMouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            TreeTable.this.updateTableRowStatus(event);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                this.togRow(e);
            }
        }

        private void togRow(MouseEvent event) {
            Component component = event.getComponent();
            if (component instanceof TreeTable) {
                TreeTable table = (TreeTable)((Object)component);
                int row = table.rowAtPoint(event.getPoint());
                table.getTreeTableModel().getRowElement(row).toggle();
            }
        }
    }

    private static class NewModelListner
    implements TableModelListener {
        private NewModelListner() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
        }
    }
}

