/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.parser;

import com.huawei.ism.autotest.AutoProcessConfig;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.bizpack.BizPackage;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.context.JythonContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizPackGroup;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizWizardConfig;
import com.huawei.ism.tool.bizpack.wizardparse.entity.item.Item;
import com.huawei.ism.tool.bizpack.wizardparse.parser.ParseProcessException;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.doitem.DoItemStepCfg;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.group.GroupStepCfg;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.awt.Dimension;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BizWizardCfgParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(BizWizardCfgParser.class);
    private static final String PROCESS_GROUP = "process-group";
    private static final String PROCESS_NODE = "process";
    private static final String CONF_ATTRIBUTE = "conf";
    private static final String STEP = "step";
    private static final String SUB_STEP = "sub-step";
    private static final String SUB_STEP_TYPE = "stepGroup";
    private static final String PROCESSES_XML = "processes.xml";
    private static final String CLAZZ_CFG_XML = "config/bizpack/step/stepCfg.xml";
    private static final Dimension DEFAULT_WIZARD_SIZE = new Dimension(550, 651);
    private static final String SEP = "seperator";
    private Map<String, Class<? extends BizStepConfig>> typeToStepCfg = new HashMap<String, Class<? extends BizStepConfig>>();
    private Map<String, String> typeToStep = new HashMap<String, String>();

    public BizWizardCfgParser() {
        this.loadClazzFromCfg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadClazzFromCfg() {
        Document document;
        InputStream clazzXmlStream = null;
        try {
            clazzXmlStream = FileUtils.getStreamWithObj(BizWizardCfgParser.class, CLAZZ_CFG_XML);
            document = XmlUtils.parseDocument((InputStream)clazzXmlStream);
        }
        finally {
            StreamUtils.closeResource(null, (Closeable)clazzXmlStream);
        }
        Element root = document.getDocumentElement();
        Collection clazzCfgNodes = XmlUtils.getChildren((Element)root, (String)"stepCfg");
        for (Element clazzCfgNode : clazzCfgNodes) {
            String typeName = this.getAttribute(clazzCfgNode, "type", "");
            String cfgClazzName = this.getAttribute(clazzCfgNode, "cfgClazz", "");
            String stepClazzName = this.getAttribute(clazzCfgNode, "stepClazz", "");
            this.typeToStep.put(typeName, stepClazzName);
            try {
                Class<?> tmpClazz;
                Class<?> cfgClazz = tmpClazz = Class.forName(cfgClazzName);
                this.typeToStepCfg.put(typeName, cfgClazz);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("load step cfg clazz error.", (Throwable)e);
            }
            finally {
                StreamUtils.closeStream(null, (InputStream)clazzXmlStream);
            }
        }
    }

    public void parseProcess(BizPackage bizPackage) {
        bizPackage.setResUtil(new PackagesResource(bizPackage.getAbsolutPath()));
        String bizPackagePath = bizPackage.getAbsolutPath();
        StringBuilder xmlPath = new StringBuilder();
        xmlPath.append(bizPackagePath);
        xmlPath.append(File.separator);
        xmlPath.append(PROCESS_NODE);
        xmlPath.append(File.separator);
        xmlPath.append(PROCESSES_XML);
        this.getAllGroups(xmlPath.toString(), bizPackage);
    }

    private void getAllGroups(String xmlPath, BizPackage bizPackage) {
        String scriptName;
        File xmlFile = new File(xmlPath);
        Document document = this.initXMLDocument(xmlFile);
        if (document == null) {
            return;
        }
        ArrayList<File> clsPath = new ArrayList<File>();
        String processDir = bizPackage.getAbsolutPath() + File.separator + PROCESS_NODE;
        clsPath.add(new File(processDir));
        bizPackage.setJythonExecuter(new JythonExecuter(clsPath));
        Element root = document.getDocumentElement();
        bizPackage.setHelp(this.getTotalHelpByScene(root));
        bizPackage.setCancelScript(this.getAttribute(root, "cancelScript", ""));
        if (BizPackageContext.getInstance().isSelfDefine()) {
            String mainDialogTitle = this.getAttribute(root, "mainDialogTitle", "");
            BizPackageContext.getInstance().setMainDialogTitle(mainDialogTitle);
        }
        if (!StringUtils.isNULLStr((String)(scriptName = this.getAttribute(root, "script", "")))) {
            this.parseGroupFromScript(scriptName, bizPackage);
            return;
        }
        NodeList nodeList = root.getElementsByTagName(PROCESS_GROUP);
        if (nodeList == null || nodeList.getLength() == 0) {
            return;
        }
        int length = nodeList.getLength();
        if (length > 1) {
            this.parseGroupType(bizPackage, nodeList);
        } else {
            bizPackage.setGroupType(false);
            List<BizWizardConfig> wizardList = bizPackage.getBizWizardCfg();
            for (int index = 0; index < length; ++index) {
                Element nodeElement = (Element)nodeList.item(index);
                this.parseOneGroup(nodeElement, bizPackage, wizardList);
            }
        }
    }

    private String getTotalHelpByScene(Element root) {
        if (SceneUtils.isA800SceneInTool()) {
            return this.getAttribute(root, "a800help", "");
        }
        return this.getAttribute(root, "help", "");
    }

    private void parseGroupFromScript(String scriptName, BizPackage bizPackage) {
        JythonContext ssEnv = BizPackageContext.getInstance().getJythonContext();
        ssEnv.putExtUtil();
        this.execScript(scriptName, bizPackage, ssEnv);
        if (!((Boolean)ssEnv.getDict().get("succ")).booleanValue()) {
            String errMsg = (String)ssEnv.getDict().get("errMsg");
            if (StringUtils.isNULLStr((String)errMsg)) {
                errMsg = ResourceUtil.getString("bizpackage.error.parseoneproductsfailed");
            }
            throw new ParseProcessException(errMsg);
        }
        String jsonStr = (String)ssEnv.getDict().get("processesCfg");
        ParseProcessException parseProcessException = null;
        try {
            this.parseJsonConfig(jsonStr, bizPackage);
        }
        catch (Exception e) {
            LOGGER.error("parse process xml info error when parsing json string.", (Throwable)e);
            String errMsg = ResourceUtil.getString("bizpackage.error.parseoneproductsfailed");
            parseProcessException = new ParseProcessException(errMsg);
            throw parseProcessException;
        }
    }

    private void parseJsonConfig(String jsonStr, BizPackage bizPackage) {
        JSONArray jsonArray = new JSONArray(jsonStr);
        if (jsonArray.length() > 1) {
            this.parseGroupTypeFromScript(bizPackage, jsonArray);
        } else {
            bizPackage.setGroupType(false);
            List<BizWizardConfig> wizardList = bizPackage.getBizWizardCfg();
            JSONObject oneGroupJson = (JSONObject)jsonArray.get(0);
            this.parseOneGroupFromScript(bizPackage, wizardList, oneGroupJson);
        }
    }

    private void parseGroupTypeFromScript(BizPackage bizPackage, JSONArray jsonArray) {
        bizPackage.setGroupType(true);
        List<BizPackGroup> groupList = bizPackage.getGroupList();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = (JSONObject)jsonArray.get(i);
            String name = jsonObject.getString("name");
            String icon = jsonObject.getString("icon");
            String desc = jsonObject.getString("desc");
            if (!StringUtils.isNULLStr((String)name) && name.equals(SEP)) {
                BizPackGroup seperator = new BizPackGroup();
                seperator.setSeperator(true);
                seperator.setDescription(desc);
                groupList.add(seperator);
                continue;
            }
            BizPackGroup bizPackGroup = new BizPackGroup();
            groupList.add(bizPackGroup);
            bizPackGroup.setDescription(desc);
            bizPackGroup.setTitle(name);
            bizPackGroup.setIconPath(icon);
            List<BizWizardConfig> wizardConfigList = bizPackGroup.getBizWizardCfg();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("parseOneGroup groupName=" + name);
            }
            try {
                this.parseOneGroupFromScript(bizPackage, wizardConfigList, jsonObject);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("parseOneGroup err" + e);
            }
        }
    }

    private void parseOneGroupFromScript(BizPackage bizPackage, List<BizWizardConfig> wizardList, JSONObject oneGroupJson) {
        String bizPackagePath = bizPackage.getAbsolutPath();
        JSONArray jsonArray = oneGroupJson.getJSONArray(PROCESS_NODE);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = (JSONObject)jsonArray.get(i);
            String subProcess = jsonObject.getString(CONF_ATTRIBUTE);
            StringBuilder subProcessPath = new StringBuilder();
            subProcessPath.append(bizPackagePath);
            subProcessPath.append(File.separator);
            subProcessPath.append(PROCESS_NODE);
            subProcessPath.append(File.separator);
            subProcessPath.append(subProcess);
            this.parseOneProcess(subProcessPath.toString(), wizardList);
        }
    }

    private void execScript(String scriptName, BizPackage bizPackage, JythonContext ssEnv) {
        String processDir = bizPackage.getAbsolutPath() + File.separator + PROCESS_NODE;
        ParseProcessException parseProcessException = null;
        try {
            JythonExecuter jythonExecuter = bizPackage.getJythonExecuter();
            String pyPath = processDir + File.separator + scriptName;
            File pyFile = new File(pyPath);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("parse processes xml execute script : " + pyPath);
            }
            ssEnv.getDict().put("logger", LOGGER);
            jythonExecuter.compileScript(pyFile);
            ssEnv.clearMsgData();
            jythonExecuter.invokeFunction("execute", ssEnv.getDict());
        }
        catch (SignException e) {
            LOGGER.error("parse process xml info error when executing script sign exception.", (Throwable)e);
            String errMsg = ResourceUtil.getString("bizpackage.error.doitem.scriptfile.notsigned.suggestion");
            parseProcessException = new ParseProcessException(errMsg);
        }
        catch (Exception e) {
            LOGGER.error("parse process xml info error when executing script.", (Throwable)e);
            String errMsg = ResourceUtil.getString("bizpackage.error.parseoneproductsfailed");
            parseProcessException = new ParseProcessException(errMsg);
        }
        if (null != parseProcessException) {
            throw parseProcessException;
        }
    }

    private void parseGroupType(BizPackage bizPackage, NodeList nodeList) {
        bizPackage.setGroupType(true);
        List<BizPackGroup> groupList = bizPackage.getGroupList();
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element nodeElement = (Element)nodeList.item(index);
            String textContent = nodeElement.getTextContent();
            if (!"".equals(textContent) && null != textContent && textContent.equals(SEP)) {
                BizPackGroup seperator = new BizPackGroup();
                seperator.setSeperator(true);
                seperator.setDescription(this.getAttribute(nodeElement, "desc", ""));
                groupList.add(seperator);
                continue;
            }
            BizPackGroup bizPackGroup = new BizPackGroup();
            groupList.add(bizPackGroup);
            bizPackGroup.setDescription(this.getAttribute(nodeElement, "desc", ""));
            bizPackGroup.setTitle(this.getAttribute(nodeElement, "name", ""));
            bizPackGroup.setIconPath(this.getAttribute(nodeElement, "icon", ""));
            List<BizWizardConfig> wizardConfigList = bizPackGroup.getBizWizardCfg();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("parseOneGroup groupName=" + this.getAttribute(nodeElement, "name", ""));
            }
            try {
                this.parseOneGroup(nodeElement, bizPackage, wizardConfigList);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("parseOneGroup err" + e);
            }
        }
    }

    private void parseOneGroup(Element nodeElement, BizPackage bizPackage, List<BizWizardConfig> wizardList) {
        String bizPackagePath = bizPackage.getAbsolutPath();
        List<String> processPathList = this.getProcesses(nodeElement);
        for (String subProcess : processPathList) {
            StringBuilder subProcessPath = new StringBuilder();
            subProcessPath.append(bizPackagePath);
            subProcessPath.append(File.separator);
            subProcessPath.append(PROCESS_NODE);
            subProcessPath.append(File.separator);
            subProcessPath.append(subProcess);
            this.parseOneProcess(subProcessPath.toString(), wizardList);
        }
    }

    private void parseOneProcess(String subProcessPath, List<BizWizardConfig> wizardList) {
        File xmlFile = new File(subProcessPath);
        Document document = this.initXMLDocument(xmlFile);
        if (document == null) {
            return;
        }
        BizWizardConfig wizardCfg = new BizWizardConfig();
        wizardList.add(wizardCfg);
        Element root = document.getDocumentElement();
        wizardCfg.setId(this.getAttribute(root, "id", ""));
        wizardCfg.setHelpPath(this.getAttribute(root, "help", ""));
        wizardCfg.setIconPath(this.getAttribute(root, "icon", ""));
        wizardCfg.setIniScriptName(this.getAttribute(root, "initScript", ""));
        wizardCfg.setIsCancelled(this.getAttribute(root, "isCancelled", ""));
        wizardCfg.setIniScriptParam(this.getAttribute(root, "param", ""));
        wizardCfg.setDescription(this.getAttribute(root, "desc", ""));
        wizardCfg.setTitle(this.getAttribute(root, "title", ""));
        wizardCfg.setGuideType(this.getAttribute(root, "guideType", ""));
        String wizardTitle = this.getAttribute(root, "wizardtitle", "");
        if (!"".equals(wizardTitle.trim())) {
            wizardCfg.setWizardTitle(wizardTitle);
        } else {
            wizardCfg.setWizardTitle(this.getAttribute(root, "title", ""));
        }
        String sizeStr = root.getAttribute("size");
        Dimension size = DEFAULT_WIZARD_SIZE;
        try {
            if (!StringUtils.isNULLStr((String)sizeStr)) {
                String[] sizeList = sizeStr.split(",");
                int xi = Integer.parseInt(sizeList[0].trim());
                int yi = Integer.parseInt(sizeList[1].trim());
                size = new Dimension(xi, yi);
            }
        }
        catch (Exception e) {
            LOGGER.error("Load WizardSize ERR", (Throwable)e);
            size = DEFAULT_WIZARD_SIZE;
        }
        List<BizStepConfig> steps = wizardCfg.getSteps();
        wizardCfg.setWizardSize(size);
        try {
            this.loadSteps(root, steps, STEP);
            this.filterAutoProcessSteps(wizardCfg.getTitle(), steps);
        }
        catch (Exception e) {
            LOGGER.error("parseOneProcess all steps err", (Throwable)e);
        }
    }

    private void filterAutoProcessSteps(String processTitle, List<BizStepConfig> steps) {
        if (!UserOpDataSaveUtil.isAutoTestEnv()) {
            return;
        }
        AutoProcessConfig config = AutoProcessConfig.getInstance();
        PackagesResource resource = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        String processName = resource.getString(processTitle);
        List autoStepIds = (List)config.getProcessSteps().get(processName);
        if (autoStepIds == null) {
            return;
        }
        for (int i = steps.size() - 1; i >= 0; --i) {
            String stepId = steps.get(i).getId();
            if (!autoStepIds.contains(stepId)) {
                steps.remove(i);
                continue;
            }
            String checkItemKey = String.format(Locale.ROOT, "%s#%s", processName, stepId);
            this.filterAutoProcessCheckItems(config, checkItemKey, steps.get(i));
        }
    }

    private void filterAutoProcessCheckItems(AutoProcessConfig config, String checkItemKey, BizStepConfig step) {
        List autoCheckItems = (List)config.getStepCheckItems().get(checkItemKey);
        if (autoCheckItems == null || autoCheckItems.size() == 0) {
            return;
        }
        if (!(step instanceof DoItemStepCfg)) {
            return;
        }
        List<Item> items = ((DoItemStepCfg)step).getCheckItem();
        for (int i = items.size() - 1; i >= 0; --i) {
            String itemId = items.get(i).getId();
            if (autoCheckItems.contains(itemId)) continue;
            items.remove(i);
        }
    }

    private void loadSteps(Element root, List<BizStepConfig> steps, String stepTagName) {
        NodeList nodeList = root.getElementsByTagName(stepTagName);
        if (nodeList == null || nodeList.getLength() == 0) {
            return;
        }
        int length = nodeList.getLength();
        for (int index = 0; index < length; ++index) {
            Element nodeElement = (Element)nodeList.item(index);
            String type = this.getAttribute(nodeElement, "type", "").trim();
            if (SUB_STEP_TYPE.equalsIgnoreCase(type)) {
                GroupStepCfg stepCfg = new GroupStepCfg();
                stepCfg.setTitle(this.getAttribute(nodeElement, "title", ""));
                stepCfg.setDescription(this.getAttribute(nodeElement, "desc", ""));
                List<BizStepConfig> subSteps = stepCfg.getSubStepList();
                this.loadSteps(nodeElement, subSteps, SUB_STEP);
                steps.add(stepCfg);
                continue;
            }
            if ("".equals(type) || !this.typeToStep.containsKey(type)) continue;
            String stepClzName = this.typeToStep.get(type);
            Class<? extends BizStepConfig> stepCfgClz = this.typeToStepCfg.get(type);
            try {
                BizStepConfig stepCfg = stepCfgClz.newInstance();
                stepCfg.setStepClazPathName(stepClzName);
                stepCfg.setProcessId(this.getAttribute(root, "id", ""));
                steps.add(stepCfg);
                stepCfg.loadConfig(nodeElement);
                continue;
            }
            catch (InstantiationException e) {
                LOGGER.error("Instance StepCfgClz ERR ", (Throwable)e);
                continue;
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Instance StepCfgClz failed ", (Throwable)e);
            }
        }
    }

    public List<String> getProcesses(Element node) {
        ArrayList<String> processes = new ArrayList<String>();
        NodeList nodeList = node.getElementsByTagName(PROCESS_NODE);
        if (nodeList == null || nodeList.getLength() == 0) {
            return processes;
        }
        int length = nodeList.getLength();
        for (int index = 0; index < length; ++index) {
            Element nodeElement = (Element)nodeList.item(index);
            processes.add(nodeElement.getAttribute(CONF_ATTRIBUTE));
        }
        return processes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document initXMLDocument(File xmlFile) {
        Document document = null;
        if (!xmlFile.exists() || !xmlFile.isFile()) {
            LOGGER.error("the xml config file is not exist or the file is not a file. " + xmlFile);
            return document;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(xmlFile);
            document = XmlUtils.parseDocument((InputStream)is);
        }
        catch (Exception e) {
            LOGGER.error("init xml parser error,the file is:" + xmlFile, (Throwable)e);
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)is);
        }
        return document;
    }

    private String getAttribute(Element element, String attriName, String defaultValue) {
        String attribute = element.getAttribute(attriName);
        if (StringUtils.isNULLStr((String)attribute)) {
            attribute = defaultValue;
        }
        return attribute.trim();
    }
}

