/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.action;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.BizPackage;
import com.huawei.ism.tool.bizpack.PackProduct;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.PreCheckResultDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.SelectDeviceDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.PrecheckWaitDialog;
import com.huawei.ism.tool.bizpack.wizardparse.util.DevNodeUtil;
import com.huawei.ism.tool.devicemanager.ui.dialog.FcvSelectControllerEnclosureJDialog;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.IDeviceManage;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.ui.component.wizard.IHelpActionCallBack;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfirmAction
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfirmAction.class);
    private SelectDeviceDialog selectDialog;

    public ConfirmAction(SelectDeviceDialog dialog) {
        this.selectDialog = dialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LOGGER.info("select device perform.");
        if (this.selectDialog.getSddLayout().getDeviceTable().getMarkedRows().isEmpty()) {
            DialogUtils.showErrorDialog((JDialog)this.selectDialog, (String)ResourceUtil.getString("bizpackage.supportdialog.error.nodev"));
            return;
        }
        if (BizPackageContext.getInstance().isSelfDefine() && !BizPackageContext.getInstance().isSingleDev()) {
            List selectRows = this.selectDialog.getSddLayout().getDeviceTable().getMarkedRows();
            HashMap<String, Map<String, String>> devList = new HashMap<String, Map<String, String>>();
            int i = 0;
            for (TableRow tableRow : selectRows) {
                DevNode devNode = (DevNode)tableRow.getIdentifier();
                devList.put(devNode.getIp(), DevNodeUtil.getDevMapDict(devNode));
                BizPackageContext.getInstance().getJythonContext().getDict().put("devNode" + i++, devNode);
                BizPackageContext.getInstance().setCurDevice(devNode);
                try {
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.info("Select divece " + devNode.getIp() + " success.");
                }
                catch (Exception e2) {
                    LOGGER.error("Log records failed", (Throwable)e2);
                }
            }
            BizPackageContext.getInstance().getJythonContext().getDict().put("devMap", devList);
        } else if (this.handleSingleDev()) {
            return;
        }
        if (!this.isPreCheckSuc(this.selectDialog.getSddLayout().getDeviceTable().getMarkedRows())) {
            LOGGER.info("Select device for upgrade disk failed. pre check  failed.");
            return;
        }
        DevNodeUtil.parseAndBuildDialog(this.selectDialog);
    }

    public boolean handleSingleDev() {
        TableRow selectRow = this.selectDialog.getSddLayout().getDeviceTable().getMarkedRow();
        if (selectRow == null) {
            DialogUtils.showErrorDialog((JDialog)this.selectDialog, (String)ResourceUtil.getString("bizpackage.supportdialog.error.nodev"));
            return true;
        }
        DevNode node = (DevNode)selectRow.getIdentifier();
        if (!DevNodeUtil.matchingBizpackage(node)) {
            DialogUtils.showErrorDialog((JDialog)this.selectDialog, (String)ResourceUtil.getString("bizpackage.supportdialog.error.notSupport"));
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Select divece " + node.getIp() + " failed. matchingBizpackage failed.");
            }
            return true;
        }
        if (node.isComputeStorage() && node.getComputeStorageDevNode() != null) {
            return this.selectFcvCtrlEnclosure(node);
        }
        BizPackageContext.getInstance().getJythonContext().getDict().put("devNode0", node);
        BizPackageContext.getInstance().getJythonContext().getDict().put("dev", DevNodeUtil.getDevMapDict(node));
        BizPackageContext.getInstance().getJythonContext().setDevNode(node);
        BizPackageContext.getInstance().setCurDevice(node);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Select device " + node.getIp() + " success.");
        }
        return false;
    }

    private boolean selectFcvCtrlEnclosure(DevNode node) {
        List<Map<String, String>> storageList = node.getComputeStorageDevNode().getStorageNodesInfo();
        List storageDevList = storageList.stream().map(stringStringMap -> EntityUtils.convertMapToOldDevNode((DevNode)node, (Map)stringStringMap)).collect(Collectors.toList());
        FcvSelectControllerEnclosureJDialog fcvDialog = new FcvSelectControllerEnclosureJDialog((Window)this.selectDialog, storageDevList, BizPackageContext.getInstance().isSingleDev());
        fcvDialog.setHelpActionCallBack((IHelpActionCallBack)new FcvSelectControllerEnclosureJDialog.OpenHelpCallBack((JDialog)fcvDialog));
        fcvDialog.setVisible(true);
        if (fcvDialog.getStorageDevNodeList().isEmpty()) {
            DialogUtils.showErrorDialog((JDialog)this.selectDialog, (String)ResourceUtil.getString("bizpackage.supportdialog.error.nodev"));
            return true;
        }
        DevNode newStorageNode = (DevNode)fcvDialog.getStorageDevNodeList().get(0);
        BizPackageContext.getInstance().getJythonContext().getDict().put("devNode0", newStorageNode);
        BizPackageContext.getInstance().getJythonContext().getDict().put("dev", DevNodeUtil.getDevMapDict(newStorageNode));
        BizPackageContext.getInstance().getJythonContext().setDevNode(newStorageNode);
        BizPackageContext.getInstance().setCurDevice(newStorageNode);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Select fcv device:%{}, storage ip:{} success.", (Object)node.getIp(), (Object)newStorageNode.getIp());
        }
        return false;
    }

    public void svpEnterPerform() {
        IDeviceManage devMng = PublicServiceManage.getInstance().getService(IDeviceManage.class);
        DevNode node = devMng.getNodeList().get(0);
        if (null == node) {
            DialogUtils.showErrorDialog(null, (String)ResourceUtil.getString("bizpackage.supportdialog.error.nodev"));
            return;
        }
        if (!DevNodeUtil.matchingBizpackage(node)) {
            DialogUtils.showErrorDialog(null, (String)ResourceUtil.getString("bizpackage.supportdialog.error.notSupport"));
            return;
        }
        BizPackageContext.getInstance().getJythonContext().getDict().put("dev", DevNodeUtil.getDevMapDict(node));
        BizPackageContext.getInstance().getJythonContext().setDevNode(node);
        BizPackageContext.getInstance().setCurDevice(node);
        DevNodeUtil.parseAndBuildDialog(this.selectDialog);
    }

    private boolean isPreCheckSuc(List<TableRow> selectRows) {
        if (!this.isNeedPrecheck()) {
            return true;
        }
        List fs = AsyncExcutor.execute((Window)this.selectDialog, (Callable[])new Callable[]{new PrecheckWaitDialog(this.getSelectDevs(selectRows))});
        Map resultMap = (Map)fs.get(0);
        if (resultMap.isEmpty()) {
            return true;
        }
        PreCheckResultDialog checkResultDialog = new PreCheckResultDialog(this.selectDialog, resultMap);
        checkResultDialog.setVisible(true);
        return checkResultDialog.isPreCheckResult();
    }

    private List<DevNode> getSelectDevs(List<TableRow> selectRows) {
        ArrayList<DevNode> devs = new ArrayList<DevNode>();
        for (TableRow tableRow : selectRows) {
            DevNode devNode = (DevNode)tableRow.getIdentifier();
            devs.add(devNode);
        }
        return devs;
    }

    private boolean isNeedPrecheck() {
        List selectRows = this.selectDialog.getSddLayout().getDeviceTable().getMarkedRows();
        for (TableRow tableRow : selectRows) {
            DevNode devNode = (DevNode)tableRow.getIdentifier();
            if (!this.isOneDevNeedCheck(devNode)) continue;
            return true;
        }
        return false;
    }

    private boolean isOneDevNeedCheck(DevNode dev) {
        List<BizPackage> packages = BizPackageContext.getInstance().getBizPackages();
        for (BizPackage bizPackage : packages) {
            List<PackProduct> products = bizPackage.getPackProducts();
            for (PackProduct packProduct : products) {
                String script = packProduct.getScript();
                if (!BizPackageContext.getInstance().containDevNode(dev, packProduct) || StringUtils.isNULLStr(script)) continue;
                return true;
            }
        }
        return false;
    }
}

