/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.dialog;

import com.huawei.ism.autotest.AutoProcessConfig;
import com.huawei.ism.autotest.AutoProcessListener;
import com.huawei.ism.autotest.AutoProcessObserver;
import com.huawei.ism.autotest.AutoProcessStatus;
import com.huawei.ism.autotest.IAutoProcess;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.context.JythonContext;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyScriptTask;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.GridFileChooser;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.GetUserInPutDialogLayout;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.GetUserInputWaitDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.WaitDialogResult;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetUserInPutDialog
extends JDialog
implements IAutoProcess {
    private static final Logger log = LoggerFactory.getLogger(GetUserInPutDialog.class);
    protected static final String PROCESS = "process";
    private static final long serialVersionUID = 9006706721348538283L;
    private static final String ID = "id";
    private GetUserInPutDialogLayout layout;
    private String checkScript = "";
    private String checkMethod = "";
    private String jsonStr = "";
    private Dimension size = new Dimension(300, 200);
    private List<String> inputIdList = new ArrayList<String>();
    private transient JythonContext ssEnv = BizPackageContext.getInstance().getJythonContext();
    private List<AutoProcessObserver> observers = new ArrayList<AutoProcessObserver>();

    public GetUserInPutDialog(Window parent, String dialogInfo, String checkScript, String checkMethod, String inputJsonArray) {
        super(parent);
        this.setDialogInfo(dialogInfo, inputJsonArray);
        this.setInputIdList(inputJsonArray);
        this.jsonStr = inputJsonArray;
        this.checkScript = checkScript;
        this.checkMethod = checkMethod;
        this.initListener();
        this.setLayout(new BorderLayout());
        this.add((Component)this.layout, "Center");
        this.setSize(this.size);
        this.setResizable(false);
        Dimension location = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(location.width / 2 - this.getWidth() / 2, location.height / 2 - this.getHeight() / 2);
        this.setModal(true);
        this.addComponentListener((ComponentListener)new AutoProcessListener((IAutoProcess)this));
        new AutoProcessObserver((IAutoProcess)this);
    }

    private void setDialogInfo(String dialogInfo, String inputJsonArray) {
        JSONObject dialogJson = new JSONObject(dialogInfo);
        String title = dialogJson.getString("title");
        this.ssEnv = BizPackageContext.getInstance().getJythonContext();
        this.setTitle(title);
        String desc = dialogJson.getString("desc");
        String width = dialogJson.getString("width");
        String height = dialogJson.getString("height");
        try {
            this.size = new Dimension(Integer.parseInt(width), Integer.parseInt(height));
            this.layout = new GetUserInPutDialogLayout(desc, inputJsonArray, this.size);
        }
        catch (Exception e) {
            log.error("parse dialog size err", (Throwable)e);
        }
    }

    private void initListener() {
        this.layout.getCancel().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GetUserInPutDialog.this.exitWindow();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GetUserInPutDialog.this.exitWindow();
            }
        });
        this.layout.getConfirm().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GetUserInPutDialog.this.confirmAction();
            }
        });
        this.initCompListener();
    }

    private void exitWindow() {
        WarningDialog wdialog = DialogUtils.createWarningDialog((JDialog)this, (String)ResourceUtil.getString("bizpackage.desc.quite"));
        if (0 == wdialog.getValue()) {
            this.ssEnv.getDict().put("succ", false);
            this.dispose();
        }
    }

    private void confirmAction() {
        this.layout.clearErrMsg();
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        for (String id : this.inputIdList) {
            Component input = this.layout.getId2Component().get(id);
            String text = "";
            if (input instanceof JTextField) {
                text = ((JTextField)input).getText();
            } else if (input instanceof JPasswordField) {
                text = ((JTextField)input).getText();
            } else if (input instanceof JComboBox) {
                text = (String)((JComboBox)input).getSelectedItem();
            } else if (input instanceof GridFileChooser) {
                text = ((GridFileChooser)input).getAddressField().getText();
            } else if (input instanceof JRadioButton) {
                text = ((JRadioButton)input).getText();
            }
            jsonMap.put(id, text);
        }
        JSONObject json = new JSONObject(jsonMap);
        this.ssEnv.getDict().put("curData", json.toString());
        SwingUtilities.invokeLater(new RefreshRunnable());
    }

    private void initCompListener() {
        for (String id : this.inputIdList) {
            Component input = this.layout.getId2Component().get(id);
            if (input instanceof JComboBox) {
                this.initOneComboBoxListener(input, id);
                continue;
            }
            if (input instanceof GridFileChooser) {
                ((GridFileChooser)input).initListener(this);
                continue;
            }
            if (!(input instanceof JRadioButton)) continue;
            this.initRadioButtonListener(input);
        }
    }

    private void initRadioButtonListener(Component input) {
        final JRadioButton radioBtn = (JRadioButton)input;
        if (radioBtn.isSelected()) {
            String radioData = radioBtn.getText();
            this.ssEnv.getDict().put("radioData", radioData);
        }
        radioBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String radioData = radioBtn.getText();
                GetUserInPutDialog.this.ssEnv.getDict().put("radioData", radioData);
            }
        });
    }

    private void initOneComboBoxListener(Component input, String id) {
        JComboBox comboBox = (JComboBox)input;
        JSONObject json = this.getJsonObjById(id);
        if (null == json || !json.has("refreshScript") || !json.has("refreshItems")) {
            log.error("get json by id {} error.", (Object)id);
            return;
        }
        String refreshScript = json.getString("refreshScript");
        String execFunc = json.getStringOrDefault("execFunc", "refresh");
        Arrays.stream(this.parseNeedRefreshItems(json.getString("refreshItems"))).peek(refreshItem -> log.info("add item listener: {}", refreshItem)).map(String::trim).map(refreshItem -> new ComboBoxRefreshListener(refreshScript, refreshItem.trim(), comboBox, execFunc)).forEach(comboBox::addItemListener);
    }

    private String[] parseNeedRefreshItems(String refreshItems) {
        return refreshItems.split(",");
    }

    private JSONObject getJsonObjById(String id) {
        JSONArray array = new JSONArray(this.jsonStr);
        for (int i = 0; i < array.length(); ++i) {
            JSONObject jsonObject = (JSONObject)array.get(i);
            if (!id.equals(jsonObject.getString(ID))) continue;
            return jsonObject;
        }
        return null;
    }

    private void refreshComp(String id) {
        String retData = (String)BizPackageContext.getInstance().getJythonContext().getDict().get("retData");
        Component input = this.layout.getId2Component().get(id);
        if (input == null) {
            log.warn("element {} can't find.", (Object)id);
            return;
        }
        if (retData.isEmpty()) {
            return;
        }
        JSONObject jsonObject = new JSONObject(retData);
        if (jsonObject.has("isShow")) {
            Component label = this.layout.getId2Component().get(id + "_label");
            Component toolTip = this.layout.getId2Component().get(id + "_toolTip");
            boolean isShow = "True".equals(jsonObject.getString("isShow"));
            label.setVisible(isShow);
            input.setVisible(isShow);
            toolTip.setVisible(isShow);
            return;
        }
        if (input instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)input;
            String ruleStr = jsonObject.getString("rule");
            String defaultStr = jsonObject.getString("default");
            jComboBox.removeAllItems();
            this.layout.addComBoxItems(jComboBox, ruleStr);
            jComboBox.setSelectedItem(defaultStr);
        }
    }

    private void exit() {
        this.ssEnv.getDict().put("succ", true);
        this.dispose();
    }

    private boolean check() {
        if (!((Boolean)this.ssEnv.getDict().get("succ")).booleanValue()) {
            DialogUtils.showErrorDialog((JDialog)this, (String)((String)this.ssEnv.getDict().get("errMsg")));
            return false;
        }
        return true;
    }

    private void setInputIdList(String inputJsonArray) {
        JSONArray arry = new JSONArray(inputJsonArray);
        for (int i = 0; i < arry.length(); ++i) {
            JSONObject jsonObject = (JSONObject)arry.get(i);
            String id = (String)jsonObject.get(ID);
            this.inputIdList.add(id);
        }
    }

    private String getScriptPath() {
        String packPath = BizPackageContext.getInstance().getCurBizPackage().getAbsolutPath();
        StringBuilder scriptPath = new StringBuilder();
        scriptPath.append(packPath);
        scriptPath.append(File.separator);
        scriptPath.append(PROCESS);
        return scriptPath.toString();
    }

    public void onStepDialogDisplayed() {
        String currentProcess = AutoProcessConfig.getInstance().getCurrentProcess();
        String inputJson = ((String)AutoProcessConfig.getInstance().getProcessInput().get(currentProcess)).trim();
        this.ssEnv.getDict().put("curData", inputJson);
        log.info("auto process input: {}", (Object)inputJson);
        this.notifyObserver(AutoProcessStatus.SUCCESS);
    }

    public void onStepFinished(AutoProcessStatus status) {
        SwingUtilities.invokeLater(new RefreshRunnable());
    }

    public void addObserver(AutoProcessObserver observer) {
        this.observers.add(observer);
    }

    public void notifyObserver(AutoProcessStatus status) {
        for (AutoProcessObserver observer : this.observers) {
            observer.processStatus(status);
        }
    }

    private class ComboBoxRefreshListener
    implements ItemListener {
        private ExecPyScriptTask task;
        private String tobeRefreshedCompId;
        private JComboBox comboBox;
        private String method = "";

        public ComboBoxRefreshListener(String refreshScrit, String tobeRefreshedCompId, JComboBox comboBox, String execFunc) {
            this(refreshScrit, tobeRefreshedCompId, comboBox);
            this.method = execFunc;
        }

        public ComboBoxRefreshListener(String refreshScrit, String tobeRefreshedCompId, JComboBox comboBox) {
            this.tobeRefreshedCompId = tobeRefreshedCompId;
            this.comboBox = comboBox;
            try {
                this.task = new ExecPyScriptTask(GetUserInPutDialog.this.getScriptPath(), refreshScrit);
            }
            catch (FileNotFoundException e) {
                log.error("init task by combox refresh, script file not found.");
            }
            catch (SignException e) {
                log.error("init task by combox refresh sign error.", (Throwable)e);
            }
            catch (Exception e) {
                log.error("init task by combox refresh error.", (Throwable)e);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            String selectData = (String)this.comboBox.getSelectedItem();
            BizPackageContext.getInstance().getJythonContext().getDict().put("curData", selectData);
            this.task.execFunc(this.method);
            GetUserInPutDialog.this.refreshComp(this.tobeRefreshedCompId);
        }
    }

    private class RefreshRunnable
    implements Runnable {
        private RefreshRunnable() {
        }

        @Override
        public void run() {
            BizPackageContext.getInstance().getJythonContext().clearMsgData();
            List fs = AsyncExcutor.execute((Window)GetUserInPutDialog.this, (Callable[])new Callable[]{new GetUserInputWaitDialog(GetUserInPutDialog.this.getScriptPath(), GetUserInPutDialog.this.checkScript, GetUserInPutDialog.this.checkMethod)});
            WaitDialogResult result = (WaitDialogResult)fs.get(0);
            if (!WaitDialogResult.handleResult(GetUserInPutDialog.this, result)) {
                return;
            }
            if (!result.isFlag()) {
                GetUserInPutDialog.this.ssEnv.getDict().put("curData", "");
                log.info("exec getUserInput script err,clear curData.");
            }
            if (GetUserInPutDialog.this.check()) {
                GetUserInPutDialog.this.exit();
            }
        }
    }
}

