/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.dialog;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.wizardparse.entity.PreCheckResult;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.PreCheckResultDialogLayout;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Map;
import javax.swing.JDialog;

public class PreCheckResultDialog
extends JDialog {
    private static final long serialVersionUID = -1806334935715805625L;
    private static final Dimension DIALOG_SIZE = new Dimension(500, 375);
    private PreCheckResultDialogLayout layout = new PreCheckResultDialogLayout();
    private transient Map<String, PreCheckResult> resultMap;
    private boolean preCheckResult = false;

    public PreCheckResultDialog(JDialog parent, Map<String, PreCheckResult> resultMap) {
        super(parent);
        this.setResizable(false);
        this.setModal(true);
        this.resultMap = resultMap;
        this.setTable();
        this.initListener();
        UiMethod.setComponentSize((Dimension)DIALOG_SIZE, (Component[])new Component[]{this});
        UiMethod.putScreenCenter((Window)this);
        this.setTitle(ResourceUtil.getString("bizpack.precheck.failedreason.title"));
        this.add(this.layout);
    }

    private void setTable() {
        DefaultTableModel defaultTableModel = this.layout.getTableModel();
        for (Map.Entry<String, PreCheckResult> result : this.resultMap.entrySet()) {
            defaultTableModel.addRow(new TableRow[]{this.createTableRow(result.getValue(), result.getKey())});
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
    }

    private TableRow<PreCheckResult, String> createTableRow(PreCheckResult result, String ip) {
        DefaultTableRow row = new DefaultTableRow(2, (Object)result, (Object)ip);
        row.setValueAt(0, (Object)ip);
        row.setValueAt(1, (Object)result.getFailedReason());
        return row;
    }

    private void initListener() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PreCheckResultDialog.this.preCheckResult = false;
                PreCheckResultDialog.this.dispose();
            }
        });
        this.layout.getCancelBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreCheckResultDialog.this.preCheckResult = false;
                PreCheckResultDialog.this.dispose();
            }
        });
        this.layout.getCloseBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreCheckResultDialog.this.preCheckResult = true;
                PreCheckResultDialog.this.dispose();
            }
        });
    }

    public boolean isPreCheckResult() {
        return this.preCheckResult;
    }
}

