/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.dialog;

import com.huawei.ism.autotest.AutoProcessConfig;
import com.huawei.ism.autotest.AutoProcessListener;
import com.huawei.ism.autotest.AutoProcessObserver;
import com.huawei.ism.autotest.AutoProcessResult;
import com.huawei.ism.autotest.AutoProcessStatus;
import com.huawei.ism.autotest.IAutoProcess;
import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.component.wizard.IHelpActionCallBack;
import com.huawei.ism.tool.base.ui.component.wizard.WizardRootPaneUI;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.OpenHelpCallBack;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.WizardItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.SelectWizardDialogLayout;
import com.huawei.ism.tool.bizpack.wizardparse.util.BizPackageSceneUtils;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JDialog;
import javax.swing.plaf.RootPaneUI;

public class SelectWizardDialog
extends JDialog
implements IAutoProcess {
    private static final long serialVersionUID = -3287976303954332169L;
    private static final Dimension WELCOME_DIALOG_SIZE = new Dimension(879, 651);
    private static final String PNG = ".png";
    private String help = "";
    private List<AutoProcessObserver> observers = new ArrayList<AutoProcessObserver>();
    private SelectWizardDialogLayout layout = null;

    public SelectWizardDialog(Window parent) {
        super(parent);
        this.initUi();
        BizPackageContext.getInstance().setSelectProcessDialog(this);
        this.help = OpenHelpCallBack.getHelpPath();
        if (!this.help.trim().equals("")) {
            WizardRootPaneUI rootPaneUI = new WizardRootPaneUI();
            this.getRootPane().setUI((RootPaneUI)rootPaneUI);
            rootPaneUI.setHelpActionCallBack((IHelpActionCallBack)new OpenHelpCallBack(this, this.help));
        }
        this.addComponentListener((ComponentListener)new AutoProcessListener((IAutoProcess)this));
        new AutoProcessObserver((IAutoProcess)this);
    }

    public void initUi() {
        PackagesResource util = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        this.layout = new SelectWizardDialogLayout();
        this.setLayout(new BorderLayout());
        this.add(this.layout);
        this.setModal(true);
        this.setResizable(false);
        this.setSize(WELCOME_DIALOG_SIZE);
        this.setPreferredSize(WELCOME_DIALOG_SIZE);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WarningDialog wdialog = DialogUtils.createWarningDialog((JDialog)SelectWizardDialog.this, (String)ResourceUtil.getString("bizpackage.desc.quite"));
                if (0 == wdialog.getValue()) {
                    String toolId = BizPackageContext.getInstance().getCurToolName();
                    BizPackageContext.getInstance().saveUserOpData();
                    BizPackageSceneUtils.finishedScene(toolId);
                    ApplicationContext.getInstance().fireToolStopped(toolId);
                }
            }
        });
        this.validate();
        String toolName = BizPackageContext.getInstance().getCurToolName();
        if (BizPackageContext.getInstance().isSelfDefine()) {
            String titleKey = BizPackageContext.getInstance().getMainDialogTitle();
            this.setIconImage(BizPackageContext.getInstance().getMultiModeRuningImg().getImage());
            String title = util.getString(titleKey);
            this.setTitle(title);
        } else {
            this.setIconImage(ResourceUtil.getImage(toolName + PNG).getImage());
            this.setTitle(ResourceUtil.getString(toolName + ".title"));
        }
        UiMethod.putScreenCenter((Window)this);
    }

    public void onStepDialogDisplayed() {
        AutoProcessResult.getInstance().overwrite("\u6269\u5bb9\u81ea\u52a8\u5316\u6d41\u7a0b");
        List processList = AutoProcessConfig.getInstance().getProcessList();
        for (String expansionProcess : processList) {
            AutoProcessConfig.getInstance().setCurrentProcess(expansionProcess);
            this.clickExpansionProcess(expansionProcess);
        }
        this.notifyObserver(AutoProcessStatus.SUCCESS);
    }

    private void clickExpansionProcess(String expansionProcess) {
        List<WizardItem> processList = this.layout.getWizardItems();
        for (WizardItem process : processList) {
            if (!expansionProcess.equalsIgnoreCase(process.toString())) continue;
            AutoProcessResult.getInstance().append(String.format(Locale.ROOT, "%s----process: %s", System.lineSeparator(), expansionProcess));
            process.doClick();
        }
    }

    public void onStepFinished(AutoProcessStatus status) {
        if (AutoProcessResult.getInstance().isAutoProcessSuccess()) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    public void addObserver(AutoProcessObserver observer) {
        this.observers.add(observer);
    }

    public void notifyObserver(AutoProcessStatus status) {
        for (AutoProcessObserver observer : this.observers) {
            observer.processStatus(status);
        }
    }
}

