/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.BizPackage;
import com.huawei.ism.tool.bizpack.PackProduct;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.context.JythonContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.PreCheckResult;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrecheckWaitDialog
implements Callable<Map<String, PreCheckResult>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrecheckWaitDialog.class);
    private static final String FUNC_NAME = "execute";
    private List<DevNode> selectDevs = new ArrayList<DevNode>();
    private JythonExecuter executer = null;
    private JythonContext ssEnv;
    private Map<String, PreCheckResult> preCheckIp2Result;

    public PrecheckWaitDialog(List<DevNode> selectDevs) {
        this.selectDevs = selectDevs;
        this.ssEnv = BizPackageContext.getInstance().getJythonContext();
        this.preCheckIp2Result = new HashMap<String, PreCheckResult>();
    }

    @Override
    public Map<String, PreCheckResult> call() {
        LOGGER.info("begin precheck.");
        this.executer = new JythonExecuter();
        this.preCheckIp2Result.clear();
        for (DevNode dev : this.selectDevs) {
            this.execOneDev(dev);
        }
        return this.preCheckIp2Result;
    }

    private void execOneDev(DevNode dev) {
        List<BizPackage> packages = BizPackageContext.getInstance().getBizPackages();
        for (BizPackage bizPackage : packages) {
            List<PackProduct> products = bizPackage.getPackProducts();
            for (PackProduct packProduct : products) {
                if (!BizPackageContext.getInstance().containDevNode(dev, packProduct)) continue;
                this.execPreCheck(dev, bizPackage, packProduct);
                return;
            }
        }
        LOGGER.error("dev[" + dev.getIp() + "] precheck has no product.");
    }

    private void execPreCheck(DevNode dev, BizPackage bizPackage, PackProduct packProduct) {
        String script = packProduct.getScript();
        String param = packProduct.getParam();
        if (StringUtils.isNULLStr(script)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("dev[" + dev.getIp() + "] precheck has no script.");
            }
            return;
        }
        String pacPath = bizPackage.getAbsolutPath();
        String processPath = pacPath + File.separator + "process";
        this.ssEnv.getDict().put("importRootDir", processPath);
        ArrayList<File> clsPath = new ArrayList<File>();
        clsPath.add(new File(processPath));
        this.executer.addClassPaths(clsPath);
        String scriptPath = processPath + File.separator + script;
        File scriptFile = new File(scriptPath);
        if (!scriptFile.exists()) {
            LOGGER.error("dev[" + dev.getIp() + "] precheck script not exist.");
            return;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("execute script : " + scriptFile);
        }
        this.ssEnv.getDict().put("logger", LOGGER);
        this.ssEnv.getDict().put("curData", dev.getIp());
        try {
            this.executer.compileScript(scriptFile);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("jython File {} not found", (Object)scriptFile.getName());
        }
        catch (SignException e) {
            LOGGER.error("python file has no sign", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("jython file compile failed", (Throwable)e);
        }
        this.ssEnv.clearMsgData();
        try {
            if (StringUtils.isNULLStr(param)) {
                this.executer.invokeFunction(FUNC_NAME, this.ssEnv.getDict());
            } else {
                this.executer.invokeFunction(FUNC_NAME, new Object[]{this.ssEnv.getDict(), param});
            }
        }
        catch (ToolException e) {
            LOGGER.error("jython exec err", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("jython exec err", (Throwable)e);
        }
        this.setResult(dev.getIp());
    }

    private void setResult(String ip) {
        PreCheckResult result = new PreCheckResult();
        if (!((Boolean)this.ssEnv.getDict().get("succ")).booleanValue()) {
            result.setSucc(false);
            String errText = (String)this.ssEnv.getDict().get("errMsg");
            result.setFailedReason(errText);
            this.preCheckIp2Result.put(ip, result);
        }
    }
}

