/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.doitem;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizWizardConfig;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.ItemsListCellRenderer;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.AbstractBizStepLayout;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.doitem.DoItemStepCfg;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.doitem.comp.ConfirmBord;
import com.huawei.ism.tool.bizpack.wizardparse.util.AutomateUtils;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoItemStepLayout
extends AbstractBizStepLayout {
    private static final Logger LOGGER = LoggerFactory.getLogger(DoItemStepLayout.class);
    private static final String MARK_SIGN_REG_EXP = "([\\w|\\s]*)([\ufe30-\uffa0\u2018\u2019\u201c\u201d,\\.;\\:\"'!])(.*)";
    private static final Dimension REMIND_MAX_SIZE = new Dimension(600, 80);
    private static final long serialVersionUID = -2453894081154927703L;
    private static final int BOTTOM_HEIGHT = 150;
    private static final int WARNING_HEIGHT = 34;
    private static final int EXTEND_WEIGHT = 44;
    private static final String ICON_TYPE = ".gif";
    private static final Font SUGGEST_FONT = new Font("", 1, 12);
    private static final int BORDER_SIZE = 20;
    private static final int JLABEL_HEIGHT = 550;
    private static final int WIZARD_BLANK_SIZE = 44;
    private static final int TIME_BLANK_SIZE = 150;
    private static final int DANGER_BLANK_SIZE = 45;
    private static final Color GREEN = new Color(4423169);
    private static final String LOADING_IMG = "loading.gif";
    private JList itemList = null;
    private JPanel confirmBordPanel = new JPanel();
    private JLabel currentStatusTxt = new JLabel();
    private JPanel currentStatusPanel = new JPanel();
    private JLabel currentProgress = new JLabel();
    private JLabel currentLeftTimeDes = new JLabel();
    private JLabel currentLeftTime = new JLabel();
    private JLabel remindText = new JLabel("", 2);
    private JLabel currentDesc = new JLabel();
    private JLabel currentResultTxt = new JLabel();
    private JLabel currentResultSuggustion = new JLabel();
    private JPanel resultPanel;
    private JPanel docLinkPanel = new JPanel();
    private JEditorPane resultlAndSuggestEditorPane = new JEditorPane();
    private JScrollPane resultAndSuggestPan;
    private JButton btnReDetect;
    private JButton ignoreBtn;
    private JButton handleItemNoPassBtn;
    private DefaultListModel listModel = new DefaultListModel();
    private Map<Integer, List<String>> errMsg = new HashMap<Integer, List<String>>();

    public Map<Integer, List<String>> getErrMsg() {
        return this.errMsg;
    }

    public DoItemStepLayout(DoItemStepCfg cfg) {
        BizPackageContext.getInstance().getId2LayoutMap().put(cfg.getId(), this);
        this.initUi(cfg);
        this.setCompName();
    }

    public JLabel getRemindText() {
        return this.remindText;
    }

    public void setRemindText(JLabel remindText) {
        this.remindText = remindText;
    }

    private void setCompName() {
        AutomateUtils.setNameAttribute(this.itemList, "itemList");
        AutomateUtils.setNameAttribute(this.confirmBordPanel, "confirmBordPanel");
        AutomateUtils.setNameAttribute(this.currentStatusTxt, "confirmBordPanel");
        AutomateUtils.setNameAttribute(this.currentStatusPanel, "currentStatusPanel");
        AutomateUtils.setNameAttribute(this.currentProgress, "currentProgress");
        AutomateUtils.setNameAttribute(this.currentLeftTime, "currentLeftTime");
        AutomateUtils.setNameAttribute(this.currentDesc, "currentDesc");
        AutomateUtils.setNameAttribute(this.currentResultTxt, "currentResultTxt_doItemStep");
        AutomateUtils.setNameAttribute(this.currentResultSuggustion, "currentResultSuggustion_doItemStep");
        AutomateUtils.setNameAttribute(this.resultPanel, "resultPanel");
        AutomateUtils.setNameAttribute(this.docLinkPanel, "docLinkPanel_doItemStep");
        AutomateUtils.setNameAttribute(this.btnReDetect, "btnReDetect_doItemStep");
        AutomateUtils.setNameAttribute(this.handleItemNoPassBtn, "handleItemNoPassBtn_doItemStep");
    }

    public void clearUI() {
        this.listModel.removeAllElements();
        this.btnReDetect.setEnabled(false);
        this.handleItemNoPassBtn.setEnabled(false);
        this.resultPanel.removeAll();
        this.resultPanel.setVisible(false);
    }

    private void initUi(DoItemStepCfg cfg) {
        this.setBizCfg(cfg);
        Dimension wizardSize = cfg.getWizardSize();
        JDialog wizardDialog = BizPackageContext.getInstance().getWizard();
        if (wizardSize == null) {
            BizWizardConfig bizWizardConfig = BizPackageContext.getInstance().getCurBizWizardCfg();
            wizardSize = bizWizardConfig.getWizardSize();
            wizardDialog.setMinimumSize(wizardSize);
            wizardDialog.setPreferredSize(wizardSize);
            wizardDialog.setSize(wizardSize);
        } else {
            wizardDialog.setMinimumSize(wizardSize);
            wizardDialog.setPreferredSize(wizardSize);
            wizardDialog.setSize(wizardSize);
        }
        JScrollPane itemPanel = this.buildScrollPane();
        itemPanel.setPreferredSize(new Dimension(wizardSize.width - 44, (int)((double)wizardSize.height * 0.7)));
        this.resultPanel = new JPanel();
        this.resultPanel.setPreferredSize(new Dimension(wizardSize.width - 44, (int)((double)wizardSize.height * 0.3)));
        Map<String, Object> allAttributesMap = cfg.getAllAtributeMap();
        boolean isDevGraphInMiddle = null != allAttributesMap && allAttributesMap.getOrDefault("graphLoc", "").equals("middle");
        JComponent view = !isDevGraphInMiddle ? this.buildNormalFruComponent(cfg, itemPanel) : this.buildTopAndBottomeView(cfg, itemPanel);
        this.setViewInLayout(cfg, view, false);
        this.btnReDetect = UiMethod.createButton((String)ResourceUtil.getString("expansion.btn.recheck"), (char)'R');
        this.handleItemNoPassBtn = UiMethod.createButton((String)ResourceUtil.getString("expansion.fru.btn.handle"), (char)'H');
    }

    private JComponent buildNormalFruComponent(DoItemStepCfg cfg, JScrollPane itemPanel) {
        String dangerTips = cfg.getDangerTips().getDesc();
        JComponent view = null;
        if (cfg.getGuideLinkGroup().getLinks().size() > 0) {
            cfg.getGuideLinkGroup().init();
            this.docLinkPanel = cfg.getGuideLinkGroup().getLinkPanel();
            if (!StringUtils.isNULLStr(dangerTips)) {
                JLabel dangerJLabel = new JLabel();
                this.setJLabelText(dangerJLabel, dangerTips, 45);
                dangerJLabel.setForeground(Color.red);
                view = UCD.buildVerticalBox(null, (Component[])new Component[]{this.docLinkPanel, UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{dangerJLabel}), this.currentStatusPanel, itemPanel, this.resultPanel, Box.createVerticalGlue()});
            } else {
                view = UCD.buildVerticalBox(null, (Component[])new Component[]{this.docLinkPanel, this.currentStatusPanel, itemPanel, this.resultPanel, Box.createVerticalGlue()});
            }
        } else if (!StringUtils.isNULLStr(dangerTips)) {
            JLabel dangerJLabel = new JLabel();
            this.setJLabelText(dangerJLabel, dangerTips, 45);
            dangerJLabel.setForeground(Color.red);
            cfg.getGuideLinkGroup().init();
            this.docLinkPanel = cfg.getGuideLinkGroup().getLinkPanel();
            view = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{dangerJLabel}), this.currentStatusPanel, itemPanel, this.resultPanel, Box.createVerticalGlue()});
        } else {
            view = UCD.buildVerticalBox(null, (Component[])new Component[]{this.currentStatusPanel, itemPanel, this.resultPanel, Box.createVerticalGlue()});
        }
        return view;
    }

    private JComponent buildTopAndBottomeView(DoItemStepCfg cfg, JScrollPane itemPanel) {
        String dangerTips = cfg.getDangerTips().getDesc();
        JComponent topView = null;
        JComponent bottomView = null;
        if (cfg.getGuideLinkGroup().getLinks().size() > 0) {
            cfg.getGuideLinkGroup().init();
            this.docLinkPanel = cfg.getGuideLinkGroup().getLinkPanel();
            if (!StringUtils.isNULLStr(dangerTips)) {
                JLabel dangerJLabel = new JLabel();
                this.setJLabelText(dangerJLabel, dangerTips, 45);
                dangerJLabel.setForeground(Color.red);
                topView = UCD.buildVerticalBox(null, (Component[])new Component[]{this.docLinkPanel, UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{dangerJLabel}), this.currentStatusPanel, Box.createVerticalGlue()});
                bottomView = UCD.buildVerticalBox(null, (Component[])new Component[]{itemPanel, this.resultPanel, Box.createVerticalGlue()});
            } else {
                topView = UCD.buildVerticalBox(null, (Component[])new Component[]{this.docLinkPanel, this.currentStatusPanel, Box.createVerticalGlue()});
                bottomView = UCD.buildVerticalBox(null, (Component[])new Component[]{itemPanel, this.resultPanel, Box.createVerticalGlue()});
            }
        } else if (!StringUtils.isNULLStr(dangerTips)) {
            JLabel dangerJLabel = new JLabel();
            this.setJLabelText(dangerJLabel, dangerTips, 45);
            dangerJLabel.setForeground(Color.red);
            cfg.getGuideLinkGroup().init();
            this.docLinkPanel = cfg.getGuideLinkGroup().getLinkPanel();
            topView = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{dangerJLabel}), this.currentStatusPanel, Box.createVerticalGlue()});
            bottomView = UCD.buildVerticalBox(null, (Component[])new Component[]{itemPanel, this.resultPanel, Box.createVerticalGlue()});
        } else {
            topView = UCD.buildVerticalBox(null, (Component[])new Component[]{this.currentStatusPanel, Box.createVerticalGlue()});
            bottomView = UCD.buildVerticalBox(null, (Component[])new Component[]{itemPanel, this.resultPanel, Box.createVerticalGlue()});
        }
        this.setTopPanel(topView);
        return bottomView;
    }

    public void buildConfirmBord(List<ConfirmBord> cons, DoItemStepCfg cfg) {
        Dimension wizardSize = this.getWizardStepDimension(cfg);
        JScrollPane itemPanel = this.buildScrollPane();
        itemPanel.setPreferredSize(new Dimension(wizardSize.width - 44, wizardSize.height - 150));
        String dangerTips = cfg.getDangerTips().getDesc();
        Map<String, Object> allAttributesMap = cfg.getAllAtributeMap();
        boolean isDevGraphMiddle = null != allAttributesMap && allAttributesMap.getOrDefault("graphLoc", "").equals("middle");
        JComponent view = null;
        view = !isDevGraphMiddle ? this.buildNormalConfirmBoard(cfg, itemPanel, dangerTips) : this.buildOtherConfirmBoard(cfg, itemPanel, dangerTips);
        this.setViewInLayout(cfg, view, false);
        this.confirmBordPanel.setLayout(new BoxLayout(this.confirmBordPanel, 1));
        for (ConfirmBord bord : cons) {
            bord.initCompUi(this.getBizCfg());
            this.confirmBordPanel.add(bord.getBordPanel());
        }
    }

    private JComponent buildNormalConfirmBoard(DoItemStepCfg cfg, JScrollPane itemPanel, String dangerTips) {
        JComponent view;
        if (cfg.getGuideLinkGroup().getLinks().size() > 0) {
            cfg.getGuideLinkGroup().init();
            this.docLinkPanel = cfg.getGuideLinkGroup().getLinkPanel();
            if (!StringUtils.isNULLStr(dangerTips)) {
                JLabel dangerJLabel = new JLabel();
                dangerJLabel.setForeground(Color.red);
                this.setJLabelText(dangerJLabel, dangerTips, 45);
                view = UCD.buildVerticalBox(null, (Component[])new Component[]{this.docLinkPanel, UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{dangerJLabel}), this.confirmBordPanel, this.currentStatusPanel, itemPanel, this.resultPanel, Box.createVerticalGlue()});
            } else {
                view = UCD.buildVerticalBox(null, (Component[])new Component[]{this.docLinkPanel, this.confirmBordPanel, this.currentStatusPanel, itemPanel, this.resultPanel, Box.createVerticalGlue()});
            }
        } else if (!StringUtils.isNULLStr(dangerTips)) {
            JLabel dangerJLabel = new JLabel();
            dangerJLabel.setForeground(Color.red);
            this.setJLabelText(dangerJLabel, dangerTips, 45);
            view = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{dangerJLabel}), this.confirmBordPanel, this.currentStatusPanel, itemPanel, this.resultPanel, Box.createVerticalGlue()});
        } else {
            view = UCD.buildVerticalBox(null, (Component[])new Component[]{this.confirmBordPanel, this.currentStatusPanel, itemPanel, this.resultPanel, Box.createVerticalGlue()});
        }
        return view;
    }

    private JComponent buildOtherConfirmBoard(DoItemStepCfg cfg, JScrollPane itemPanel, String dangerTips) {
        JComponent bottomView;
        JComponent topView;
        if (cfg.getGuideLinkGroup().getLinks().size() > 0) {
            cfg.getGuideLinkGroup().init();
            this.docLinkPanel = cfg.getGuideLinkGroup().getLinkPanel();
            if (!StringUtils.isNULLStr(dangerTips)) {
                JLabel dangerJLabel = new JLabel();
                dangerJLabel.setForeground(Color.blue);
                this.setJLabelText(dangerJLabel, dangerTips, 45);
                topView = UCD.buildVerticalBox(null, (Component[])new Component[]{this.docLinkPanel, UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{dangerJLabel}), this.confirmBordPanel, Box.createVerticalGlue()});
                bottomView = UCD.buildVerticalBox(null, (Component[])new Component[]{this.currentStatusPanel, itemPanel, this.resultPanel, Box.createVerticalGlue()});
            } else {
                topView = UCD.buildVerticalBox(null, (Component[])new Component[]{this.docLinkPanel, this.confirmBordPanel, Box.createVerticalGlue()});
                bottomView = UCD.buildVerticalBox(null, (Component[])new Component[]{this.currentStatusPanel, itemPanel, this.resultPanel, Box.createVerticalGlue()});
            }
        } else if (!StringUtils.isNULLStr(dangerTips)) {
            JLabel dangerJLabel = new JLabel();
            dangerJLabel.setForeground(Color.red);
            this.setJLabelText(dangerJLabel, dangerTips, 45);
            topView = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{dangerJLabel}), this.confirmBordPanel, Box.createVerticalGlue()});
            bottomView = UCD.buildVerticalBox(null, (Component[])new Component[]{this.currentStatusPanel, itemPanel, this.resultPanel, Box.createVerticalGlue()});
        } else {
            topView = UCD.buildVerticalBox(null, (Component[])new Component[]{this.confirmBordPanel, Box.createVerticalGlue()});
            bottomView = UCD.buildVerticalBox(null, (Component[])new Component[]{this.currentStatusPanel, itemPanel, this.resultPanel, Box.createVerticalGlue()});
        }
        this.setTopPanel(topView);
        return bottomView;
    }

    public void showResultInfo(List<String> msgs) {
        this.showResultInfo(msgs, false);
    }

    public void showResultInfo(List<String> msgs, boolean ignoreFlag) {
        boolean isDevGraphMiddle;
        Dimension wizardSize = this.getWizardStepDimension(this.getBizCfg());
        int maxWidth = wizardSize.width - 44;
        int maxHeight = wizardSize.height - 550;
        Map<String, Object> allAttributesMap = this.getBizCfg().getAllAtributeMap();
        boolean bl = isDevGraphMiddle = null != allAttributesMap && allAttributesMap.getOrDefault("graphLoc", "").equals("middle");
        if (this.getBizCfg().isNeedDeviceGraph() && !isDevGraphMiddle) {
            maxWidth = maxWidth - this.getBizCfg().getDevGraphSize().width - 28;
        }
        this.resultlAndSuggestEditorPane.setFont(SUGGEST_FONT);
        this.resultlAndSuggestEditorPane.setContentType("text/html;charset=\"UTF-8\"");
        this.resultlAndSuggestEditorPane.setEditable(false);
        String htmlString = this.getHtmlForResult(msgs);
        this.resultlAndSuggestEditorPane.setText(htmlString);
        this.buildResultAndSuggestPan(ignoreFlag);
        UiMethod.setComponentSize((Dimension)new Dimension(maxWidth, 160), (Component[])new Component[]{this.resultAndSuggestPan});
        this.resultPanel.setSize(maxWidth, maxHeight);
        this.resultPanel.setLayout(new GridBagLayout());
        GridBagConstraints con = new GridBagConstraints();
        con.fill = 0;
        con.anchor = 18;
        con.weightx = 0.0;
        con.weighty = 0.0;
        con.gridx = 0;
        con.gridy = 0;
        con.insets = new Insets(0, 0, 0, 0);
        this.resultPanel.add((Component)this.resultAndSuggestPan, con);
        this.resultPanel.setVisible(true);
    }

    private void buildResultAndSuggestPan(boolean ignoreFlag) {
        if (ignoreFlag) {
            this.ignoreBtn = UiMethod.createButton((String)ResourceUtil.getString("expansion.wizard.doitem.ignore"), (char)'I');
            UiMethod.setComponentSize((Dimension)new Dimension(80, 30), (Component[])new Component[]{this.ignoreBtn});
            JComponent component = UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHorizontalBoxLeft((Component)this.resultlAndSuggestEditorPane), UCD.buildHorizontalBoxLeft((Component)this.ignoreBtn)});
            this.resultAndSuggestPan = new JScrollPane(component);
        } else {
            this.resultAndSuggestPan = new JScrollPane(this.resultlAndSuggestEditorPane);
        }
    }

    private String getHtmlForResult(List<String> msgs) {
        if (msgs.size() < 2) {
            LOGGER.error("get error message failed!");
            return "";
        }
        StringBuilder html = new StringBuilder();
        html.append("<html>");
        html.append("<body>");
        html.append("<div style=\"width:100%;height:auto;word-break:break-all;word-wrap:break-word;font-size:12\">");
        html.append("<b style=\"font-family:bold;margin:0 auto\">");
        html.append(ResourceUtil.getStringWithParams("expansion.wizard.doitem.errMsg", new Object[0]));
        html.append("</b>");
        html.append("<p style=\"font-family:plain;margin:0 auto\">");
        html.append(msgs.get(1));
        html.append("</p>");
        if (msgs.size() >= 3 && msgs.get(2).length() > 0) {
            html.append("<br/>");
            html.append("<b style=\"font-family:bold;margin:0 auto\">");
            html.append(ResourceUtil.getStringWithParams("expansion.wizard.doitem.suggestion", new Object[0]));
            html.append("</b>");
            html.append("<p style=\"font-family:plain;margin:0 auto\">");
            html.append(msgs.get(2));
            html.append("</p>");
        }
        html.append("</div>");
        html.append("</body>");
        html.append("</html>");
        return html.toString().replace("\n", "<br/>");
    }

    private Dimension getWizardStepDimension(DoItemStepCfg bizCfg) {
        Dimension wizardSize = bizCfg.getWizardSize();
        if (wizardSize == null) {
            wizardSize = BizPackageContext.getInstance().getCurBizWizardCfg().getWizardSize();
        }
        return wizardSize;
    }

    public void clearResultInfo() {
        this.resultPanel.removeAll();
        this.resultPanel.setVisible(false);
    }

    private JScrollPane buildScrollPane() {
        JScrollPane scrollPane = new JScrollPane();
        this.itemList = new JList(this.listModel);
        this.itemList.addListSelectionListener(new CheckItemListListener());
        this.itemList.setCellRenderer(new ItemsListCellRenderer());
        this.itemList.setSelectionMode(0);
        scrollPane.add(this.itemList);
        scrollPane.getViewport().setView(this.itemList);
        return scrollPane;
    }

    public void setStatusPanel(boolean showPro, boolean showLeftTime) {
        this.currentProgress.setFont(new Font(this.getName(), 150, 20));
        this.currentProgress.setForeground(GREEN);
        this.currentLeftTime.setFont(new Font(this.getName(), 150, 22));
        this.currentLeftTime.setForeground(GREEN);
        boolean isShowRemindInfo = this.getBizCfg() == null ? false : this.getBizCfg().isShowRemindInfo();
        this.remindText.setMaximumSize(REMIND_MAX_SIZE);
        JLabel bottom = isShowRemindInfo ? UCD.buildVerticalBox(null, (int)0, (Component[])new Component[]{this.remindText, this.currentDesc}) : this.currentDesc;
        JComponent view = UCD.buildHorizotalBox(null, (Component[])new Component[]{UiMethod.buildVerticalOppositionalPan((Component)UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.currentStatusTxt, this.currentProgress}), (Component)bottom), UiMethod.buildVerticalOppositionalPan((Component)this.currentLeftTimeDes, (Component)this.currentLeftTime, (String)"Center")});
        this.setStatusPanelEnable(showPro, showLeftTime);
        this.currentStatusPanel.setLayout(new BorderLayout());
        this.currentStatusPanel.add(view);
    }

    @Override
    protected DoItemStepCfg getBizCfg() {
        if (super.getBizCfg() instanceof DoItemStepCfg) {
            return (DoItemStepCfg)super.getBizCfg();
        }
        return null;
    }

    public void setStatusPanelEnable(boolean showPro, boolean showLeftTime) {
        if (!showPro) {
            this.currentProgress.setEnabled(false);
            this.currentProgress.setVisible(false);
        } else {
            this.currentProgress.setEnabled(true);
            this.currentProgress.setVisible(true);
        }
        if (!showLeftTime) {
            this.currentLeftTime.setEnabled(false);
            this.currentLeftTime.setVisible(false);
            this.currentLeftTimeDes.setEnabled(false);
            this.currentLeftTimeDes.setVisible(false);
        } else {
            this.currentLeftTime.setEnabled(true);
            this.currentLeftTime.setVisible(true);
            this.currentLeftTimeDes.setEnabled(true);
            this.currentLeftTimeDes.setVisible(true);
        }
    }

    public void setCurrentStatusTxt(String cStatusTxt) {
        this.currentStatusTxt.setText(cStatusTxt);
    }

    public void setCurrentStatusIcon(ImageIcon icon) {
        this.currentStatusTxt.setIcon(icon);
    }

    public JButton getBtnReDetect() {
        return this.btnReDetect;
    }

    public JButton getIgnoreBtn() {
        return this.ignoreBtn;
    }

    public JButton getHandleItemNoPassBtn() {
        return this.handleItemNoPassBtn;
    }

    public DefaultListModel getListModel() {
        return this.listModel;
    }

    public void setListModel(DefaultListModel listModel) {
        this.listModel = listModel;
    }

    public JLabel getCurrentProgress() {
        return this.currentProgress;
    }

    public void setCurrentProgress(String currentProgress) {
        this.currentProgress.setText(currentProgress);
    }

    public JLabel getCurrentLeftTime() {
        return this.currentLeftTime;
    }

    public void setCurrentLeftTime(String currentLeftTime) {
        this.currentLeftTime.setText(currentLeftTime);
    }

    public JLabel getCurrentLeftTimeDes() {
        return this.currentLeftTimeDes;
    }

    public void setCurrentLeftTimeDes(String currentLeftTimeDes) {
        this.currentLeftTimeDes.setText(currentLeftTimeDes);
    }

    public JLabel getCurrentDesc() {
        return this.currentDesc;
    }

    public void setCurrentDesc(String desc, boolean showLeftTime) {
        int blankWidth = 44;
        if (showLeftTime) {
            blankWidth += 150;
        }
        this.setJLabelText(this.currentDesc, desc, blankWidth);
        this.currentDesc.setForeground(Color.GRAY);
    }

    public JList getItemList() {
        return this.itemList;
    }

    public void setItemList(JList itemList) {
        this.itemList = itemList;
    }

    private void setLabelText(JLabel label, String text) {
        label.setText(text);
        label.setForeground(Color.black);
    }

    public JLabel createJLabelWithWrapWidth(int width, int hight, JLabel label) {
        if (width <= 0 || label == null) {
            return label;
        }
        String text = label.getText();
        if (!text.startsWith("<html>")) {
            StringBuilder strBuilder = new StringBuilder("<html><body style=\"word-wrap:break-word;word-break:break-all;\" width='" + (width - 20) + "px' hight='" + (hight - 20) + "px'>");
            strBuilder.append(text);
            strBuilder.append("</body></html>");
            text = strBuilder.toString();
        }
        label.setText(text);
        return label;
    }

    class CheckItemListListener
    implements ListSelectionListener {
        CheckItemListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            boolean onceCheckAll;
            int curIndex = ((JList)event.getSource()).getLeadSelectionIndex();
            List msgs = DoItemStepLayout.this.errMsg.getOrDefault(curIndex, new ArrayList());
            BizStepConfig stepConfig = BizPackageContext.getInstance().getCurBizWizardCfg().getStepsById(BizPackageContext.getInstance().getCurStepId());
            boolean bl = onceCheckAll = stepConfig != null && stepConfig.isOnceCheckAll();
            if (!onceCheckAll || !event.getValueIsAdjusting()) {
                return;
            }
            if (msgs == null || msgs.isEmpty()) {
                DoItemStepLayout.this.clearResultInfo();
            } else {
                DoItemStepLayout.this.clearResultInfo();
                DoItemStepLayout.this.showResultInfo(msgs);
            }
        }
    }
}

