/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.finish;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.info.InfoBoard;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.AbstractBizStepLayout;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.finish.FinishReplaceStepCfg;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.finish.comp.Prompt;
import com.huawei.ism.tool.bizpack.wizardparse.util.AutomateUtils;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FinishReplaceStepLayout
extends AbstractBizStepLayout {
    private static final long serialVersionUID = 2380068211728303308L;
    private static final ImageIcon SUCC_IMG = ResourceUtil.getImage("success_big.png");
    private GridBagConstraints c = new GridBagConstraints();
    private JLabel successTitle = new JLabel();
    private JPanel mainPanel = new JPanel();
    private JPanel tablePanel = new JPanel();
    private JPanel docLinkPanel = new JPanel();
    private PackagesResource util;

    public FinishReplaceStepLayout(FinishReplaceStepCfg cfg) {
        BizPackageContext.getInstance().getId2LayoutMap().put(cfg.getId(), this);
        this.initUi(cfg);
        this.setCompName();
    }

    private void setCompName() {
        AutomateUtils.setNameAttribute(this.successTitle, "successTitle");
        AutomateUtils.setNameAttribute(this.mainPanel, "mainPanel");
        AutomateUtils.setNameAttribute(this.tablePanel, "tablePanel");
        AutomateUtils.setNameAttribute(this.docLinkPanel, "docLinkPanel_finishReplaceStep");
    }

    private void initUi(FinishReplaceStepCfg cfg) {
        this.setBizCfg(cfg);
        JComponent view = null;
        if (cfg.getGuideLinkGroup().getLinks().size() > 0) {
            cfg.getGuideLinkGroup().init();
            this.docLinkPanel = cfg.getGuideLinkGroup().getLinkPanel();
            view = UCD.buildVerticalBox(null, (Component[])new Component[]{this.docLinkPanel, UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.successTitle}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.mainPanel}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.tablePanel}), Box.createVerticalGlue(), Box.createVerticalStrut(50)});
        } else {
            view = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.successTitle}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.mainPanel}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.tablePanel}), Box.createVerticalGlue(), Box.createVerticalStrut(50)});
        }
        this.tablePanel.setLayout(new BorderLayout());
        this.setViewInLayout(cfg, view, true);
    }

    public void init(FinishReplaceStepCfg cfg) {
        this.util = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        this.mainPanel.removeAll();
        this.tablePanel.removeAll();
        this.successTitle.setIcon(SUCC_IMG);
        this.successTitle.setText(this.util.getString(cfg.getSucDesc()));
        this.mainPanel.setLayout(new GridBagLayout());
        this.c.anchor = 17;
        this.c.fill = 0;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.insets = new Insets(0, 0, 12, 0);
        List<Object> infos = cfg.getInfoList();
        for (Object object : infos) {
            if (object instanceof Prompt) {
                Prompt prompt = (Prompt)object;
                this.mainPanel.add((Component)this.createPromptPanel(prompt), this.c);
                this.c.weightx = 1.0;
                this.mainPanel.add((Component)new JLabel(), this.c);
                this.c.weightx = 0.0;
                ++this.c.gridy;
                continue;
            }
            if (object instanceof InfoBoard) {
                InfoBoard infoBoard = (InfoBoard)object;
                this.mainPanel.add((Component)this.createInfoBordPanel(infoBoard), this.c);
                this.c.weightx = 1.0;
                this.mainPanel.add((Component)new JLabel(), this.c);
                this.c.weightx = 0.0;
                ++this.c.gridy;
                continue;
            }
            if (!(object instanceof TableItem)) continue;
            TableItem tableItem = (TableItem)object;
            this.tablePanel.add(this.createTableBordPanel(tableItem));
        }
        this.c.weighty = 1.0;
        this.mainPanel.add((Component)new JLabel(), this.c);
    }

    private JPanel createPromptPanel(Prompt prompt) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(prompt.getPrompt());
        panel.add(Box.createHorizontalGlue());
        prompt.setPromptTxt(prompt.getName(), this.getBizCfg());
        return panel;
    }

    private JPanel createInfoBordPanel(InfoBoard infoBoard) {
        JPanel panel = infoBoard.getRefreshBord();
        infoBoard.setSize(this.getBizCfg());
        panel.setBorder(BorderFactory.createTitledBorder(this.util.getString(infoBoard.getName())));
        return panel;
    }

    private JPanel createTableBordPanel(TableItem tableItem) {
        JPanel panel = new JPanel();
        TableScrollPane tableScrollPane = new TableScrollPane(tableItem.getComponent(), true, true, false);
        panel.setLayout(new BorderLayout());
        panel.add((Component)tableScrollPane);
        return panel;
    }
}

