/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.checkengine;

import com.huawei.security.checkengine.bean.CheckInputDetail;
import com.huawei.security.checkengine.bean.CheckResult;
import com.huawei.security.checkengine.engine.BadInputCheckAttack;
import com.huawei.security.checkengine.engine.EngineFactory;
import com.huawei.security.checkengine.engine.FileContentCheckAttack;
import com.huawei.security.checkengine.exception.CheckEngineException;
import com.huawei.security.checkengine.exception.RuleLoadingException;
import com.huawei.security.checkengine.util.CheckTypeEnum;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuleEngineManager {
    private static final Logger LOG = LoggerFactory.getLogger(RuleEngineManager.class);

    private RuleEngineManager() {
    }

    public static CheckResult fileContentCheck(InputStream inputStream, CheckTypeEnum[] checkType, boolean closeInputStream) throws RuleLoadingException {
        return RuleEngineManager.fileContentCheck(inputStream, checkType, closeInputStream, null);
    }

    public static CheckResult fileContentCheck(InputStream inputStream, CheckTypeEnum[] checkType, boolean closeInputStream, Properties overrideProps) throws RuleLoadingException {
        CheckResult checkResult = new CheckResult();
        try {
            FileContentCheckAttack fileContentCheckAttack = EngineFactory.getInstance().getFileContentCheckInstance();
            fileContentCheckAttack.check(inputStream, checkType, closeInputStream, overrideProps);
        }
        catch (CheckEngineException e) {
            checkResult.setValidateResule(false);
            checkResult.setErrorMessage(e.getMessage());
        }
        return checkResult;
    }

    public static CheckResult maliciousDataCheck(CheckInputDetail inputData, CheckTypeEnum[] checkType) throws RuleLoadingException {
        CheckResult checkResult = new CheckResult();
        try {
            BadInputCheckAttack badInputCheckAttack = EngineFactory.getInstance().getBadInputCheckInstance();
            badInputCheckAttack.check(inputData, checkType, null, null);
        }
        catch (CheckEngineException e) {
            checkResult.setValidateResule(false);
            checkResult.setErrorMessage(e.getMessage());
        }
        return checkResult;
    }

    static {
        try {
            LOG.info("[WSF-CheckEngine] Begin init checkengine.");
            EngineFactory.getInstance();
            LOG.info("[WSF-CheckEngine] End init checkengine.");
        }
        catch (RuleLoadingException e) {
            LOG.error("[WSF-CheckEngine] Load rule file fail, please check file path.");
        }
    }
}

