/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.checkengine.filecontent;

import com.huawei.security.checkengine.bean.BadRequestDefinition;
import com.huawei.security.checkengine.exception.MultipartCheckException;
import com.huawei.security.checkengine.exception.NotCheckContentException;
import com.huawei.security.checkengine.filecontent.FileContentCheckInterface;
import com.huawei.security.checkengine.util.FileContentCheckUtil;
import com.huawei.security.checkengine.util.ZipCheckParameter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipContentCheck
implements FileContentCheckInterface {
    private static final Logger LOG = LoggerFactory.getLogger(ZipContentCheck.class);
    private static final String START_PATH = FileContentCheckUtil.getStartPath();

    @Override
    public void checkFileContent(InputStream fileContent, BadRequestDefinition checkRule, boolean closeInputStream, Properties overrideProps) throws MultipartCheckException, NotCheckContentException {
        if (checkRule == null) {
            throw new NotCheckContentException("Check rules is null.");
        }
        ZipCheckParameter checkParameter = new ZipCheckParameter(overrideProps, checkRule);
        String path = FileContentCheckUtil.saveAsFile(fileContent);
        try (ZipFile zipFile = new ZipFile(path);){
            int fileNum = 0;
            boolean isZipped = false;
            long uncompressedSize = 0L;
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                isZipped = true;
                ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)entries.nextElement();
                boolean isDir = zipArchiveEntry.isDirectory();
                String fileName = zipArchiveEntry.getName().replace("?", "_");
                FileContentCheckUtil.checkFileName(fileName, isDir, START_PATH, true, checkParameter);
                if (isDir) continue;
                this.checkFileNum(++fileNum, checkParameter.getMaxFileNum());
                long uncompressedMaxSize = checkParameter.getMaxSize();
                long realEntrySize = ZipContentCheck.getZipEntrySize(zipFile, zipArchiveEntry, uncompressedMaxSize);
                this.checkUncompressedSize(uncompressedSize += realEntrySize, uncompressedMaxSize, realEntrySize, zipArchiveEntry.getSize());
            }
            if (!isZipped) {
                LOG.error("[WSF-CheckEngine] The input stream type is not zip.");
                throw new NotCheckContentException("Reading zip file content failed.");
            }
        }
        catch (IOException e) {
            LOG.error("[WSF-CheckEngine] Failed to read the zip file for checking");
            throw new NotCheckContentException("Reading zip file content failed.", e);
        }
        finally {
            if (closeInputStream) {
                try {
                    fileContent.close();
                }
                catch (IOException e) {
                    LOG.error("[WSF-CheckEngine] Failed to close the input stream.");
                }
            }
            FileContentCheckUtil.deleteFile(path);
        }
    }

    private static long getZipEntrySize(ZipFile zipFile, ZipArchiveEntry entry, long uncompressedMaxSize) throws MultipartCheckException {
        long size = 0L;
        try (BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));){
            int length;
            byte[] buf = new byte[512];
            while ((length = bis.read(buf)) != -1) {
                if ((size += (long)length) <= uncompressedMaxSize) continue;
                LOG.error("[WSF-CheckEngine] Single File being unzipped is too big, the max size is: " + size);
                throw new MultipartCheckException("Checking zip file size failed.");
            }
        }
        catch (IOException e) {
            LOG.error("Read zip entry error IOException.");
        }
        return size;
    }

    private void checkUncompressedSize(long size, long maxSize, long realSize, long markSize) throws MultipartCheckException {
        if (size >= maxSize) {
            LOG.error("[WSF-CheckEngine] File being unzipped is too big, the max size is: " + maxSize);
            throw new MultipartCheckException("Checking zip file size failed.");
        }
        if (markSize != -1L && realSize != markSize || markSize < -1L) {
            LOG.error("[WSF-CheckEngine] File size is tampered.");
            throw new MultipartCheckException("Checking zip file size failed.");
        }
    }

    private void checkFileNum(int fileNum, int maxFileNum) throws MultipartCheckException {
        if (fileNum > maxFileNum) {
            LOG.error("[WSF-CheckEngine] Too many files to unzip, the max file number is {}", (Object)maxFileNum);
            throw new MultipartCheckException("Checking zip file numbers failed.");
        }
    }
}

