/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.checkengine.rulefile;

import com.huawei.security.checkengine.exception.RuleLoadingException;
import com.huawei.security.checkengine.rulefile.AbstractBasedFileRuleFileLoader;
import com.huawei.security.checkengine.rulefile.RuleFile;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClasspathZipRuleFileLoader
extends AbstractBasedFileRuleFileLoader {
    private static final String DEFAULT = "com/huawei/security/checkengine/rules.zip";
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathZipRuleFileLoader.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RuleFile[] loadRuleFiles() throws RuleLoadingException {
        ClassLoader classLoader;
        if (this.path == null) {
            this.path = DEFAULT;
        }
        if ((classLoader = this.getClass().getClassLoader()) == null) {
            LOG.error("[WSF-CheckEngine] Unable to load zipped rule file, because can't get classloader.");
            throw new RuleLoadingException("Loading check engine failed.");
        }
        InputStream input = classLoader.getResourceAsStream(this.path);
        if (input == null) {
            LOG.error("[WSF-CheckEngine] Unable to load zipped rule file on classpath.");
            throw new RuleLoadingException("Loading check engine failed.");
        }
        try (ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(input));){
            ZipEntry entry;
            ArrayList<RuleFile> ruleList = new ArrayList<RuleFile>();
            while ((entry = zipInputStream.getNextEntry()) != null) {
                boolean conditions;
                boolean loadException;
                String entryName = entry.getName();
                boolean bl = loadException = entry.isDirectory() || entryName == null || !this.isMatchingSuffix(entryName);
                if (loadException) {
                    zipInputStream.closeEntry();
                    continue;
                }
                boolean bl2 = conditions = entryName.startsWith("/") && entryName.length() > 1;
                if (conditions) {
                    entryName = entryName.substring(1);
                }
                Properties prop = new Properties();
                prop.load(zipInputStream);
                ruleList.add(new RuleFile(entryName, prop));
                zipInputStream.closeEntry();
            }
            RuleFile[] ruleFileArray = ruleList.toArray(new RuleFile[0]);
            return ruleFileArray;
        }
        catch (FileNotFoundException ex) {
            LOG.error("[WSF-CheckEngine] Loading rule files failed, class zip file have not found.");
            throw new RuleLoadingException("Loading check engine failed.");
        }
        catch (IOException ex) {
            throw new RuleLoadingException(ex);
        }
    }
}

