/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.checkengine.rulefile;

import com.huawei.security.checkengine.exception.RuleLoadingException;
import com.huawei.security.checkengine.rulefile.AbstractBasedFileRuleFileLoader;
import com.huawei.security.checkengine.rulefile.RuleFile;
import com.huawei.security.checkengine.util.FileContentCheckUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FilesystemRuleFileLoader
extends AbstractBasedFileRuleFileLoader {
    public static final String PARAM_RULE_FILES_BASE_PATH = "RuleFilesBasePath";
    private static final Logger LOG = LoggerFactory.getLogger(FilesystemRuleFileLoader.class);

    @Override
    public RuleFile[] loadRuleFiles() throws RuleLoadingException {
        if (this.path == null) {
            throw new RuleLoadingException("Path must be set before loading rules files");
        }
        try {
            File directory = FileContentCheckUtil.getFile(this.path);
            if (!directory.exists()) {
                throw new IllegalArgumentException("Directory does not exist: " + directory.getCanonicalPath());
            }
            if (!directory.isDirectory()) {
                throw new IllegalArgumentException("Directory exists but is not a directory (maybe just a file?): " + directory.getCanonicalPath());
            }
            ArrayList<RuleFile> rules = new ArrayList<RuleFile>();
            File[] files = directory.listFiles();
            if (files == null) {
                throw new RuleLoadingException("Can't load rule files (maybe just a file?): " + directory.getCanonicalPath());
            }
            if (!files[0].isDirectory()) {
                this.addRuleFile(files, rules);
            }
            for (File file : files) {
                File[] supFiles = file.listFiles();
                if (supFiles == null) {
                    throw new RuleLoadingException("Directory is not exist, can't load rule files.");
                }
                this.addRuleFile(supFiles, rules);
            }
            return rules.toArray(new RuleFile[0]);
        }
        catch (RuleLoadingException | IOException | IllegalArgumentException e) {
            LOG.error("[WSF-CheckEngine] Failed to load rule files.");
            throw new RuleLoadingException("Loading check engine failed.");
        }
    }

    private void addRuleFile(File[] files, List<RuleFile> rules) throws IOException {
        for (File file : files) {
            if (!file.isFile() || !this.isMatchingSuffix(file.getName())) continue;
            if (!file.canRead()) {
                LOG.warn("[WSF-CheckEngine] Unable to read rule definition file: {}.", (Object)file.getName());
                continue;
            }
            Properties properties = new Properties();
            try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));){
                properties.load(input);
                rules.add(new RuleFile(file.getCanonicalPath(), properties));
            }
        }
    }
}

