/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.checkengine.util;

import com.huawei.security.checkengine.exception.MultipartCheckException;
import com.huawei.security.checkengine.util.EmptyUtils;
import com.huawei.security.checkengine.util.LogUtils;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyUtils.class);

    private PropertyUtils() {
    }

    public static int getInt(String name, Properties overrideProps, int defaultValue) {
        String op = PropertyUtils.getOverridePropsStr(name, overrideProps);
        if (EmptyUtils.isEmpty(op)) {
            LOG.debug("[WSF-CheckEngine] Override properties for {} is null, use the default value: {}.", (Object)name, (Object)defaultValue);
            return defaultValue;
        }
        try {
            return Integer.parseInt(op);
        }
        catch (NumberFormatException e) {
            LOG.debug("[WSF-CheckEngine] Override properties for {} is incorrect, use the default value: {}.", (Object)name, (Object)defaultValue);
            return defaultValue;
        }
    }

    public static long getLong(String name, Properties overrideProps, long defaultValue) {
        String op = PropertyUtils.getOverridePropsStr(name, overrideProps);
        if (EmptyUtils.isEmpty(op)) {
            LOG.debug("[WSF-CheckEngine] Override properties for {} is null, use the default value: {}.", (Object)name, (Object)defaultValue);
            return defaultValue;
        }
        try {
            return Long.parseLong(op);
        }
        catch (NumberFormatException e) {
            LOG.debug("[WSF-CheckEngine] Override properties for {} is incorrect, use the default value: {}.", (Object)name, (Object)defaultValue);
            return defaultValue;
        }
    }

    public static Pattern getPattern(String name, Properties overrideProps, Pattern defaultValue) throws MultipartCheckException {
        String op = PropertyUtils.getOverridePropsStr(name, overrideProps);
        if (op != null) {
            try {
                return Pattern.compile(op);
            }
            catch (PatternSyntaxException e) {
                LOG.error("[WSF-CheckEngine] Override properties for {} is incorrect, not a valid pattern value: {}.", (Object)name, (Object)LogUtils.cleanLog(op));
                throw new MultipartCheckException("Failed to parse check rules.", e);
            }
        }
        LOG.debug("[WSF-CheckEngine] Override properties for {} is null, use the default value: {}.", (Object)name, (Object)defaultValue);
        return defaultValue;
    }

    private static String getOverridePropsStr(String name, Properties overrideProps) {
        Object props;
        String op = null;
        if (overrideProps != null && (props = overrideProps.get(name)) instanceof String) {
            op = (String)props;
        }
        return op;
    }
}

