/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.checkengine.util;

import com.huawei.security.checkengine.bean.AhoMappingWordsAutomaton;
import com.huawei.security.checkengine.bean.TreeNode;
import com.huawei.security.checkengine.bean.TrieTree;
import com.huawei.security.checkengine.bean.WordDictionaryClass;
import com.huawei.security.checkengine.util.EmptyUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;

public final class WordMatchingTools {
    private WordMatchingTools() {
    }

    public static String[] deduplicate(String[] patternArray) {
        if (EmptyUtils.isEmpty(patternArray)) {
            return patternArray;
        }
        HashSet<String> searchWords = new HashSet<String>(Arrays.asList(patternArray));
        return searchWords.toArray(new String[0]);
    }

    public static int determineMinimumLength(String[] wordArray) {
        if (EmptyUtils.isEmpty(wordArray)) {
            return 0;
        }
        int minLength = Integer.MAX_VALUE;
        for (String word : wordArray) {
            minLength = Math.min(minLength, word.length());
        }
        return minLength;
    }

    public static boolean matchesWord(WordDictionaryClass wordDictionary, String text, int trieMatchingThreshold) {
        int minLength;
        if (wordDictionary == null) {
            return true;
        }
        int n = minLength = wordDictionary.getMinLength() > 0 ? wordDictionary.getMinLength() : 1;
        if (wordDictionary.size() == 0 || text == null || text.length() < minLength) {
            return false;
        }
        String[] words = wordDictionary.getWords();
        String lowerCaseText = text.toLowerCase(Locale.ENGLISH);
        if (trieMatchingThreshold >= 0 && words.length >= trieMatchingThreshold) {
            return WordMatchingTools.matchesWordByTrieTree(wordDictionary, lowerCaseText);
        }
        return WordMatchingTools.matchesWordByBruteForce(words, lowerCaseText);
    }

    private static boolean matchesWordByBruteForce(String[] words, String lowerCaseText) {
        for (String word : words) {
            if (!lowerCaseText.contains(word)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesWordByTrieTree(WordDictionaryClass wordDictionary, String lowerCaseText) {
        TrieTree trie = wordDictionary.getTrie();
        AhoMappingWordsAutomaton mappingWordsAutoMat = new AhoMappingWordsAutomaton(trie);
        TreeNode currentState = trie.getRootNode();
        ArrayList<TreeNode> visitedStates = new ArrayList<TreeNode>();
        int textLength = lowerCaseText.length();
        for (int j = 0; j < textLength; ++j) {
            while (mappingWordsAutoMat.transition(currentState, lowerCaseText.charAt(j)) == AhoMappingWordsAutomaton.EMPTY_SET_NODE) {
                currentState = mappingWordsAutoMat.fail(currentState);
            }
            if (visitedStates.contains(currentState = mappingWordsAutoMat.transition(currentState, lowerCaseText.charAt(j)))) continue;
            if (mappingWordsAutoMat.isMatching(currentState)) {
                return true;
            }
            visitedStates.add(currentState);
        }
        return false;
    }

    public static String[] split(String commaOrWhitespaceSeparateWords) {
        String[] result = new String[]{};
        if (commaOrWhitespaceSeparateWords != null) {
            result = commaOrWhitespaceSeparateWords.trim().split("\\s+|,");
        }
        return result;
    }

    public static String[] trimLowerCaseAndDeduplicate(String[] patternArray) {
        if (EmptyUtils.isEmpty(patternArray)) {
            return patternArray;
        }
        HashSet<String> searchWords = new HashSet<String>(patternArray.length);
        for (String pattern : patternArray) {
            searchWords.add(pattern.trim().toLowerCase(Locale.ENGLISH));
        }
        return searchWords.toArray(new String[0]);
    }
}

