/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uMate.common.rest.https;

import com.huawei.ism.tool.certbase.ssl.MySslX509TrustManager;
import com.huawei.uMate.common.log.Logger;
import com.huawei.uMate.common.rest.SimpleTrustManager;
import com.huawei.uMate.common.rest.https.TrustCertificateService;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class CertService {
    private static final Logger LOGGER = new Logger(CertService.class);

    public Optional<SSLSocketFactory> getSSLFactory() throws NoSuchAlgorithmException, KeyStoreException {
        LOGGER.info("start to getServerSSLFactory...");
        TrustManager[] serverTrustManager = this.getServerTrustManager();
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, serverTrustManager, SecureRandom.getInstanceStrong());
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("getServerSSLFactory error.", e);
        }
        catch (KeyManagementException e) {
            LOGGER.error("getServerSSLFactory error.", e);
        }
        if (sslContext == null) {
            return Optional.empty();
        }
        LOGGER.info("finished to getServerSSLFactory.");
        return Optional.ofNullable(sslContext.getSocketFactory());
    }

    public SSLContext getSSLContext(String protocol, boolean isVerifyCert) {
        LOGGER.info("start to getServerSSLFactory...");
        SSLContext sslContext = null;
        try {
            TrustManager[] serverTrustManager = null;
            if (!isVerifyCert) {
                LOGGER.info("no need to verify certs.");
                SimpleTrustManager simpleTrustManager = new SimpleTrustManager();
                serverTrustManager = new TrustManager[]{simpleTrustManager};
            } else {
                serverTrustManager = this.getServerTrustManager();
                if (serverTrustManager.length == 0) {
                    LOGGER.info("no certs found.");
                }
            }
            sslContext = SSLContext.getInstance(protocol);
            sslContext.init(null, serverTrustManager, SecureRandom.getInstanceStrong());
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            LOGGER.error("getSSLContext error.", e);
        }
        LOGGER.info("finished to getSSLContext.");
        return sslContext;
    }

    public boolean updateCert(String certPath) {
        return TrustCertificateService.getInstance().updateCert(certPath);
    }

    private TrustManager[] getServerTrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        TrustManager[] trustmanagers;
        KeyStore trustStore = TrustCertificateService.getInstance().getTrustKeyStore();
        if (null == trustStore) {
            trustmanagers = new TrustManager[]{new SimpleTrustManager()};
        } else {
            TrustManagerFactory factory = TrustManagerFactory.getInstance("SunX509");
            factory.init(trustStore);
            trustmanagers = CertService.getWrappedTrustManagers(factory.getTrustManagers());
        }
        return trustmanagers;
    }

    private static TrustManager[] getWrappedTrustManagers(TrustManager[] tms) {
        int len = tms.length;
        TrustManager[] x509TrustManagerWrapper = new MySslX509TrustManager[len];
        for (int i = 0; i < len; ++i) {
            if (!(tms[i] instanceof X509TrustManager)) continue;
            x509TrustManagerWrapper[i] = new MySslX509TrustManager((X509TrustManager)tms[i]);
        }
        return x509TrustManagerWrapper;
    }
}

