/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uMate.common.ssh;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.uMate.HWDiscover.model.HWDiscoverModel;
import com.huawei.uMate.common.log.Logger;
import com.huawei.uMate.common.ssh.Shell;
import com.huawei.uMate.common.thread.CommonRunnable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sshd.common.session.SessionHeartbeatController;

public class SSHBase {
    public static final int DEFAULT_TRY_COUNT = 120;
    public static final String NETWORK_INTERRPUT = "Network disconnected, please try again later.";
    private static final Logger LOGGER = new Logger(SSHBase.class);
    public static final int THREE_MINUTES = 180000;
    private String cmdRet = "";
    private boolean hasError = false;
    private int timeCount = 120;
    private HWDiscoverModel snmpModel;
    private boolean isRetry = true;

    public SSHBase(HWDiscoverModel snmpModel) {
        this.snmpModel = snmpModel;
    }

    public SSHBase() {
    }

    public String execShellCommand(Shell shell, String[] cmd, int timeOut) throws Exception {
        String[] commands = cmd;
        boolean isSuccess = shell.executeCommands(commands, timeOut);
        if (!isSuccess) {
            this.hasError = !isSuccess;
        }
        String response = shell.getResponse();
        return response;
    }

    public String execShellCommand(Shell shell, String[] cmd) throws Exception {
        String[] commands = cmd;
        shell.executeCommands(commands);
        String response = shell.getResponse();
        return response;
    }

    public String execShellCommand(Shell shell, String cmd) throws Exception {
        String[] commands = new String[]{cmd};
        shell.executeCommands(commands);
        String response = shell.getResponse();
        return response;
    }

    public String execShellCommand(Shell shell, String cmd, String[] endKeyWhitelist) throws Exception {
        String[] commands = new String[]{cmd};
        shell.executeCommands(commands, endKeyWhitelist);
        String response = shell.getResponse();
        return response;
    }

    public boolean execShellCmd(Shell shell, String cmd, String successMsg, String failedMsg) throws Exception {
        return this.execShellCmd(shell, new String[]{cmd}, successMsg, failedMsg);
    }

    public boolean execShellCmd(Shell shell, String[] cmd, String successMsg, String failedMsg) throws Exception {
        int cmdTryCount;
        String tmpExecResult;
        this.hasError = false;
        int exitCount = 0;
        this.cmdRet = tmpExecResult = this.execShellCommand(shell, cmd, this.timeCount * 1000);
        for (cmdTryCount = 0; cmdTryCount < this.timeCount && this.isRetry; ++cmdTryCount) {
            if (!this.checkStatus(shell)) {
                LOGGER.error(String.format(Locale.ROOT, "%s %s failed.", this.snmpModel.getIPAddress(), this.snmpModel.getMsg()));
                this.hasError = true;
                return false;
            }
            if ("".equals(tmpExecResult)) {
                CommonRunnable.sleep(1000);
                tmpExecResult = this.execShellCommand(shell, "\r\n");
                this.cmdRet = this.cmdRet + tmpExecResult;
                continue;
            }
            if (tmpExecResult.contains(successMsg) || tmpExecResult.matches(successMsg)) break;
            if (!"".equals(failedMsg) && (tmpExecResult.contains(failedMsg) || tmpExecResult.matches(failedMsg))) {
                return false;
            }
            CommonRunnable.sleep(1000);
            tmpExecResult = this.execShellCommand(shell, "\r\n");
            this.cmdRet = this.cmdRet + tmpExecResult;
            if (tmpExecResult.contains("#") || tmpExecResult.contains("->") || tmpExecResult.contains("~]")) {
                if (++exitCount <= 3) continue;
                return false;
            }
            exitCount = 0;
        }
        return cmdTryCount < this.timeCount;
    }

    public int getLuxUnUsePort(Shell shell) throws Exception {
        if (shell == null) {
            return -1;
        }
        int max = 65535;
        int min = 20000;
        SecureRandom random = new SecureRandom();
        int port = random.nextInt(max) % (max - min + 1) + min;
        LOGGER.info("===getLuxUnUsePort====port==========" + port);
        String[] commands = new String[]{"netstat -an | grep " + port};
        if (shell.executeCommands(commands)) {
            Thread.sleep(10000L);
            String execResult = shell.getResponse();
            LOGGER.info("=======execResult==========" + System.lineSeparator() + execResult);
            String execResultWithoutCmd = execResult.substring(execResult.indexOf(commands[0]) + commands[0].length());
            LOGGER.info("=======execResult==========" + System.lineSeparator() + execResultWithoutCmd);
            if (execResultWithoutCmd.contains(port + "")) {
                LOGGER.info("the port has been occupied!");
                port = this.getLuxUnUsePort(shell);
            }
            LOGGER.info("get the linux available port successfully!");
            return port;
        }
        return -1;
    }

    public String getSSHProxyIP(Shell shell, String host) {
        try {
            String ipRegex;
            if (shell == null) {
                return null;
            }
            List<String> ipList = new ArrayList<String>();
            String versionResult = this.execShellCommand(shell, "cat /etc/*-release");
            if (versionResult.contains("SUSE")) {
                LOGGER.info("the system is SUSE.................");
                String ifconfigResult = this.execShellCommand(shell, "ifconfig");
                ipRegex = "addr:(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)";
                Pattern p = Pattern.compile(ipRegex);
                Matcher m = p.matcher(ifconfigResult);
                boolean i = false;
                while (m.find()) {
                    String result = m.group();
                    if (org.apache.commons.codec.binary.StringUtils.equals("addr:127.0.0.1", result)) continue;
                    ipList.add(result.substring(5));
                }
            } else {
                LOGGER.info("the system is not SUSE.................");
                String[] ipArray = null;
                ipRegex = "((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)";
                String execResult = this.execShellCommand(shell, "hostname -I");
                LOGGER.info("=======execResult==========" + execResult);
                if (StringUtils.isNULLStr((String)execResult)) {
                    return null;
                }
                String[] resultLines = execResult.split("\\n");
                for (String line : resultLines) {
                    Pattern p = Pattern.compile(ipRegex);
                    Matcher m = p.matcher(line);
                    if (!m.find()) continue;
                    LOGGER.info("search proxy ip successfully!");
                    ipArray = line.split(" ");
                    break;
                }
                if (ipArray != null) {
                    ipList = Arrays.asList(ipArray);
                } else {
                    return null;
                }
            }
            for (int i = 0; i < ipList.size(); ++i) {
                String ip = (String)ipList.get(i);
                LOGGER.info("=======ip==========" + ip);
                String[] commands = null;
                commands = host.contains(":") ? new String[]{"ping6 -I " + ip + " " + host + " -c 2"} : new String[]{"ping -I " + ip + " " + host + " -c 2"};
                if (!shell.executeCommands(commands)) continue;
                Thread.sleep(15000L);
                String pingResult = shell.getResponse();
                LOGGER.info("=======pingResult==========" + pingResult);
                if (!pingResult.contains("64 bytes")) continue;
                LOGGER.info("=======SusseccIP==========" + ip);
                return ip;
            }
            return null;
        }
        catch (Exception ex) {
            LOGGER.error(ex);
            return null;
        }
    }

    public static boolean isLux(Shell shell) throws Exception {
        if (shell == null) {
            return false;
        }
        String[] commands = new String[]{"uname"};
        if (shell.executeCommands(commands)) {
            Thread.sleep(5000L);
            String execResult = shell.getResponse();
            LOGGER.info("=======execResult==========" + execResult);
            if (execResult.toLowerCase(Locale.US).trim().contains("linux")) {
                return true;
            }
        }
        return false;
    }

    public boolean checkStatus(Shell shell) {
        if (shell.getChannel() != null && !shell.isConnected()) {
            this.snmpModel.setMsg(NETWORK_INTERRPUT);
            return false;
        }
        if (shell.getSftpChannel() != null && shell.getSession().getSessionHeartbeatInterval() == null) {
            shell.getSession().setSessionHeartbeat(SessionHeartbeatController.HeartbeatType.RESERVED, TimeUnit.MILLISECONDS, 180000L);
            return true;
        }
        if (this.snmpModel.isInterrupt()) {
            this.snmpModel.setInterrupt(false);
            return false;
        }
        return true;
    }

    public void setTimeCount(int timeCount) {
        this.timeCount = timeCount;
    }

    public void setIsRetry(boolean isRetry) {
        this.isRetry = isRetry;
    }
}

