/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uMate.common.utils;

import com.huawei.uMate.common.log.Logger;
import com.huawei.uMate.common.utils.ResUtil;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class IPConfigUtils {
    private static final Logger LOGGER = new Logger(IPConfigUtils.class);
    private static final ResUtil RES = ResUtil.getInstance("common");

    public static String mac2ipv6(String macAddr) {
        String macAddr1 = macAddr.replace(":", "-");
        String[] macAddrArray = macAddr1.split("-");
        int first = Integer.valueOf(macAddrArray[0], 16);
        String ipString = String.format(Locale.ENGLISH, "%02x", first ^= 2);
        String parsedIPV6 = "fe80::" + ipString + macAddrArray[1] + ":" + macAddrArray[2] + "ff:fe" + macAddrArray[3] + ":" + macAddrArray[4] + macAddrArray[5];
        LOGGER.info(String.format(Locale.ENGLISH, "mac:%s,IPV6:%s", macAddr, parsedIPV6));
        return parsedIPV6;
    }

    public static LinkedHashMap<String, String> getSN2IP() {
        LinkedHashMap<String, String> sn2ip = new LinkedHashMap<String, String>();
        HashSet<InetAddress> localAddrs = new HashSet<InetAddress>();
        try {
            Enumeration<NetworkInterface> interfs = NetworkInterface.getNetworkInterfaces();
            if (interfs == null) {
                LOGGER.error("interface is null!");
                return sn2ip;
            }
            while (interfs.hasMoreElements()) {
                NetworkInterface interf = interfs.nextElement();
                Enumeration<InetAddress> addrs = interf.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    String addrString = addr.getHostAddress();
                    if (!(addr instanceof Inet6Address) || !addrString.startsWith("fe80")) continue;
                    localAddrs.add(addr);
                }
            }
            for (InetAddress addr : localAddrs) {
                LinkedHashMap<String, String> ip2snOneAddr = IPConfigUtils.getOneAddrSN2IP(addr);
                for (Map.Entry<String, String> entry : ip2snOneAddr.entrySet()) {
                    sn2ip.put(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (IOException ex) {
            LOGGER.error(ex);
        }
        LOGGER.info(String.format(Locale.ENGLISH, "all addr\n recived:%s", sn2ip));
        return sn2ip;
    }

    public static LinkedHashMap<String, String> getOneAddrSN2IP(InetAddress addr) {
        ArrayList<String> responses = IPConfigUtils.search(addr);
        LinkedHashMap<String, String> sn2ip = new LinkedHashMap<String, String>();
        for (String response : responses) {
            String[] headers;
            String ip = "";
            String sn = "";
            for (String line : headers = response.split("\n")) {
                String[] strSplit;
                if (line.startsWith("SERVER") && line.contains("SN/")) {
                    strSplit = line.split("\\s+");
                    sn = strSplit[strSplit.length - 1].replaceAll("SN/", "");
                }
                if (!line.startsWith("AL") || !line.contains("redfish")) continue;
                strSplit = line.split("/");
                ip = strSplit[2];
            }
            if (sn.equals("")) continue;
            sn2ip.put(sn, ip);
        }
        LOGGER.info(String.format(Locale.ENGLISH, "%s addr\n recived:%s", addr, sn2ip));
        return sn2ip;
    }

    public static ArrayList<String> search(InetAddress addr) {
        int mx = 10;
        String st = "ssdp:all";
        String request = IPConfigUtils.makeRequest(mx, st);
        LOGGER.info(String.format(Locale.ENGLISH, "request info:%s", request));
        ArrayList<String> responses = new ArrayList<String>();
        DatagramSocket socket = null;
        try {
            String response;
            socket = IPConfigUtils.sendData(addr, request);
            while ((response = IPConfigUtils.recieveData(socket, 5000)) != null) {
                responses.add(response);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (socket != null) {
            socket.close();
        }
        return responses;
    }

    public static String makeRequest(int mx, String st) {
        String lineBreak = "\r\n";
        String request = "M-SEARCH * HTTP/1.1" + lineBreak + "HOST: [FF05::C]:1900" + lineBreak + "MAN: \"ssdp:discover\"" + lineBreak + String.format(Locale.ROOT, "MX: %s", mx) + lineBreak + String.format("ST: %s", st) + lineBreak;
        return request;
    }

    public static DatagramSocket sendData(InetAddress addr, String request) throws IOException {
        byte[] requestByte = request.getBytes(Charset.defaultCharset());
        int length = request.length();
        InetAddress inetaddress = InetAddress.getByName("FF05::C");
        DatagramPacket sendPacket = new DatagramPacket(requestByte, length, inetaddress, 1900);
        DatagramSocket socket = new DatagramSocket(64941, addr);
        socket.send(sendPacket);
        return socket;
    }

    public static String recieveData(DatagramSocket socket, int timeout) throws IOException {
        if (socket == null) {
            return null;
        }
        DatagramPacket receivePacket = new DatagramPacket(new byte[1024], 1024);
        socket.setSoTimeout(timeout);
        socket.receive(receivePacket);
        return new String(receivePacket.getData(), Charset.defaultCharset());
    }

    public static boolean checkIPv6() {
        try {
            Enumeration<NetworkInterface> interfs = NetworkInterface.getNetworkInterfaces();
            if (interfs == null) {
                LOGGER.error("interface is null!");
                return false;
            }
            while (interfs.hasMoreElements()) {
                NetworkInterface interf = interfs.nextElement();
                Enumeration<InetAddress> addrs = interf.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    String addrString = addr.getHostAddress();
                    if (!(addr instanceof Inet6Address) || !addrString.startsWith("fe80")) continue;
                    return true;
                }
            }
        }
        catch (SocketException ex) {
            LOGGER.error(ex);
        }
        return false;
    }

    public static boolean checkMac(String macAddress) {
        if ("".equals(macAddress)) {
            return true;
        }
        String regex = "^[A-Fa-f0-9]{2}([-:][A-Fa-f0-9]{2}){5}$";
        return macAddress.matches(regex);
    }
}

