/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.exttool.ui;

import com.huawei.ism.tool.base.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.exttool.entity.Datum;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.ILogSupportService;
import com.huawei.ism.tool.framework.pubservice.common.IUserActionCollService;
import com.huawei.ism.tool.framework.pubservice.entity.OperaLog;
import com.huawei.ism.tool.framework.pubservice.entity.UserReturnLog;
import com.huawei.ism.tool.obase.utils.OSCmdUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.IsmTableScrollPane;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.slf4j.Logger;

public class DatumDialog
extends JDialog {
    private static final long serialVersionUID = 5482096098139687692L;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DatumDialog.class);
    private static final Font TITLE_FONT_ZH = new Font("\u5b8b\u4f53", 1, 13);
    private static final Font TITLE_FONT_EN = new Font("Arail", 1, 13);
    private static final int COL_LEN_ZH_0 = 200;
    private static final int COL_LEN_ZH_1 = 400;
    private static final int COL_LEN_ZH_2 = 100;
    private static final int COL_LEN_EN_0 = 250;
    private static final int COL_LEN_EN_1 = 350;
    private static final int COL_LEN_EN_2 = 100;
    private static final Dimension SIZE = new Dimension(800, 400);
    private String name;
    private Map<Locale, String> nameMap;
    private KeyOrderedHashMap<String, Datum> datumMap;
    private Locale loc = LanguageManager.getInstance().getCurrentLanguage();
    private JPanel mainPanel = null;
    private JButton exitButton = UiMethod.createButton(ResourceUtil.getString("datum.dialog.exit"), 'C');
    private IsmTableScrollPane table;
    private String[] columnNames;
    private DefaultTableModel tableModel = null;

    public DatumDialog(Window parent, Map<Locale, String> nameMap, KeyOrderedHashMap<String, Datum> datumMap) {
        super(parent);
        this.datumMap = datumMap;
        this.nameMap = nameMap;
        this.name = Locale.CHINESE.getLanguage().equals(this.loc.getLanguage()) ? nameMap.get(Locale.CHINESE) : nameMap.get(Locale.ENGLISH);
        this.initData();
        this.initComp();
        this.initListen();
        this.setVisible(true);
    }

    private void initListen() {
        this.exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatumDialog.this.dispose();
                DatumDialog.this.addOperaLog(true, "");
            }
        });
    }

    private void addOperaLog(boolean succ, String detailInfo) {
        OperaLog log = new OperaLog();
        log.setUserName(ApplicationContext.getInstance().getCurToolkitUser());
        log.setResult(succ);
        log.setDeviceNameEn(this.nameMap.get(Locale.ENGLISH));
        log.setDeviceName(this.nameMap.get(Locale.CHINESE));
        log.setOperateType("operalog.type.system");
        log.setOperaName("operalog.name.tool.close");
        log.setDetailInfo(detailInfo);
        ILogSupportService logService = (ILogSupportService)PublicServiceManage.getInstance().getService(ILogSupportService.class);
        if (null != logService) {
            logService.addOperaLog(log);
        }
    }

    private void initData() {
        this.initTable();
        DefaultTableRow row = null;
        List setList = this.datumMap.keyList();
        for (String str : setList) {
            Datum datum = (Datum)this.datumMap.get((Object)str);
            row = new DefaultTableRow(this.tableModel.getAllColumnCount(), (Object)datum, (Object)datum.getName(this.loc));
            int j = 0;
            row.setValueAt(j++, (Object)datum.getName(this.loc));
            row.setValueAt(j++, (Object)datum.getDesc(this.loc));
            IsmTableCell.HyperlinkCell hyperLinkOpen = new IsmTableCell.HyperlinkCell(ResourceUtil.getString("datum.dialog.start"), (ActionListener)new StartListener(datum));
            row.setValueAt(j++, (Object)hyperLinkOpen);
            this.tableModel.addRow(new TableRow[]{row});
        }
    }

    private void initTable() {
        this.columnNames = new String[]{ResourceUtil.getString("datum.dialog.name"), ResourceUtil.getString("datum.dialog.desc"), ResourceUtil.getString("datum.dialog.opera")};
        this.tableModel = new DefaultTableModel(this.columnNames, new int[0]);
        IsmTable tempTable = new IsmTable((TableModel)this.tableModel);
        TableColumnModel colModule = tempTable.getColumnModel();
        if (this.loc == Locale.CHINA || this.loc == Locale.CHINESE) {
            colModule.getColumn(0).setPreferredWidth(200);
            colModule.getColumn(1).setPreferredWidth(400);
            colModule.getColumn(2).setPreferredWidth(100);
        } else {
            colModule.getColumn(0).setPreferredWidth(250);
            colModule.getColumn(1).setPreferredWidth(350);
            colModule.getColumn(2).setPreferredWidth(100);
        }
        this.table = new IsmTableScrollPane(tempTable, false);
    }

    private void initComp() {
        this.setResizable(false);
        this.setTitle(this.name);
        this.toFront();
        this.setModal(true);
        this.setLayout(new BorderLayout());
        UiMethod.setComponentSize(SIZE, this);
        this.add(this.getDetailPanel(), "Center");
        SwingUtil.putScreenCenter((Window)this);
    }

    private Component getDetailPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.mainPanel.add(Box.createVerticalStrut(15));
        this.mainPanel.add(this.buildDatumDesc());
        JComponent comp = UCD.buildHorizotalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(2), this.mainPanel, Box.createHorizontalStrut(2)});
        return UCD.buildVerticalBox(null, (Component[])new Component[]{comp, Box.createVerticalStrut(5)});
    }

    private Component buildDatumDesc() {
        JLabel datumName = UiMethod.createLabel(ResourceUtil.getString("datum.title.desc"));
        UiMethod.setFont(datumName, TITLE_FONT_EN, TITLE_FONT_ZH);
        return UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHorizotalBox(null, (Component[])new Component[]{datumName, Box.createHorizontalGlue()}), this.table, Box.createVerticalStrut(12), UCD.buildHBoxRight((Component[])new Component[]{this.exitButton})});
    }

    @Override
    protected void processWindowEvent(WindowEvent event) {
        if (event.getID() == 201) {
            this.dispose();
            this.addOperaLog(true, "");
            return;
        }
        super.processWindowEvent(event);
    }

    private void toolLogToFile(String operateId, String msg) {
        IUserActionCollService service = (IUserActionCollService)PublicServiceManage.getInstance().getService(IUserActionCollService.class);
        if (null != service) {
            UserReturnLog log = new UserReturnLog();
            log.setOpenDate(new Date());
            log.setCurrentDate(new Date());
            log.setCloseDate(new Date());
            log.setToolId(this.nameMap.get(Locale.ENGLISH));
            log.setOperateId(operateId);
            log.setOperateObjectId("tool");
            log.setStatus("true");
            log.setErrorMsg(msg);
            service.beginWriteToFile("toolStore", log);
        }
    }

    private class StartListener
    implements ActionListener {
        private Datum datum;

        public StartListener(Datum identifier) {
            this.datum = identifier;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LOGGER.info("start tool {}", (Object)DatumDialog.this.name);
            DatumDialog.this.toolLogToFile("toolOpen", "");
            OSCmdUtils.openHtmlUrl(this.datum.getLink(DatumDialog.this.loc));
            LOGGER.info("tool is {}", (Object)this.datum.getName(DatumDialog.this.loc));
            LOGGER.info("url is {}", (Object)this.datum.getLink(DatumDialog.this.loc));
        }
    }
}

