/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.reader;

import com.mxgraph.canvas.mxICanvas;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class mxGraphViewReader
extends DefaultHandler {
    protected mxICanvas canvas;
    protected double scale = 1.0;
    protected boolean htmlLabels = false;

    public void setHtmlLabels(boolean value) {
        this.htmlLabels = value;
    }

    public boolean isHtmlLabels() {
        return this.htmlLabels;
    }

    public abstract mxICanvas createCanvas(Map<String, Object> var1);

    public mxICanvas getCanvas() {
        return this.canvas;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String tagName = qName.toUpperCase();
        Hashtable<String, Object> attrs = new Hashtable<String, Object>();
        for (int i = 0; i < atts.getLength(); ++i) {
            String name = atts.getQName(i);
            if (name == null || name.length() == 0) {
                name = atts.getLocalName(i);
            }
            attrs.put(name, atts.getValue(i));
        }
        this.parseElement(tagName, attrs);
    }

    public void parseElement(String tagName, Map<String, Object> attrs) {
        if (this.canvas == null && tagName.equalsIgnoreCase("graph")) {
            this.scale = mxUtils.getDouble(attrs, "scale", 1.0);
            this.canvas = this.createCanvas(attrs);
            if (this.canvas != null) {
                this.canvas.setScale(this.scale);
            }
        } else if (this.canvas != null) {
            boolean edge = tagName.equalsIgnoreCase("edge");
            boolean group = tagName.equalsIgnoreCase("group");
            boolean vertex = tagName.equalsIgnoreCase("vertex");
            if (edge && attrs.containsKey("points") || (vertex || group) && attrs.containsKey("x") && attrs.containsKey("y") && attrs.containsKey("width") && attrs.containsKey("height")) {
                mxCellState state = new mxCellState(null, null, attrs);
                String label = this.parseState(state, edge);
                this.canvas.drawCell(state);
                this.canvas.drawLabel(label, state, this.isHtmlLabels());
            }
        }
    }

    public String parseState(mxCellState state, boolean edge) {
        String label;
        Map<String, Object> style = state.getStyle();
        state.setX(mxUtils.getDouble(style, "x"));
        state.setY(mxUtils.getDouble(style, "y"));
        state.setWidth(mxUtils.getDouble(style, "width"));
        state.setHeight(mxUtils.getDouble(style, "height"));
        List<mxPoint> pts = mxGraphViewReader.parsePoints(mxUtils.getString(style, "points"));
        if (pts.size() > 0) {
            state.setAbsolutePoints(pts);
        }
        if ((label = mxUtils.getString(style, "label")) != null && label.length() > 0) {
            mxPoint offset = new mxPoint(mxUtils.getDouble(style, "dx"), mxUtils.getDouble(style, "dy"));
            mxCellState vertexBounds = !edge ? state : null;
            state.setLabelBounds(mxUtils.getLabelPaintBounds(label, state.getStyle(), mxUtils.isTrue(style, "html", false), offset, vertexBounds, this.scale));
        }
        return label;
    }

    public static List<mxPoint> parsePoints(String pts) {
        ArrayList<mxPoint> result = new ArrayList<mxPoint>();
        if (pts != null) {
            int len = pts.length();
            String tmp = "";
            String x = null;
            for (int i = 0; i < len; ++i) {
                char c = pts.charAt(i);
                if (c == ',' || c == ' ') {
                    if (x == null) {
                        x = tmp;
                    } else {
                        result.add(new mxPoint(Double.parseDouble(x), Double.parseDouble(tmp)));
                        x = null;
                    }
                    tmp = "";
                    continue;
                }
                tmp = tmp + c;
            }
            result.add(new mxPoint(Double.parseDouble(x), Double.parseDouble(tmp)));
        }
        return result;
    }
}

