/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.common.server;

import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.service.common.ITask;
import com.huawei.ism.tool.service.common.entity.TaskStep;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorService
extends Observable {
    private static final Logger log = LoggerFactory.getLogger(ExecutorService.class);
    private final String resultDir;
    private final Observer obs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskResult runTasksParallel(DevNode node, List<ITask<TaskResult>> tasks) throws ToolException {
        try {
            this.init();
            this.execTasks(this.initTasks(tasks));
        }
        catch (ToolException e) {
            log.error("Exec task error.", (Throwable)e);
            TaskResult taskResult = TaskResult.fail((String)e.getErrorLocaleDescription());
            return taskResult;
        }
        catch (Throwable e) {
            log.error("Exec task error.", e);
            TaskResult taskResult = TaskResult.fail((String)ResourceUtil.getString("exec.error"));
            return taskResult;
        }
        finally {
            RestConnectionManager.releaseConn((DevNode)node);
        }
        return TaskResult.success((Object)"");
    }

    @NonNull
    private List<ITask<TaskResult>> initTasks(List<ITask<TaskResult>> tasks) throws ToolException {
        this.update((Object)TaskStep.INIT);
        ArrayList<ITask<TaskResult>> taskCanExec = new ArrayList<ITask<TaskResult>>(tasks.size());
        for (ITask<TaskResult> task : tasks) {
            TaskResult result = task.prepare();
            if (!result.isTaskSuccess()) {
                log.error("{} exec failed.", (Object)task.getTaskThreadName());
                if (tasks.size() == 1) {
                    throw new ToolException(result.getErrorLocaleDescription(), false);
                }
                task.notifyTaskObs(result);
                continue;
            }
            taskCanExec.add(task);
        }
        return taskCanExec;
    }

    private void execTasks(List<ITask<TaskResult>> taskCanExec) {
        if (taskCanExec.isEmpty()) {
            log.warn("Task can exec is empty.");
            return;
        }
        this.update((Object)TaskStep.EXECUTE_ITEM);
        CompletableFuture.allOf((CompletableFuture[])taskCanExec.stream().map(task -> CompletableFuture.supplyAsync(() -> this.executeTask((ITask<TaskResult>)task))).toArray(CompletableFuture[]::new)).join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskResult executeTask(ITask<TaskResult> task) {
        try {
            Thread.currentThread().setName(task.getTaskThreadName());
            TaskResult taskResult = task.doTask();
            return taskResult;
        }
        catch (ToolException e) {
            log.error("Exec task error.", (Throwable)e);
            TaskResult fail = TaskResult.fail((String)e.getErrorLocaleDescription());
            task.notifyTaskObs(fail);
            TaskResult taskResult = fail;
            return taskResult;
        }
        catch (Exception e) {
            log.error("Exec task error.", (Throwable)e);
            TaskResult fail = TaskResult.fail((String)ResourceUtil.getString("exec.error"));
            task.notifyTaskObs(fail);
            TaskResult taskResult = fail;
            return taskResult;
        }
        finally {
            this.postHandle(task);
        }
    }

    private void postHandle(ITask<TaskResult> task) {
        try {
            TaskResult taskResult = task.postHandle();
            log.info("uninstall patch result :{}", (Object)taskResult.getResult());
        }
        catch (ToolException toolException) {
            log.error("uninstall patch error", (Throwable)toolException);
        }
    }

    private void update(Object obj) {
        this.setChanged();
        this.notifyObservers(obj);
    }

    private void init() {
        this.addObserver(this.obs);
        File resultDirFile = new File(this.resultDir);
        if (!resultDirFile.exists()) {
            resultDirFile.mkdirs();
            return;
        }
        FileUtils.deleteAllInFolder(this.resultDir);
    }

    public ExecutorService(String resultDir, Observer obs) {
        this.resultDir = resultDir;
        this.obs = obs;
    }
}

