/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.common.server;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import java.io.File;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestWrapper {
    private static final Logger log = LoggerFactory.getLogger(RestWrapper.class);
    private static final String[] EMPTY_ARGS = new String[0];
    private static final String DEFAULT_ERROR_DESC = "exec.error";
    private String errorId = "exec.error";
    private String[] args = new String[0];
    private final DevNode devNode;

    public RestWrapper(DevNode devNode) {
        this.devNode = devNode;
    }

    public RestWrapper errMsg(String id, String ... args) {
        this.errorId = id;
        this.args = args;
        return this;
    }

    public ResponseInfo execGet(String url) throws ToolException {
        return this.execGet(url, null);
    }

    public ResponseInfo execGet(String url, Map params) throws ToolException {
        return this.checkResp(this.getConnection().execGet(url, params));
    }

    public ResponseInfo execPost(String url, Map params) throws ToolException {
        return this.checkResp(this.getConnection().execPost(url, params));
    }

    public ResponseInfo execPut(String url, Map param) throws ToolException {
        return this.checkResp(this.getConnection().execPut(url, param));
    }

    public ResponseInfo execGetFile(String url, Map params, String localPath) throws ToolException {
        return this.checkGetFileResp(this.getConnection().execGetFile(url, params, localPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseInfo execGetFileWithNewConn(String url, Map params, String localPath) throws ToolException {
        RestConnection rest = new RestConnection(this.devNode, this.devNode.isDsStorage());
        try {
            rest.login();
            ResponseInfo resp = rest.execGetFile(url, params, localPath);
            this.checkGetFileResp(resp);
            ResponseInfo responseInfo = resp;
            return responseInfo;
        }
        finally {
            rest.logOut();
        }
    }

    public ResponseInfo checkGetFileResp(ResponseInfo resp) throws ToolException {
        boolean success;
        long statusCode = resp.getStatusLine().getStatusCode();
        if (statusCode != 200L) {
            throw new ToolException(this.errorId, this.args);
        }
        File file = new File(resp.getContentMap().getOrDefault("filePath", ""));
        boolean bl = success = file.exists() && file.isFile();
        if (!success) {
            throw new ToolException(this.errorId, this.args);
        }
        return resp;
    }

    private RestConnection getConnection() throws ToolException {
        RestConnection conn = RestConnectionManager.getRestConnection((DevNode)this.devNode);
        if (conn == null) {
            log.error("Get conn for {} is null.", (Object)this.devNode.getIp());
            throw new ToolException(this.errorId, this.args);
        }
        return conn;
    }

    private ResponseInfo checkResp(ResponseInfo resp) throws ToolException {
        return this.checkResp(resp, "", EMPTY_ARGS);
    }

    private ResponseInfo checkResp(ResponseInfo resp, String errorKey, String ... args) throws ToolException {
        String validErrorKey;
        String string = validErrorKey = StringUtils.isNULLStr((String)errorKey) ? DEFAULT_ERROR_DESC : errorKey;
        if (resp == null) {
            throw new ToolException(validErrorKey, args);
        }
        long errorCode = (Long)((Object)resp.getContentMap().getOrDefault("errorCode", 0));
        if (errorCode != 0L) {
            log.error("Exec resp error code {}", (Object)errorCode);
            throw new ToolException(validErrorKey, args);
        }
        return resp;
    }

    public DevNode getDevNode() {
        return this.devNode;
    }
}

