/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.patch.dstorage.entity;

import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.ism.tool.service.collect.dstorage.entity.CollectConf;
import com.huawei.ism.tool.service.patch.dstorage.entity.ItemInfo;
import com.huawei.ism.tool.service.patch.entity.BasicPatchInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DstoragePatchInfo
extends BasicPatchInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(DstoragePatchInfo.class);
    private List<DstoragePatchInfo> backupPatchList = new ArrayList<DstoragePatchInfo>();
    private Type type = Type.NONE;
    private ParseType parseType = ParseType.DEFAULT;
    private List<String> itemIdList = new ArrayList<String>();
    private final List<String> nfvItemIds = new ArrayList<String>();
    private final List<ItemInfo> nfvItemInfos = new ArrayList<ItemInfo>();
    private List<ItemInfo> itemInfos = new ArrayList<ItemInfo>();
    private Map<DevNode, InstallStatus> installDevMap = new ConcurrentHashMap<DevNode, InstallStatus>();
    private String patchPathByCms = "";
    private boolean needCmsSign = false;
    private String patchPathByNfv = "";
    private String patchPathByNfvAndCms = "";
    private boolean needNfvSign = false;
    private List<CollectConf> collectItems;
    private Map<DevNode, List<String>> lastSelectedClusterNodesMap = new ConcurrentHashMap<DevNode, List<String>>();

    public boolean isNeedInstallPatch(List<String> selectedClusterNodes, DevNode devNode) {
        if (InstallStatus.NONE == this.queryInstalledStatus(devNode)) {
            return true;
        }
        List<String> lastSelectedClusterNodes = this.lastSelectedClusterNodesMap.get(devNode);
        if (lastSelectedClusterNodes == null || lastSelectedClusterNodes.isEmpty()) {
            return true;
        }
        if (lastSelectedClusterNodes.contains(selectedClusterNodes)) {
            return false;
        }
        if (selectedClusterNodes.size() != lastSelectedClusterNodes.size()) {
            return true;
        }
        return selectedClusterNodes.stream().anyMatch(selectedClusterNode -> !lastSelectedClusterNodes.stream().anyMatch(lastSelectedClusterNode -> lastSelectedClusterNode.equals(selectedClusterNode)));
    }

    public void updateSelecteNodes(DevNode devNode, List<String> selectedClusterNodes) {
        this.lastSelectedClusterNodesMap.put(devNode, selectedClusterNodes);
    }

    @Override
    public String getPatchPath() {
        if (this.needNfvSign) {
            if (this.needCmsSign) {
                return this.patchPathByNfvAndCms;
            }
            return this.patchPathByNfv;
        }
        if (this.needCmsSign) {
            return this.patchPathByCms;
        }
        return this.patchPath;
    }

    public void setPatchPathByCms(String patchPathByCms) {
        this.patchPathByCms = patchPathByCms;
    }

    public void setNeedCmsSign(boolean needCmsSign) {
        this.needCmsSign = needCmsSign;
        this.backupPatchList.forEach(info -> info.setNeedCmsSign(needCmsSign));
    }

    public Type getType() {
        return this.type;
    }

    public DstoragePatchInfo setType(Type type) {
        this.type = type;
        return this;
    }

    public void setBackupPatchList(List<DstoragePatchInfo> backupPatchList) {
        this.backupPatchList = backupPatchList;
    }

    public void setNeedNfvSign(boolean needNfvSign) {
        this.needNfvSign = needNfvSign;
        this.backupPatchList.forEach(info -> info.setNeedNfvSign(needNfvSign));
    }

    public void setPatchPathByNfv(String patchPathByNfv) {
        this.patchPathByNfv = patchPathByNfv;
    }

    public void setPatchPathByNfvAndCms(String patchPathByNfvAndCms) {
        this.patchPathByNfvAndCms = patchPathByNfvAndCms;
    }

    public boolean isSupportPatch(String devModel, String devVer) {
        if (ParseType.OLD.equals((Object)this.parseType)) {
            return this.supportProductModel.equals(devModel) && this.supportVersions.contains(devVer);
        }
        return this.supportProductModel.equals(devModel) && this.supportVersions.stream().anyMatch(supportVer -> devVer.contains((CharSequence)supportVer));
    }

    public ParseType getParseType() {
        return this.parseType;
    }

    public void setParseType(ParseType parseType) {
        this.parseType = parseType;
    }

    public List<DstoragePatchInfo> getBackupPatchList() {
        return this.backupPatchList;
    }

    public InstallStatus queryInstalledStatus(DevNode node) {
        return this.installDevMap.getOrDefault(node, InstallStatus.NONE);
    }

    public void updateDevInstalledStatus(DevNode node, InstallStatus status) {
        LOGGER.info("Update dev {} patch status {} .", (Object)node.getIp(), (Object)status);
        this.installDevMap.put(node, status);
    }

    public Type getPatchType() {
        return this.type;
    }

    public List<String> getItemIdList() {
        return this.itemIdList;
    }

    public void setItemIdList(List<String> itemIdList) {
        this.itemIdList = itemIdList;
    }

    public void initNfvItemIdList(List<String> itemIds) {
        this.nfvItemIds.clear();
        this.nfvItemIds.addAll(itemIds);
    }

    public List<String> getNfvItemIds() {
        return new ArrayList<String>(this.nfvItemIds);
    }

    public void initNfvItemInfos(List<ItemInfo> allPatchItem) {
        this.nfvItemInfos.clear();
        this.nfvItemInfos.addAll(allPatchItem);
    }

    public List<ItemInfo> getNfvItemInfos() {
        return new ArrayList<ItemInfo>(this.nfvItemInfos);
    }

    public void setItemInfos(List<ItemInfo> itemInfos) {
        this.itemInfos = itemInfos;
    }

    public List<ItemInfo> getItemInfos() {
        return this.itemInfos;
    }

    public void setCollectItems(List<CollectConf> collectItems) {
        this.collectItems = collectItems;
    }

    public List<CollectConf> getCollectItems() {
        return this.collectItems;
    }

    public Map<DevNode, List<String>> getLastSelectedClusterNodesMap() {
        return this.lastSelectedClusterNodesMap;
    }

    public static enum Type {
        INSPECT,
        COLLECT,
        FAULT_DIAGNOSE,
        NONE;


        public static String getURL(DevNode node, Type type) throws ToolException {
            if (INSPECT == type) {
                return RestUtil.getDstorageBaseUrl((DevNode)node) + "/cluster/inspection/patch";
            }
            if (COLLECT == type) {
                return RestUtil.getDstorageBaseUrl((DevNode)node) + "/cluster/collection/patch";
            }
            if (FAULT_DIAGNOSE == type) {
                return RestUtil.getDstorageBaseUrl((DevNode)node) + "/cluster/inspection/patch";
            }
            throw new ToolException("patch.invalid.type");
        }
    }

    public static enum InstallStatus {
        NONE,
        PART,
        INSTALLED;

    }

    public static enum ParseType {
        OLD,
        DEFAULT;


        public static ParseType value(String type) {
            if ("old".equals(type.toLowerCase(Locale.ENGLISH))) {
                return OLD;
            }
            return DEFAULT;
        }
    }
}

