/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.rest.controller;

import com.huawei.ism.tool.service.common.entity.SshProxyNode;
import com.huawei.ism.tool.service.common.entity.SshProxySubNode;
import com.huawei.ism.tool.service.rest.model.entity.Response;
import com.huawei.ism.tool.service.rest.service.device.SshProxyConfigService;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/proxy"})
public class ProxyController {
    private final SshProxyConfigService sshProxyConfigService = SshProxyConfigService.INS;

    @PostMapping(value={"/ssh/node"})
    public Response<Void> addOrModifySSHNode(@RequestParam(value="nodeId") String nodeId, @RequestParam(value="name") String name) {
        this.sshProxyConfigService.addOrModifyNode(nodeId, name);
        return Response.success();
    }

    @PutMapping(value={"/ssh/node"})
    public Response<Void> modifySSHNode(@RequestParam(value="nodeId") String nodeId, @RequestParam(value="name") String name) {
        this.sshProxyConfigService.addOrModifyNode(nodeId, name);
        return Response.success();
    }

    @DeleteMapping(value={"/ssh/node"})
    public Response<Void> deleteNode(@RequestParam(value="nodeId") String nodeId) {
        this.sshProxyConfigService.deleteNode(nodeId);
        return Response.success();
    }

    @PostMapping(value={"/ssh/subNode"})
    public Response<Void> addSshSubNode(@RequestBody SshProxyNode sshProxyNode) {
        sshProxyNode.getSubNodeList().forEach(subNode -> this.sshProxyConfigService.addOrModifySubNode(sshProxyNode.getNodeId(), (SshProxySubNode)subNode));
        return Response.success();
    }

    @PutMapping(value={"/ssh/subNode"})
    public Response<Void> modifySshSubNode(@RequestBody SshProxyNode sshProxyNode) {
        sshProxyNode.getSubNodeList().forEach(subNode -> this.sshProxyConfigService.addOrModifySubNode(sshProxyNode.getNodeId(), (SshProxySubNode)subNode));
        return Response.success();
    }

    @DeleteMapping(value={"/ssh/subNode"})
    public Response<Void> deleteSubNode(@RequestParam(value="nodeId") String nodeId, @RequestParam(value="subNodeId") String subNodeId) {
        this.sshProxyConfigService.deleteSubNode(nodeId, subNodeId);
        return Response.success();
    }

    @GetMapping(value={"/ssh/node"})
    public Response<List<SshProxyNode>> getSSHProxyList() {
        return Response.success(this.sshProxyConfigService.getProxyNodes());
    }
}

