/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi;

import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.SecretKey;
import org.owasp.esapi.crypto.CipherText;
import org.owasp.esapi.crypto.HashSpec;
import org.owasp.esapi.crypto.PlainText;
import org.owasp.esapi.crypto.SealSpec;
import org.owasp.esapi.crypto.VerifySignatureSpec;
import org.owasp.esapi.errors.EncryptionException;
import org.owasp.esapi.errors.IntegrityException;

public interface Encryptor {
    public String hash(String var1, String var2) throws EncryptionException;

    public String hash(String var1, String var2, int var3) throws EncryptionException;

    public byte[] hash(HashSpec var1) throws EncryptionException;

    public String hash(String var1, String var2, String var3, int var4) throws EncryptionException;

    public CipherText encrypt(PlainText var1) throws EncryptionException;

    public CipherText encrypt(SecretKey var1, PlainText var2) throws EncryptionException;

    public CipherText encrypt(SecretKey var1, PlainText var2, String var3) throws EncryptionException;

    public PlainText decrypt(CipherText var1) throws EncryptionException;

    public PlainText decrypt(SecretKey var1, CipherText var2) throws EncryptionException;

    public String sign(String var1, PrivateKey var2) throws EncryptionException;

    public String sign(String var1, PrivateKey var2, String var3) throws EncryptionException;

    public byte[] sign(byte[] var1, PrivateKey var2) throws EncryptionException;

    public byte[] sign(byte[] var1, PrivateKey var2, String var3) throws EncryptionException;

    public boolean verifySignature(String var1, String var2, PublicKey var3);

    public boolean verifySignature(String var1, String var2, PublicKey var3, String var4);

    public boolean verifySignature(VerifySignatureSpec var1);

    public String seal(String var1, long var2, PrivateKey var4, SecretKey var5) throws IntegrityException;

    public byte[] seal(SealSpec var1) throws IntegrityException;

    public String unseal(String var1) throws EncryptionException;

    public String unseal(String var1, PublicKey var2, SecretKey var3) throws EncryptionException;

    public byte[] unseal(byte[] var1, PublicKey var2, SecretKey var3) throws EncryptionException;

    public boolean verifySeal(String var1, PublicKey var2, SecretKey var3);

    public boolean verifySeal(byte[] var1, PublicKey var2, SecretKey var3);

    public long getRelativeTimeStamp(long var1);

    public long getTimeStamp();
}

