/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.owasp.esapi.Logger;
import org.owasp.esapi.errors.AccessControlException;
import org.owasp.esapi.errors.AuthenticationException;
import org.owasp.esapi.errors.EncryptionException;
import org.owasp.esapi.errors.ValidationException;

public interface HTTPUtilities {
    public static final String REMEMBER_TOKEN_COOKIE_NAME = "rtoken";
    public static final int MAX_COOKIE_LEN = 4096;
    public static final int MAX_COOKIE_PAIRS = 20;
    public static final String CSRF_TOKEN_NAME = "ctoken";
    public static final String ESAPI_STATE = "estate";
    public static final int PARAMETER = 0;
    public static final int HEADER = 1;
    public static final int COOKIE = 2;

    public void addCookie(HttpServletResponse var1, Cookie var2);

    public String createCSRFToken();

    public void addHeader(HttpServletResponse var1, String var2, String var3);

    public void assertSecureChannel() throws AccessControlException;

    public void assertSecureRequest(HttpServletRequest var1) throws AccessControlException;

    public void assertSecureChannel(HttpServletRequest var1) throws AccessControlException;

    public HttpSession changeSessionIdentifier(HttpServletRequest var1) throws AuthenticationException;

    public void clearCurrent();

    public String decryptHiddenField(String var1, SecretKey var2);

    public Map<String, String> decryptQueryString(String var1, SecretKey var2) throws EncryptionException;

    public Map<String, String> decryptStateFromCookie(HttpServletRequest var1, SecretKey var2) throws EncryptionException;

    public String encryptHiddenField(String var1, SecretKey var2) throws EncryptionException;

    public String encryptQueryString(String var1, SecretKey var2) throws EncryptionException;

    public void encryptStateInCookie(HttpServletResponse var1, Map<String, String> var2, SecretKey var3) throws EncryptionException;

    public String getCookie(HttpServletRequest var1, String var2) throws ValidationException;

    public HttpServletRequest getCurrentRequest();

    public HttpServletResponse getCurrentResponse();

    public String getHeader(HttpServletRequest var1, String var2) throws ValidationException;

    public String getParameter(HttpServletRequest var1, String var2) throws ValidationException;

    public void killAllCookies(HttpServletRequest var1, HttpServletResponse var2);

    public void killCookie(HttpServletRequest var1, HttpServletResponse var2, String var3);

    public void logHTTPRequest(HttpServletRequest var1, Logger var2, List var3);

    public void sendRedirect(HttpServletResponse var1, String var2) throws AccessControlException, IOException;

    public void setContentType(HttpServletResponse var1);

    public void setCurrentHTTP(HttpServletRequest var1, HttpServletResponse var2);

    public void setHeader(HttpServletResponse var1, String var2, String var3);

    public void setNoCacheHeaders(HttpServletResponse var1);

    public <T> T getSessionAttribute(String var1);
}

