/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.codecs;

import org.owasp.esapi.codecs.AbstractCodec;
import org.owasp.esapi.codecs.PushbackString;

public abstract class AbstractCharacterCodec
extends AbstractCodec<Character> {
    @Override
    public String decode(String input) {
        StringBuilder sb = new StringBuilder();
        PushbackString pbs = new PushbackString(input);
        while (pbs.hasNext()) {
            Character c = this.decodeCharacter(pbs);
            if (c != null) {
                sb.append(c);
                continue;
            }
            sb.append(pbs.next());
        }
        return sb.toString();
    }

    @Override
    public String encodeCharacter(char[] immune, int codePoint) {
        return new StringBuilder().appendCodePoint(codePoint).toString();
    }

    public Character decodeCharacterForDataBase(PushbackString input) {
        input.mark();
        Character first = input.next();
        if (first == null) {
            input.reset();
            return null;
        }
        if (first.charValue() != '\'') {
            input.reset();
            return null;
        }
        Character second = input.next();
        if (second == null) {
            input.reset();
            return null;
        }
        if (second.charValue() != '\'') {
            input.reset();
            return null;
        }
        return Character.valueOf('\'');
    }
}

