/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.util;

import java.util.ArrayList;
import java.util.List;

public class CsvString {
    private final char QUOTE_MATCHER = (char)34;
    private final char DELIM_MATCHER = (char)44;

    public int isMatchTrim(char[] buffer, int position) {
        return buffer[position] > ' ' ? 0 : 1;
    }

    public int isMatchChar(char[] buffer, int position, char ch) {
        return ch != buffer[position] ? 0 : 1;
    }

    public List<String> getCsvStringList(String inPutString) {
        if (inPutString == null || inPutString.length() == 0) {
            throw new IllegalArgumentException("inPutString is null or empty");
        }
        if (inPutString.length() >= 10000) {
            throw new IllegalArgumentException("inPutString maxLength is 10000");
        }
        char[] chars = inPutString.toCharArray();
        return this.getCsvStringListFormCharArray(chars, chars.length);
    }

    protected List<String> getCsvStringListFormCharArray(char[] chars, int count) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> csvResultList = new ArrayList<String>();
        int position = 0;
        while (position >= 0 && position < count) {
            if ((position = this.readNextCsvString(chars, position, count, stringBuilder, csvResultList)) < count) continue;
            csvResultList.add("");
        }
        return csvResultList;
    }

    private int readNextCsvString(char[] chars, int startPosition, int len, StringBuilder workArea, List<String> csvResultList) {
        int removeLen;
        while (startPosition < len && (removeLen = this.isMatchTrim(chars, startPosition)) != 0 && this.isMatchChar(chars, startPosition, ',') <= 0 && this.isMatchChar(chars, startPosition, '\"') <= 0) {
            startPosition += removeLen;
        }
        if (startPosition >= len) {
            csvResultList.add("");
            return -1;
        }
        int delimLen = this.isMatchChar(chars, startPosition, ',');
        if (delimLen > 0) {
            csvResultList.add("");
            return startPosition + delimLen;
        }
        int quotationLen = this.isMatchChar(chars, startPosition, '\"');
        if (quotationLen > 0) {
            return this.readWithQuotations(chars, startPosition + quotationLen, len, workArea, csvResultList, startPosition, quotationLen);
        }
        return this.readWithQuotations(chars, startPosition, len, workArea, csvResultList, 0, 0);
    }

    private int readWithQuotations(char[] chars, int start, int len, StringBuilder splitWord, List<String> csvResultList, int quotationStart, int quotationLen) {
        splitWord.setLength(0);
        int position = start;
        boolean quoting = quotationLen > 0;
        int trimStart = 0;
        while (position < len) {
            if (quoting) {
                if (this.isDoubleQuotation(chars, position, len, quotationStart, quotationLen)) {
                    if (this.isDoubleQuotation(chars, position + quotationLen, len, quotationStart, quotationLen)) {
                        splitWord.append(chars, position, quotationLen);
                        position += quotationLen * 2;
                        trimStart = splitWord.length();
                        continue;
                    }
                    quoting = false;
                    position += quotationLen;
                    continue;
                }
            } else {
                int separatorLen = this.isMatchChar(chars, position, ',');
                if (separatorLen > 0) {
                    csvResultList.add(splitWord.substring(0, trimStart));
                    return position + separatorLen;
                }
                if (quotationLen > 0 && this.isDoubleQuotation(chars, position, len, quotationStart, quotationLen)) {
                    quoting = true;
                    position += quotationLen;
                    continue;
                }
                int trimmedLen = this.isMatchTrim(chars, position);
                if (trimmedLen > 0) {
                    splitWord.append(chars, position, trimmedLen);
                    position += trimmedLen;
                    continue;
                }
            }
            splitWord.append(chars[position++]);
            trimStart = splitWord.length();
        }
        csvResultList.add(splitWord.substring(0, trimStart));
        return -1;
    }

    private boolean isDoubleQuotation(char[] chars, int position, int length, int quoteStart, int quotationLen) {
        for (int i = 0; i < quotationLen; ++i) {
            if (i + position < length && chars[i + position] == chars[i + quoteStart]) continue;
            return false;
        }
        return true;
    }
}

