/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.util;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.prng.SP800SecureRandom;
import org.bouncycastle.crypto.prng.SP800SecureRandomBuilder;
import org.owasp.esapi.errors.EncryptionException;

public class RandomUtil {
    private static final int CIPHER_LEN = 256;
    private static final int ENTROPY_BITS_REQUIRED = 384;

    public static SecureRandom getBcStrongRandom() throws EncryptionException {
        SP800SecureRandom secureRandom;
        try {
            SecureRandom source = SecureRandom.getInstanceStrong();
            boolean predictionResistant = true;
            AESEngine cipher = new AESEngine();
            byte[] nonce = null;
            boolean reSeed = false;
            secureRandom = new SP800SecureRandomBuilder(source, predictionResistant).setEntropyBitsRequired(384).buildCTR((BlockCipher)cipher, 256, nonce, reSeed);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new EncryptionException("Error creating randomizer", "Can't find random algorithm.", ex);
        }
        return secureRandom;
    }

    public static SecureRandom getStrongRandom() throws EncryptionException {
        SecureRandom secureRandom;
        try {
            secureRandom = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new EncryptionException("Error creating randomizer", "Can't find random algorithm.", ex);
        }
        return secureRandom;
    }

    public static SecureRandom getRandom(String algorithm) throws EncryptionException {
        SecureRandom secureRandom;
        try {
            secureRandom = SecureRandom.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new EncryptionException("Error creating randomizer", "Can't find random algorithm.", ex);
        }
        return secureRandom;
    }
}

