/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.rest;

import java.util.Date;

public class DownFileObserver {
    private static final double D1024 = 1024.0;
    private static final double D1000 = 1000.0;
    private static final long ONE_HUNDRED = 100L;
    private long fileSize;
    private long nowDowSize = 0L;
    private long startTime;
    private volatile boolean isFinished = false;

    public void init(long fileSize, long startTime) {
        this.fileSize = fileSize;
        this.startTime = startTime;
        this.nowDowSize = 0L;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getNowDowSize() {
        return this.nowDowSize;
    }

    public void addSize(long addSize) {
        this.nowDowSize += addSize;
    }

    public long getProgress() {
        if (this.nowDowSize > this.fileSize) {
            return 100L;
        }
        return this.nowDowSize * 100L / this.fileSize;
    }

    public double getDownloadRate() {
        long nowTime = new Date().getTime();
        double timeDifference = nowTime - this.startTime;
        return (double)this.nowDowSize * 1000.0 / 1024.0 / 1024.0 / timeDifference;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public void setFinished(boolean isFinished) {
        this.isFinished = isFinished;
    }
}

