/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.rest;

import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.entity.RequestInfo;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.FusionComputeRestUtils;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.hc.core5.http.NameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FcRestConnection
extends RestConnection {
    private static final Logger log = LoggerFactory.getLogger(FcRestConnection.class);
    private static final Map<String, String> DEFAULT_HEADER = new HashMap<String, String>();
    private String baseUri;

    public FcRestConnection(DevNode devNode) {
        super(FusionComputeRestUtils.getLoginUrl(devNode), devNode);
        this.devNode = devNode;
    }

    @Override
    protected void setLoginParam(RequestInfo req) {
        Map<String, String> headers = req.getHeaders();
        headers.put("X-Auth-Key", this.devNode.getAdminUser().getPassword());
        headers.put("X-Auth-User", this.devNode.getAdminUser().getUserName());
        headers.put("X-ENCRIPT-ALGORITHM", "1");
        headers.put("X-Auth-UserType", "0");
        headers.putAll(DEFAULT_HEADER);
    }

    @Override
    public ResponseInfo login() throws ToolException {
        ResponseInfo loginResponse = super.login(false);
        if (this.isLogin()) {
            this.queryBaseUri();
        }
        return loginResponse;
    }

    @Override
    protected boolean checkLoginResult(ResponseInfo resp) throws ToolException {
        if (this.getErrorCode(resp).equals("0")) {
            String authToken = this.findAuthToken(resp);
            this.setAuthToken(authToken);
            this.session.setToken(authToken);
            return true;
        }
        log.warn("login failed {}", (Object)resp.getContent());
        return false;
    }

    private void queryBaseUri() {
        try {
            ResponseInfo responseInfo = this.execGet(FusionComputeRestUtils.getBaseUrl(this.devNode));
            JSONObject jsonObject = new JSONObject(responseInfo.getContent());
            if (jsonObject.has("sites")) {
                JSONArray sites = jsonObject.getJSONArray("sites");
                this.baseUri = sites.getJSONObject(0).getStringOrDefault("uri", "");
            }
        }
        catch (ToolException e) {
            log.warn("query :{} site_id failed", (Object)this.devNode.getIp(), (Object)e);
        }
    }

    private String findAuthToken(ResponseInfo resp) {
        return Arrays.stream(resp.getHeaders()).filter(header -> "X-Auth-Token".equals(header.getName())).map(NameValuePair::getValue).findFirst().orElse("");
    }

    @Override
    protected void createHeader(RequestInfo req, Map headerParam) {
        req.setHeader("Accept-Language", ApplicationContext.getInstance().getCurrentLanguage().getLanguage());
        req.setHeader("X-Auth-Token", this.session.getToken());
        req.getHeaders().putAll(DEFAULT_HEADER);
        if (MapUtils.isEmpty((Map)headerParam)) {
            return;
        }
        for (Object key : headerParam.keySet()) {
            req.setHeader(key.toString(), headerParam.get(key).toString());
        }
    }

    @Override
    public boolean isNeedReLogin(ResponseInfo resp) {
        if (super.isNeedReLogin(resp)) {
            return true;
        }
        return this.getErrorCode(resp).equals("10000002");
    }

    private String getErrorCode(ResponseInfo responseInfo) {
        JSONObject jsonObject = new JSONObject(responseInfo.getContent());
        return jsonObject.getStringOrDefault("errorCode", "0");
    }

    @Override
    public void closeSession() {
        try {
            this.execDelete(FusionComputeRestUtils.getLoginUrl(this.devNode));
        }
        catch (ToolException e) {
            log.warn("exec delete fusion compute :{} session failed", (Object)this.devNode.getIp(), (Object)e);
        }
        catch (Exception e) {
            log.error("delete session failed. may not connected");
        }
        super.closeSession();
    }

    @Override
    public String getBaseUrl() {
        return this.baseUri;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    static {
        DEFAULT_HEADER.put("Accept", "application/json;version=6.3;charset=UTF-8");
        DEFAULT_HEADER.put("Content-Type", "application/json;charset=UTF-8");
    }
}

