/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.sftp;

import com.huawei.ism.tool.obase.connection.support.SftpProgressMonitor;
import com.huawei.ism.tool.protocol.sftp.SftpProgressInterface;

public class SftpTransferProgress
implements SftpProgressMonitor {
    private static final float MAGIC_NUMBER = 100.0f;
    private long fileSize;
    private long finishSize;
    private SftpProgressInterface progressInterface;

    public synchronized void setFinishSize(long finishSize) {
        this.finishSize = finishSize;
    }

    public void setProgressInterface(SftpProgressInterface progressInterface) {
        this.progressInterface = progressInterface;
    }

    public SftpProgressInterface getProgressInterface() {
        return this.progressInterface;
    }

    private void fireProgressUpdate() {
        if (null != this.progressInterface) {
            int progress = this.getCurrentStep();
            this.progressInterface.refreshSftpProgress(progress);
        }
    }

    @Override
    public synchronized void init(int tansferState, String sourcePath, String destinationPath, long size) {
        this.fileSize = size;
        this.fireProgressUpdate();
    }

    @Override
    public synchronized boolean count(long mount) {
        this.finishSize += mount;
        this.fireProgressUpdate();
        return true;
    }

    @Override
    public synchronized void end() {
        this.finishSize = this.fileSize;
        this.fireProgressUpdate();
    }

    public synchronized int getCurrentStep() {
        if (0L == this.fileSize) {
            return 0;
        }
        if (this.fileSize == this.finishSize) {
            return 100;
        }
        float currentStep = (float)this.finishSize / (float)this.fileSize * 100.0f;
        return (int)currentStep;
    }

    public synchronized long getFileSize() {
        return this.fileSize;
    }

    public synchronized long getFinishSize() {
        return this.finishSize;
    }
}

