/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.utils;

import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionComputeRestUtils {
    private static final Logger log = LoggerFactory.getLogger(FusionComputeRestUtils.class);

    private static String getPrUrl(DevNode devNode) {
        return RestUtil.getHttpsPrefixWithNode(devNode) + devNode.getTlvPort();
    }

    public static String getLoginUrl(DevNode devNode) {
        return FusionComputeRestUtils.getPrUrl(devNode) + "/service/session";
    }

    public static String getBaseUrl(DevNode devNode) {
        return FusionComputeRestUtils.getPrUrl(devNode) + "/service/sites";
    }

    public static String getQueryHostUrl(DevNode devNode, String baseUri) {
        return FusionComputeRestUtils.getPrUrl(devNode) + baseUri + "/hosts";
    }

    public static void checkResponse(ResponseInfo responseInfo) throws ToolException {
        JSONObject jsonObject = new JSONObject(responseInfo.getContent());
        String code = jsonObject.getStringOrDefault("errorCode", "0");
        if (!"0".equals(code)) {
            throw new ToolException("fusion.compute.rest.error", new Object[]{code});
        }
    }

    public static String getQueryVrmNodeUrl(DevNode devNode, String baseUri) {
        return FusionComputeRestUtils.getPrUrl(devNode) + baseUri + "/vms?group=VRMGroup";
    }

    public static String getQueryVrmPhysicUrl(DevNode devNode, String baseUri) {
        return FusionComputeRestUtils.getPrUrl(devNode) + baseUri + "/vrms";
    }

    public static String getQuerySnUrl(DevNode devNode, String baseUrl) {
        return FusionComputeRestUtils.getPrUrl(devNode) + baseUrl + "licservice/getESN?method=query";
    }
}

