#!/bin/bash
CURRENT_PATH=$(cd "$(dirname "$0")"; pwd)
export CUSTOM_INSTALL_PREFIX="${CURRENT_PATH%/opt/*}"
readonly LOCKFILE="${CUSTOM_INSTALL_PREFIX}/opt/.compute_upgrade.lock"
readonly LOG_FILE="/var/log/deploy/scripts/compute.action.log"
readonly curl_tool="${CUSTOM_INSTALL_PREFIX}/opt/fusionstorage/repository/deploymanager_pkg/micro/clouda_1.0.0/action/curl_tool.py"
readonly CLOUDA_CONFIG="${CUSTOM_INSTALL_PREFIX}/opt/fusionstorage/deploymanager/clouda/conf/cloudagent.ini"
readonly BAK_CLOUDA_CONFIG="${CURRENT_PATH}/cloudagent.ini"
readonly package_name="OceanStor-Distributed-Compute"
readonly patch_package_name="OceanStor-Distributed-Compute-HotPatch"
BASE_PATH="${CUSTOM_INSTALL_PREFIX}/opt/fusionstorage/deploymanager/compute_upgrade"
FILE_PATH="${BASE_PATH}/compute_package"
PATCH_FILE_PATH="${BASE_PATH}/compute_patch_package"
SCRIPTNAME=$(basename $0)
ARCH=$(uname -m)
download_upgrade="upgrade"
download_rollback="rollback"
download_patch="upgrade_patch"
status_initial="initial"
status_running="running"
status_success="success"
status_failed="failed"
PYTHON_BASH="python"
role=`cat ${CUSTOM_INSTALL_PREFIX}/opt/network/network_config.ini | grep "role" | awk -F '=' '{print $2}' | sed 's/^[ \t\n]*//g' | sed 's/[ \t\n]*$//g'`

function log()
{
    local param1=$1
    local param2=$2
    local param3=$3

    echo "[$(date +'%F %T')][${param1}][${param2}]${param3}"
    if [ ! -f "${LOG_FILE}" ]; then
        log_path=`dirname "${LOG_FILE}"`
        mkdir -p "${log_path}"
        [ ! -L "${log_path}" ] && chmod 750 "${log_path}"
        touch "${LOG_FILE}"
        [ ! -L "${LOG_FILE}" ] && chmod 640 "${LOG_FILE}"
    fi
    [ ! -L "${LOG_FILE}" ] && echo "[$(date +'%F %T')][${param1}][${param2}]${param3}" >> "${LOG_FILE}" 2>/dev/null
}

python_version()
{
    command -v python
    if [ $? -ne 0 ]; then
        command -v python3
        if [ $? -ne 0 ]; then
            log "[Line:${LINENO}][Error] The python is not exist!"
            exit 1
        fi
        PYTHON_BASH="python3"
    fi
}

function back_dependency_file()
{
    if [ ! -f "${BAK_CLOUDA_CONFIG}" ]; then
       \cp -f "${CLOUDA_CONFIG}" "${CURRENT_PATH}"
       chmod 550 "${BAK_CLOUDA_CONFIG}"
    fi
}

function check_param()
{
    #检查参数 $1 token $2 flag $3 float_ip
    local status_flag=$1
    local float_ip_param=$2
    back_dependency_file
    local float_ip=`grep -aw "cloudm_float_ip" "${BAK_CLOUDA_CONFIG}" | awk -F '=' '{print $2}'`
    if [ "${float_ip_param}x" != "${float_ip}x" ];then
        log $SCRIPTNAME $FUNCNAME "[ERROR] ${float_ip_param} is not right, ${float_ip_param}, ${float_ip}"
        set_failed
        return 1
    fi
    return 0
}

function download_by_curl()
{
    local target_path=$1
    local target_file=$2
    log $SCRIPTNAME $FUNCNAME "[INFO] start download package by curl with ${platform}"
    local token="X-Auth-Token:${TOKEN}"
    timeout -s 9 60m curl -sgkX GET --noproxy '*' -H@- "https://${float_ip}:6098/api/v2/deploy_manager/get_compute_package?type=${type}&platform=${platform}" -o "${target_path}/${target_file}"<<EOF
${token}
EOF
    tar -tf "${target_path}/${target_file}" >> ${LOG_FILE}
    if [ $? -eq 0 ]; then
        return 0
    fi

    log $SCRIPTNAME $FUNCNAME "[INFO] start download package by curl without platform"
    timeout -s 9 60m curl -sgkX GET --noproxy '*' -H@- "https://${float_ip}:6098/api/v2/deploy_manager/get_compute_package?type=${type}" -o "${target_path}/${target_file}"<<EOF
${token}
EOF
    tar -tf "${target_path}/${target_file}" >> ${LOG_FILE}
    return $?
}

function download_from_fsm() {
    local target_path=$1
    local target_file=$2
    log $SCRIPTNAME $FUNCNAME "[INFO] start download package with ${platform}"
    timeout -s 9 60m ${PYTHON_BASH} "${curl_tool}" "https://${float_ip}:6098/api/v2/deploy_manager/get_compute_package?type=${type}&platform=${platform}" "GET" "wget_resource" "${target_path}" "${target_file}" << EOF
""
"${TOKEN}"
EOF
    tar -tf "${target_path}/${target_file}" >> ${LOG_FILE}
    if [ $? -eq 0 ]; then
        return 0;
    fi

    log $SCRIPTNAME $FUNCNAME "[INFO] start download package without platform"
    timeout -s 9 60m ${PYTHON_BASH} "${curl_tool}" "https://${float_ip}:6098/api/v2/deploy_manager/get_compute_package?type=${type}" "GET" "wget_resource" "${target_path}" "${target_file}" << EOF
""
"${TOKEN}"
EOF
    tar -tf "${target_path}/${target_file}" >> ${LOG_FILE}
    if [ $? -eq 0 ]; then
        return 0;
    fi
    return 1
}

function download_package()
{
    local type="$1"
    local float_ip="$2"
    local TOKEN="$3"
    local platform=$(uname -m)
    if [[ ${float_ip} =~ ":" ]];then
        float_ip="[${float_ip}]"
    fi
    temp_file=compute_upgrade.tar.gz
    rm -rf ${FILE_PATH}
    mkdir -p ${FILE_PATH}
    python_version
    cd ${FILE_PATH}
    which curl>/dev/null 2>&1
    local has_curl=$?
    curl -h | grep '\-H' | grep -q '@file'
    ((has_curl = has_curl + $?))
    local count=0
    while true; do
        let count+=1
        if [ "${has_curl}" -eq 0 ]; then
            download_by_curl "${FILE_PATH}" "${temp_file}"
            if [ $? -ne 0 ]; then
                download_from_fsm "${FILE_PATH}" "${temp_file}"
            fi
        else
            download_from_fsm "${FILE_PATH}" "${temp_file}"
        fi
        if [ $? -eq 0 ]; then
            tar -xzf ${FILE_PATH}/${temp_file}
            if [ $? -eq 0 ]; then
                log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO] success to download package from ${float_ip}, count:${count}"
                break
            else
                log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] failed to uncompress"
            fi
        fi
        if [ ${count} -ge 3 ]; then
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] failed to download package from ${float_ip}, count:${count}"
            return 1
        fi
        [ -d "${FILE_PATH}" ] && rm -rf ${FILE_PATH}/*
        sleep 10
    done
    pkg_name=`ls ${FILE_PATH} | grep "${package_name}"`
    chown -hR root:root ${FILE_PATH}/${pkg_name}
    mv "${FILE_PATH}/${pkg_name}" "${FILE_PATH}/${package_name}"
    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO] success to download package [${pkg_name}] from ${float_ip}"
    return 0
}

function upgrade_status()
{
    local status="$1"
    if [ ! -d "${BASE_PATH}" ]; then
        mkdir -p "${BASE_PATH}"
    fi
    if [ ! -f "${UPGRADE_STATUS_PATH}" ]; then
        echo "UPGRADE_FLAG" > ${UPGRADE_STATUS_PATH}
        echo "upgrade_time_flag=initial" >> ${UPGRADE_STATUS_PATH}
        echo "UPGRADE_STATUS" >> ${UPGRADE_STATUS_PATH}
        echo "status=initial" >> ${UPGRADE_STATUS_PATH}
        echo "progress=0" >> ${UPGRADE_STATUS_PATH}
    fi
    sed -i "s/^status=.*/status=${status}/g" ${UPGRADE_STATUS_PATH}
    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO] Set the upgrade status to [${status}]:$?."
}

function query_patch_package()
{
    local float_ip="$1"
    local TOKEN="$2"
    if [[ ${float_ip} =~ ":" ]];then
        float_ip="[${float_ip}]"
    fi
    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO] Start to query whether need download patch package"
    for i in {1..3} ; do
        result=`timeout -s 9 60m ${PYTHON_BASH} "${curl_tool}" "https://${float_ip}:6098/api/v2/deploy_manager/has_compute_package?platform=${ARCH}" "GET"<< EOF
""
"${TOKEN}"
EOF
`
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO]Query patch package existence result ${result}"
        echo ${result}| grep -wq "[ |u]*'code':[ |u]*'0'"
        if [ $? -ne 0 ]; then
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] Query patch package existence failed"
            if [ $i -ne 3 ]; then
                sleep 10
            else
                return 1
            fi
        else
            echo ${result}| grep -wq "[ |u]*'data':[ |u]*'success'"
            if [ $? -eq 0 ]; then
                log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO] Patch package exist, need to download."
                return 0
            else
                log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO] Patch package not exist, no need to download."
                return 1
            fi
        fi
    done
    return 2
}

function download_patch_package()
{
    local type="$1"
    local float_ip="$2"
    local TOKEN="$3"
    local platform=$(uname -m)
    if [[ ${float_ip} =~ ":" ]];then
        float_ip="[${float_ip}]"
    fi
    local patch_temp_file=compute_patch_upgrade.tar.gz
    rm -rf ${PATCH_FILE_PATH}
    mkdir -p ${PATCH_FILE_PATH}
    python_version
    cd ${PATCH_FILE_PATH}
    which curl>/dev/null 2>&1
    local has_curl=$?
    curl -h | grep '\-H' | grep -q '@file'
    ((has_curl = has_curl + $?))
    local count=0
    while true; do
        let count+=1
        if [ "${has_curl}" -eq 0 ]; then
            download_by_curl "${PATCH_FILE_PATH}" "${patch_temp_file}"
            if [ $? -ne 0 ]; then
                download_from_fsm "${PATCH_FILE_PATH}" "${patch_temp_file}"
            fi
        else
            download_from_fsm "${PATCH_FILE_PATH}" "${patch_temp_file}"
        fi
        if [ $? -eq 0 ]; then
            tar -xzf ${PATCH_FILE_PATH}/${patch_temp_file}
            if [ $? -eq 0 ]; then
                log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO] success to download package from ${float_ip}, count:${count}"
                break
            else
                log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] failed to uncompress"
            fi
        fi
        if [ ${count} -ge 3 ]; then
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] failed to download package from ${float_ip}, count:${count}"
            return 1
        fi
        [ -d "${PATCH_FILE_PATH}" ] && rm -rf ${PATCH_FILE_PATH}/*
        sleep 10
    done
    local patch_pkg_name=`ls ${PATCH_FILE_PATH} | grep "${package_name}"`
    chown -hR root:root ${PATCH_FILE_PATH}/${patch_pkg_name}
    mv "${PATCH_FILE_PATH}/${patch_pkg_name}" "${FILE_PATH}/${patch_package_name}"
    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO] success to download package [${patch_pkg_name}] from ${float_ip}"
    return 0
}

function config_upgrade_mark_info()
{
    task_type=$1
    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO] Start generating mark information."
    if [ ! -d "${CUSTOM_INSTALL_PREFIX}/opt/fusionstorage" ]; then
        mkdir ${CUSTOM_INSTALL_PREFIX}/opt/fusionstorage
        chmod 755 ${CUSTOM_INSTALL_PREFIX}/opt/fusionstorage
    fi
    local SCENES_INFO="${CUSTOM_INSTALL_PREFIX}/opt/fusionstorage/deploy.ini"
    if [ -f "${SCENES_INFO}" ];then
        local sences=$(cat ${SCENES_INFO} | grep "scenes=" | awk -F "=" '{print $2}')
        if [ "${sences}" == "rollback" ];then
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO] current sences is rollback can not upgrade."
            exit 1
        fi
    fi
    echo "[deploy]" > ${SCENES_INFO}
    echo "scenes=${task_type}" >> ${SCENES_INFO}
    chmod 644 ${SCENES_INFO}
}

function restore_upgrade_mark_info()
{
    local SCENES_INFO="${CUSTOM_INSTALL_PREFIX}/opt/fusionstorage/deploy.ini"
    if [ ! -f "${SCENES_INFO}" ];then
        return 0
    fi
    echo "[deploy]" > ${SCENES_INFO}
    echo "scenes=preinstall" >> ${SCENES_INFO}
    chmod 644 ${SCENES_INFO}
}
