#!/bin/bash

CURRENT_PATH=$(cd "$(dirname "$0")"; pwd)
SCRIPTNAME=$(basename $0)
source ${CURRENT_PATH}/common.sh
UPGRADE_STATUS_PATH="${BASE_PATH}/compute_rollback.ini"
NOT_RETRY=8

function whether_step_has_start()
{
    grep -rai "=1" ${CUSTOM_INSTALL_PREFIX}/opt/fusionstorage/repository/components/step >/dev/null 2>&1
    if [ $? -eq 0 ]; then
        return 0
    fi
    grep -rai "=2" ${CUSTOM_INSTALL_PREFIX}/opt/fusionstorage/repository/components/step >/dev/null 2>&1
    if [ $? -eq 0 ]; then
        return 0
    fi
    return 1
}

function rollback_when_failed()
{
    # 1、升级失败，调用回滚
    scenes=`grep -aw "scenes" ${CUSTOM_INSTALL_PREFIX}/opt/fusionstorage/deploy.ini | awk -F '=' '{print $2}'`
    if [ "${scenes}"x == "upgrade"x ]; then
        if [ ! -d "${CUSTOM_INSTALL_PREFIX}/opt/fusionstorage/repository/components/step" ]; then
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO] no need to perform the rollback!"
            restore_upgrade_mark_info
            return 0
        fi
        whether_step_has_start
        if [ $? -ne 0 ];then
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO] no need to perform the rollback!"
            restore_upgrade_mark_info
            return 0
        fi
        bash "${FILE_PATH}/${package_name}/action/rollback.sh"
        if [ $? -ne 0 ]; then
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] Failed to perform the rollback!"
            upgrade_status "${status_failed}"
            return 1
        fi
        return 0
    fi
    # 2、已经回滚失败，调用回滚
    if [ "${scenes}"x == "rollback"x ]; then
        bash "${FILE_PATH}/${package_name}/action/rollback.sh"
        if [ $? -ne 0 ]; then
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] Failed to perform the rollback!"
            upgrade_status "${status_failed}"
            return 1
        fi
        return 0
    fi
    return ${NOT_RETRY}
}

function main()
{
    #检查参数
    local params="$1"
    token=$(echo "${params}" | awk '{print $1}')
    flag=$(echo "${params}" | awk '{print $2}')
    float_ip=$(echo "${params}" | awk '{print $3}')
    rm -rf "${UPGRADE_STATUS_PATH}"
    upgrade_status "${status_initial}"
    check_param "${flag}" "${float_ip}"
    if [ $? -ne 0 ]; then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] Failed to check parameters!"
        upgrade_status "${status_failed}"
        return 1
    fi
    upgrade_status "${status_running}"

    rollback_when_failed
    ret=$?
    if [ ${ret} -eq 0 ]; then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO] Rollback retry succeeded.!"
        upgrade_status "${status_success}"
        rm -rf "${FILE_PATH}"
        return 0
    fi
    if [ ${ret} -ne ${NOT_RETRY} ]; then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] Failed to execute the rollback!"
        upgrade_status "${status_failed}"
        return 1
    fi

    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][WARN] The upgrade is successful and the downgrade starts!"
    download_package "${download_rollback}" "${float_ip}" "${token}"
    if [ $? -ne 0 ]; then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] Failed to download the downgrade package!"
        upgrade_status "${status_failed}"
        return 1
    fi
    bash ${FILE_PATH}/${package_name}/action/upgrade.sh downgrade
    if [ $? -ne 0 ]; then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] Failed to perform the downgrade!"
        upgrade_status "${status_failed}"
        return 1
    fi
    upgrade_status "${status_success}"
    rm -rf "${FILE_PATH}"
	rm -f "${BAK_CLOUDA_CONFIG}"
    return 0
}

{
    flock -n 3
    if [ $? -eq 1 ]; then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] Another task is being executed, try it later."
        exit 1
    fi
    echo "$$" > ${LOCKFILE}
    read -rs parameters
    main "${parameters}"
    ret=$?

    flock -u 3
} 3<>${LOCKFILE}
exit ${ret}
